/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.dialogs.BrowseZfsDialog;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ZfsBackupControls {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public Button backup;
    public Spinner backupCount;
    public TextInput backupDir;
    public Text backupDirText;
    private Button backupDirBrowseButton;
    private Label backupCountLabel;
    private Label backupDirLabel;
    private TextInput backupDirInput;
    private ControlDecoration backupDirDec;
    private ControlDecoration backupCountDec;
    private ControlDecoration backupDec;

    public ZfsBackupControls(final Composite parent, int style, FormToolkit toolkit) {
        this.backup = new Button(parent, 32);
        this.backup.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.backup.setText(Messages.getString("Configuration.zfs.backup"));
        this.backupDec = Utilities.addMandatoryField((Control)this.backup);
        Composite comp = toolkit == null ? new Composite(parent, style) : toolkit.createComposite(parent, style);
        GridLayout layoutMain = new GridLayout(3, false);
        layoutMain.horizontalSpacing = 15;
        comp.setLayout((Layout)layoutMain);
        comp.setLayoutData((Object)new GridData(4, -1, true, false));
        this.backupCountLabel = new Label(comp, 0);
        this.backupCountLabel.setText(Messages.getString("Configuration.zfs.backupcount"));
        this.backupCountLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        this.backupCountDec = Utilities.addMandatoryField((Control)this.backupCountLabel);
        this.backupCountLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ZfsBackupControls.this.backupCountLabel.isEnabled()) {
                    ZfsBackupControls.this.backupCountDec.show();
                } else {
                    ZfsBackupControls.this.backupCountDec.hide();
                }
            }
        });
        this.backupCount = new Spinner(comp, 1);
        this.backupCount.setMinimum(3);
        this.backupCount.setMaximum(9);
        this.backupCount.setLayoutData((Object)new GridData(16384, -1, false, false, 2, 1));
        this.backupDirLabel = new Label(comp, 0);
        this.backupDirLabel.setText(Messages.getString("Configuration.zfs.label.backupdirectory"));
        this.backupDirLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        this.backupDirDec = Utilities.addMandatoryField((Control)this.backupDirLabel);
        this.backupDirLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ZfsBackupControls.this.backupDirLabel.isEnabled()) {
                    ZfsBackupControls.this.backupDirDec.show();
                } else {
                    ZfsBackupControls.this.backupDirDec.hide();
                }
            }
        });
        this.backupDirInput = new TextInput(comp, this.backupDirLabel);
        this.backupDirInput.setLayoutData((Object)new GridData(4, -1, true, false));
        this.backupDirText = this.backupDirInput.text;
        this.backupDirText.setTextLimit(255);
        this.backupDirText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String text;
                if (!UIHelper.hasError((Control)ZfsBackupControls.this.backupDirText) && !(text = ZfsBackupControls.this.backupDirText.getText()).endsWith("/")) {
                    ZfsBackupControls.this.backupDirText.setText(String.valueOf(text) + "/");
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.backupDirBrowseButton = new Button(comp, 8);
        this.backupDirBrowseButton.setText(Messages.getString("BrowseZfs.buttonText"));
        this.backupDirBrowseButton.setLayoutData((Object)new GridData(16384, -1, false, false));
        this.backupDirBrowseButton.setEnabled(false);
        this.backupDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseZfsDialog dialog = new BrowseZfsDialog(parent.getShell(), null, "BackupDir");
                if (dialog.open() == 0) {
                    ZfsBackupControls.this.backupDirText.setText(dialog.getSelectedPath());
                }
            }
        });
        this.backup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ZfsBackupControls.this.backup.getSelection();
                ZfsBackupControls.this.backupCountLabel.setEnabled(enabled);
                ZfsBackupControls.this.backupCount.setEnabled(enabled);
                ZfsBackupControls.this.backupDirLabel.setEnabled(enabled);
                ZfsBackupControls.this.backupDirInput.setEnabled(enabled);
                ZfsBackupControls.this.backupDirText.setEnabled(enabled);
                ZfsBackupControls.this.backupDirBrowseButton.setEnabled(enabled);
                if (enabled) {
                    ZfsBackupControls.this.backupCountDec.show();
                    ZfsBackupControls.this.backupDirDec.show();
                } else {
                    ZfsBackupControls.this.backupCountDec.hide();
                    ZfsBackupControls.this.backupDirDec.hide();
                }
            }
        });
        this.backup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean enabled = ZfsBackupControls.this.backup.getSelection();
                ZfsBackupControls.this.backupCountLabel.setEnabled(enabled);
                ZfsBackupControls.this.backupCount.setEnabled(enabled);
                ZfsBackupControls.this.backupDirLabel.setEnabled(enabled);
                ZfsBackupControls.this.backupDirInput.setEnabled(enabled);
                ZfsBackupControls.this.backupDirText.setEnabled(enabled);
                ZfsBackupControls.this.backupDirBrowseButton.setEnabled(enabled);
                if (enabled) {
                    ZfsBackupControls.this.backupDec.show();
                } else {
                    ZfsBackupControls.this.backupDec.hide();
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.backup.setEnabled(enabled);
        if (enabled) {
            this.backupDec.show();
        } else {
            this.backupDec.hide();
        }
        boolean enableRest = enabled && this.backup.getSelection();
        this.backupCountLabel.setEnabled(enableRest);
        this.backupCount.setEnabled(enableRest);
        this.backupDirLabel.setEnabled(enableRest);
        this.backupDirInput.setEnabled(enableRest);
        this.backupDirText.setEnabled(enableRest);
        this.backupDirBrowseButton.setEnabled(enabled);
        if (enableRest) {
            this.backupCountDec.show();
            this.backupDirDec.show();
        } else {
            this.backupCountDec.hide();
            this.backupDirDec.hide();
        }
    }
}

