/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.dialogs.AddTransformationVariableDialog;
import com.ibm.cics.cm.utilities.ListeningArrayList;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TransformationVariablesComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public Button openEditor;
    public TableViewer viewer;
    private ListeningArrayList<TransformationVariable> vars;
    private ImageHyperlink remove;
    private ImageHyperlink up;
    private ImageHyperlink down;

    public TransformationVariablesComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Label transformationVariableDescription = new Label((Composite)this, 64);
        transformationVariableDescription.setText(Messages.getString("MigrationSchemeWizardPage.field.transformationvariables.description"));
        GridData rd = new GridData(4, 128, true, false);
        rd.widthHint = 100;
        transformationVariableDescription.setLayoutData((Object)rd);
        Table table = new Table((Composite)this, 67586);
        this.viewer = new TableViewer(table);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(Messages.getString("MigrationScheme.columnHeading.name"));
        nameColumn.setWidth(120);
        TableColumn sourceColumn = new TableColumn(table, 0);
        sourceColumn.setText(Messages.getString("MigrationScheme.columnHeading.sourceValue"));
        sourceColumn.setWidth(120);
        TableColumn targetColumn = new TableColumn(table, 0);
        targetColumn.setText(Messages.getString("MigrationScheme.columnHeading.targetValue"));
        targetColumn.setWidth(120);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        table.setLayoutData((Object)gd);
        table.setLayout((Layout)new GridLayout());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addLabelProvider(this.viewer);
        this.addContentProvider(this.viewer);
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayoutData((Object)new GridData(131072, 128, false, false));
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        buttons.setLayout((Layout)gl);
        ImageHyperlink add = new ImageHyperlink(buttons, 0);
        add.setImage(UIActivator.getImage(UIActivator.IMGD_ADD));
        add.setToolTipText(Messages.getString("MigrationSchemeEditor.XVar.add"));
        add.setLayoutData((Object)new GridData(131072, 128, false, false));
        add.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                int count;
                TransformationVariable var;
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                AddTransformationVariableDialog dialog = new AddTransformationVariableDialog(parent, TransformationVariablesComposite.this.getTransformationVariables());
                if (dialog.open() == 0 && (var = dialog.getTransformationVariable()) != null) {
                    TransformationVariablesComposite.this.getTransformationVariables().add(var);
                    TransformationVariablesComposite.this.refreshViewer();
                }
                if ((count = TransformationVariablesComposite.this.viewer.getTable().getItemCount()) > 0) {
                    TransformationVariablesComposite.this.viewer.getTable().setSelection(count - 1);
                }
                TransformationVariablesComposite.this.checkButtons(TransformationVariablesComposite.this.viewer.getSelection(), TransformationVariablesComposite.this.viewer);
                TransformationVariablesComposite.this.viewer.getTable().setFocus();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.remove = new ImageHyperlink(buttons, 0);
        this.remove.setImage(UIActivator.getImage(UIActivator.IMGD_DELETE));
        this.remove.setToolTipText(Messages.getString("MigrationSchemeEditor.XVar.remove"));
        this.remove.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.remove.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                int count;
                StructuredSelection structured;
                ISelection selection = TransformationVariablesComposite.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    Object[] objectArray = structured.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof TransformationVariable) {
                            TransformationVariablesComposite.this.vars.remove(obj);
                        }
                        ++n2;
                    }
                    TransformationVariablesComposite.this.refreshViewer();
                }
                if ((count = TransformationVariablesComposite.this.viewer.getTable().getItemCount()) > 0) {
                    TransformationVariablesComposite.this.viewer.getTable().setSelection(count - 1);
                }
                TransformationVariablesComposite.this.checkButtons(TransformationVariablesComposite.this.viewer.getSelection(), TransformationVariablesComposite.this.viewer);
                TransformationVariablesComposite.this.viewer.getTable().setFocus();
            }
        });
        this.up = new ImageHyperlink(buttons, 0);
        this.up.setImage(UIActivator.getImage(UIActivator.IMGD_ARROW_UP));
        this.up.setToolTipText(Messages.getString("MigrationSchemeEditor.XVar.up"));
        this.up.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.up.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                StructuredSelection structured;
                ISelection selection = TransformationVariablesComposite.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    Object[] objectArray = structured.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int currentIndex;
                        Object obj = objectArray[n2];
                        if (obj instanceof TransformationVariable && (currentIndex = TransformationVariablesComposite.this.vars.indexOf(obj)) != 0) {
                            TransformationVariablesComposite.this.vars.remove(obj);
                            TransformationVariablesComposite.this.vars.add(currentIndex - 1, (TransformationVariable)obj);
                        }
                        ++n2;
                    }
                    TransformationVariablesComposite.this.refreshViewer();
                }
                TransformationVariablesComposite.this.checkButtons(selection, TransformationVariablesComposite.this.viewer);
            }
        });
        this.down = new ImageHyperlink(buttons, 0);
        this.down.setImage(UIActivator.getImage(UIActivator.IMGD_ARROW_DOWN));
        this.down.setToolTipText(Messages.getString("MigrationSchemeEditor.XVar.down"));
        this.down.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.down.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                StructuredSelection structured;
                ISelection selection = TransformationVariablesComposite.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    Object[] objs = structured.toArray();
                    int i = objs.length - 1;
                    while (i > -1) {
                        int currentIndex;
                        Object obj = objs[i];
                        if (obj instanceof TransformationVariable && (currentIndex = TransformationVariablesComposite.this.vars.indexOf(obj)) != TransformationVariablesComposite.this.vars.size() - 1) {
                            TransformationVariablesComposite.this.vars.remove(obj);
                            TransformationVariablesComposite.this.vars.add(currentIndex + 1, (TransformationVariable)obj);
                        }
                        --i;
                    }
                    TransformationVariablesComposite.this.refreshViewer();
                }
                TransformationVariablesComposite.this.checkButtons(selection, TransformationVariablesComposite.this.viewer);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof TableViewer) {
                    TransformationVariablesComposite.this.checkButtons(event.getSelection(), (TableViewer)event.getSource());
                }
            }
        });
        this.checkButtons(null, this.viewer);
    }

    private void addLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                TransformationVariable item = null;
                if (!(element instanceof TransformationVariable)) {
                    return null;
                }
                item = (TransformationVariable)element;
                if (columnIndex == 0) {
                    return item.getName();
                }
                if (columnIndex == 1) {
                    return item.getSourceValue();
                }
                if (columnIndex == 2) {
                    return item.getTargetValue();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void addContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
    }

    public ArrayList<TransformationVariable> getTransformationVariables() {
        return this.vars != null ? this.vars : (this.vars = new ListeningArrayList());
    }

    public void setInput(ArrayList<TransformationVariable> vars) {
        this.getTransformationVariables().clear();
        this.getTransformationVariables().addAll(vars);
        this.refreshViewer();
    }

    private void refreshViewer() {
        this.viewer.setInput((Object)this.vars.toArray());
        this.viewer.refresh();
    }

    public void checkButtons(ISelection selection, TableViewer viewer) {
        StructuredSelection structured;
        this.remove.setEnabled(false);
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        if (selection != null && selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
            this.remove.setEnabled(true);
            int count = viewer.getTable().getItemCount();
            int[] index = viewer.getTable().getSelectionIndices();
            this.up.setEnabled(count > 1 && index[0] > 0);
            this.down.setEnabled(count > 1 && index[index.length - 1] < count - 1);
        }
        this.remove.redraw();
        this.remove.update();
        this.up.redraw();
        this.up.update();
        this.down.redraw();
        this.down.update();
    }
}

