/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.MigrationPath;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.dialogs.AddMigrationPathDialog;
import com.ibm.cics.cm.utilities.ListeningArrayList;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class MigrationPathsComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public Button openEditor;
    public TableViewer viewer;
    private ListeningArrayList<MigrationPath> paths;
    private ImageHyperlink remove;
    private ImageHyperlink up;
    private ImageHyperlink down;

    public MigrationPathsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Label migrationPathDescription = new Label((Composite)this, 64);
        migrationPathDescription.setText(Messages.getString("MigrationSchemeWizardPage.field.migrationpaths.description"));
        GridData rd = new GridData(4, 128, true, false);
        rd.widthHint = 100;
        migrationPathDescription.setLayoutData((Object)rd);
        Table table = new Table((Composite)this, 67586);
        this.viewer = new TableViewer(table);
        TableColumn sourceColumn = new TableColumn(table, 0);
        sourceColumn.setText(Messages.getString("MigrationScheme.columnHeading.source"));
        sourceColumn.setWidth(120);
        TableColumn targetColumn = new TableColumn(table, 0);
        targetColumn.setText(Messages.getString("MigrationScheme.columnHeading.target"));
        targetColumn.setWidth(120);
        TableColumn ruleColumn = new TableColumn(table, 0);
        ruleColumn.setText(Messages.getString("MigrationScheme.columnHeading.rule"));
        ruleColumn.setWidth(120);
        TableColumn deleteAtSourceColumn = new TableColumn(table, 0);
        deleteAtSourceColumn.setText(Messages.getString("MigrationScheme.columnHeading.deleteAtSource"));
        deleteAtSourceColumn.setWidth(120);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        table.setLayoutData((Object)gd);
        table.setLayout((Layout)new GridLayout());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addLabelProvider(this.viewer);
        this.addContentProvider(this.viewer);
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayoutData((Object)new GridData(131072, 128, false, false));
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        buttons.setLayout((Layout)gl);
        ImageHyperlink add = new ImageHyperlink(buttons, 0);
        add.setImage(UIActivator.getImage(UIActivator.IMGD_ADD));
        add.setToolTipText(Messages.getString("MigrationSchemeEditor.path.add"));
        add.setLayoutData((Object)new GridData(131072, 128, false, false));
        add.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                int count;
                MigrationPath path;
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                AddMigrationPathDialog dialog = new AddMigrationPathDialog(parent, MigrationPathsComposite.this.getMigrationPaths());
                if (dialog.open() == 0 && (path = dialog.getMigrationPath()) != null) {
                    MigrationPathsComposite.this.getMigrationPaths().add(path);
                    MigrationPathsComposite.this.refreshViewer();
                }
                if ((count = MigrationPathsComposite.this.viewer.getTable().getItemCount()) > 0) {
                    MigrationPathsComposite.this.viewer.getTable().setSelection(count - 1);
                }
                MigrationPathsComposite.this.checkButtons(MigrationPathsComposite.this.viewer.getSelection(), MigrationPathsComposite.this.viewer);
                MigrationPathsComposite.this.viewer.getTable().setFocus();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.remove = new ImageHyperlink(buttons, 0);
        this.remove.setImage(UIActivator.getImage(UIActivator.IMGD_DELETE));
        this.remove.setToolTipText(Messages.getString("MigrationSchemeEditor.path.remove"));
        this.remove.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.remove.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                int count;
                StructuredSelection structured;
                ISelection selection = MigrationPathsComposite.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    Object[] objectArray = structured.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof MigrationPath) {
                            MigrationPathsComposite.this.paths.remove(obj);
                        }
                        ++n2;
                    }
                    MigrationPathsComposite.this.refreshViewer();
                }
                if ((count = MigrationPathsComposite.this.viewer.getTable().getItemCount()) > 0) {
                    MigrationPathsComposite.this.viewer.getTable().setSelection(count - 1);
                }
                MigrationPathsComposite.this.checkButtons(MigrationPathsComposite.this.viewer.getSelection(), MigrationPathsComposite.this.viewer);
                MigrationPathsComposite.this.viewer.getTable().setFocus();
            }
        });
        this.up = new ImageHyperlink(buttons, 0);
        this.up.setImage(UIActivator.getImage(UIActivator.IMGD_ARROW_UP));
        this.up.setToolTipText(Messages.getString("MigrationSchemeEditor.path.up"));
        this.up.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.up.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                StructuredSelection structured;
                ISelection selection = MigrationPathsComposite.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    Object[] objectArray = structured.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int currentIndex;
                        Object obj = objectArray[n2];
                        if (obj instanceof MigrationPath && (currentIndex = MigrationPathsComposite.this.paths.indexOf(obj)) != 0) {
                            MigrationPathsComposite.this.paths.remove(obj);
                            MigrationPathsComposite.this.paths.add(currentIndex - 1, (MigrationPath)obj);
                        }
                        ++n2;
                    }
                    MigrationPathsComposite.this.refreshViewer();
                }
                MigrationPathsComposite.this.checkButtons(selection, MigrationPathsComposite.this.viewer);
            }
        });
        this.down = new ImageHyperlink(buttons, 0);
        this.down.setImage(UIActivator.getImage(UIActivator.IMGD_ARROW_DOWN));
        this.down.setToolTipText(Messages.getString("MigrationSchemeEditor.path.down"));
        this.down.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.down.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                StructuredSelection structured;
                ISelection selection = MigrationPathsComposite.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    Object[] objs = structured.toArray();
                    int i = objs.length - 1;
                    while (i > -1) {
                        int currentIndex;
                        Object obj = objs[i];
                        if (obj instanceof MigrationPath && (currentIndex = MigrationPathsComposite.this.paths.indexOf(obj)) != MigrationPathsComposite.this.paths.size() - 1) {
                            MigrationPathsComposite.this.paths.remove(obj);
                            MigrationPathsComposite.this.paths.add(currentIndex + 1, (MigrationPath)obj);
                        }
                        --i;
                    }
                    MigrationPathsComposite.this.refreshViewer();
                }
                MigrationPathsComposite.this.checkButtons(selection, MigrationPathsComposite.this.viewer);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof TableViewer) {
                    MigrationPathsComposite.this.checkButtons(event.getSelection(), (TableViewer)event.getSource());
                }
            }
        });
        this.checkButtons(null, this.viewer);
    }

    private void addLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                MigrationPath item = null;
                if (!(element instanceof MigrationPath)) {
                    return null;
                }
                item = (MigrationPath)element;
                if (columnIndex == 0) {
                    return item.getSource();
                }
                if (columnIndex == 1) {
                    return item.getTarget();
                }
                if (columnIndex == 2) {
                    return item.getRule();
                }
                if (columnIndex == 3 && item.getDeleteAtSource()) {
                    return "Yes";
                }
                if (columnIndex == 3 && !item.getDeleteAtSource()) {
                    return "No";
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void addContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
    }

    public ArrayList<MigrationPath> getMigrationPaths() {
        return this.paths != null ? this.paths : (this.paths = new ListeningArrayList());
    }

    public void setInput(ArrayList<MigrationPath> paths) {
        this.getMigrationPaths().clear();
        this.getMigrationPaths().addAll(paths);
        this.refreshViewer();
    }

    private void refreshViewer() {
        this.viewer.setInput((Object)this.paths.toArray());
        this.viewer.refresh();
    }

    public void checkButtons(ISelection selection, TableViewer viewer) {
        StructuredSelection structured;
        this.remove.setEnabled(false);
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        if (selection != null && selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
            this.remove.setEnabled(true);
            int count = viewer.getTable().getItemCount();
            int[] index = viewer.getTable().getSelectionIndices();
            this.up.setEnabled(count > 1 && index[0] > 0);
            this.down.setEnabled(count > 1 && index[index.length - 1] < count - 1);
        }
        this.remove.redraw();
        this.remove.update();
        this.up.redraw();
        this.up.update();
        this.down.redraw();
        this.down.update();
    }
}

