/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.Messages;
import com.ibm.cics.cm.ui.composites.FilterComposite;
import java.text.MessageFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class LongComposite
extends FilterComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ZERO = "0";
    private Text text;
    private int min;
    private int max;

    @Override
    public Composite createComposite(Composite parent) {
        Composite longComposite = this.createBasicComposite(parent);
        this.text = new Text(longComposite, 2048);
        GridData data = new GridData(4, 4, true, false);
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LongComposite.this.refresh();
            }
        });
        return longComposite;
    }

    @Override
    public void initialize() {
        if (this.filterExpression == null) {
            this.filterExpression = this.attribute.getFilterExpression();
            this.filterExpression.setPropertyName(this.displayName);
        }
        this.operatorSelectionToolItem.setText(this.filterExpression.getOperatorDisplayName());
        this.operatorSelectionToolItem.setToolTipText(this.filterExpression.getOperatorDisplayName());
        this.min = this.attribute.getMinimum();
        this.max = this.attribute.getMaximum();
        if (this.filterExpression.getValue() != null) {
            this.text.setText(this.filterExpression.getValue().toString());
        }
    }

    @Override
    public void clearComposite() {
        this.filterExpression = null;
        this.text.setText(ZERO);
    }

    @Override
    protected void refresh() {
        String message = null;
        String textValue = this.text.getText();
        try {
            long temp = Long.parseLong(textValue);
            if (temp < (long)this.min || temp > (long)this.max) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ee) {
            message = MessageFormat.format(Messages.getString((String)"CICSFilterAttribute.error.range"), this.displayName, this.min, this.max);
        }
        if (this.filterExpression != null) {
            this.filterExpression.setValue((Object)textValue);
        }
        this.updateErrorMessages(message);
        this.notifyListeners();
    }
}

