/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.ui.composites.DateComposite;
import com.ibm.cics.cm.ui.composites.DefaultFilterComposite;
import com.ibm.cics.cm.ui.composites.EnumComposite;
import com.ibm.cics.cm.ui.composites.FilterComposite;
import com.ibm.cics.cm.ui.composites.LongComposite;
import com.ibm.cics.cm.ui.composites.StringComposite;
import com.ibm.cics.common.util.Debug;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;

public class FilterCompositeFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(FilterCompositeFactory.class);
    private Composite parentComposite;
    private Map<Class, Class> classes = new HashMap<Class, Class>();
    private FilterComposite filterComposite;
    private Map<Class, FilterComposite> composites = new HashMap<Class, FilterComposite>();

    public FilterCompositeFactory(Composite parent) {
        this.init();
        this.parentComposite = parent;
    }

    private void init() {
        this.classes.put(String.class, StringComposite.class);
        this.classes.put(Enum.class, EnumComposite.class);
        this.classes.put(Long.class, LongComposite.class);
        this.classes.put(Date.class, DateComposite.class);
    }

    public FilterComposite createComposite(FilterAttribute attribute) {
        Class<DefaultFilterComposite> filterClass = this.classes.get(attribute.getType());
        this.filterComposite = this.composites.get(filterClass);
        if (this.filterComposite == null) {
            try {
                if (filterClass == null) {
                    filterClass = DefaultFilterComposite.class;
                }
                this.filterComposite = (FilterComposite)filterClass.newInstance();
                if (this.filterComposite == null) {
                    filterClass = DefaultFilterComposite.class;
                    this.filterComposite = (FilterComposite)filterClass.newInstance();
                }
                this.filterComposite.setPropertyName(attribute.getDisplayName());
                this.filterComposite.setAttribute(attribute);
                Composite composite = this.filterComposite.createComposite(this.parentComposite);
                this.filterComposite.setComposite(composite);
                this.composites.put(filterClass, this.filterComposite);
            }
            catch (IllegalAccessException e) {
                debug.error("createComposite", "Unable to display composite for attribute " + attribute.getAPIName(), (Throwable)e);
            }
            catch (InstantiationException e) {
                debug.error("createComposite", "Unable to display composite for attribute " + attribute.getAPIName(), (Throwable)e);
            }
        } else {
            this.filterComposite.clearComposite();
            this.filterComposite.setPropertyName(attribute.getDisplayName());
            this.filterComposite.setAttribute(attribute);
            Composite composite = this.filterComposite.createComposite(this.parentComposite);
            this.filterComposite.setComposite(composite);
        }
        return this.filterComposite;
    }
}

