/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.ui.OperatorSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

public abstract class FilterComposite {
    protected FilterExpression filterExpression;
    protected List<Listener> listeners = new ArrayList<Listener>();
    private Composite composite;
    protected FilterAttribute attribute;
    protected ToolItem operatorSelectionToolItem;
    protected Menu operatorMenu;
    private SelectionAdapter menuListener;
    protected List<FilterExpression.Operator> operators = Arrays.asList(FilterExpression.Operator.values());
    protected String displayName;

    protected void notifyListeners() {
        for (Listener listener : this.listeners) {
            listener.filterValueChanged(this.filterExpression);
        }
    }

    protected void notifyErrorListeners(String errorMessage) {
        for (Listener listener : this.listeners) {
            listener.errorMessageChanged(errorMessage);
        }
    }

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void removeListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public abstract Composite createComposite(Composite var1);

    protected Composite createBasicComposite(Composite parent) {
        Composite basicComposite = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        GridLayout gridLayout = new GridLayout(1, false);
        basicComposite.setLayout((Layout)gridLayout);
        basicComposite.setLayoutData((Object)data);
        OperatorSelection operatorSelection = new OperatorSelection(basicComposite, this.getOperators(), this.getDefaultOperator()){

            @Override
            protected void setOperator(FilterExpression.Operator data) {
                FilterComposite.this.filterExpression.setOperator(data);
                FilterComposite.this.refresh();
            }

            @Override
            protected String getDisplayName(FilterExpression.Operator oper) {
                return FilterComposite.this.getDisplayName(oper);
            }
        };
        this.operatorSelectionToolItem = operatorSelection.getSelectionToolBar();
        return basicComposite;
    }

    protected FilterExpression.Operator getDefaultOperator() {
        return FilterExpression.Operator.EQ;
    }

    protected List<FilterExpression.Operator> getOperators() {
        return this.operators;
    }

    protected String getDisplayName(FilterExpression.Operator oper) {
        return oper.getDisplayName();
    }

    protected abstract void refresh();

    public final void setComposite(Composite aComposite) {
        this.composite = aComposite;
    }

    public final Composite getComposite() {
        return this.composite;
    }

    public void setAttribute(FilterAttribute anAttribute) {
        this.attribute = anAttribute;
    }

    public abstract void initialize();

    public void setFilterExpression(FilterExpression aFilterExpression) {
        this.filterExpression = aFilterExpression;
    }

    public abstract void clearComposite();

    public void setPropertyName(String aDisplayName) {
        this.displayName = aDisplayName;
    }

    protected void updateErrorMessages(String errorMessage) {
        this.notifyErrorListeners(errorMessage);
    }

    public static interface Listener {
        public static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public void filterValueChanged(FilterExpression var1);

        public void errorMessageChanged(String var1);
    }
}

