/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.composites;

import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.ui.composites.FilterComposite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EnumComposite
extends FilterComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite enumOptionsComposite;
    private Map<Object, Button> buttons = new HashMap<Object, Button>();
    private Composite enumComposite;
    private Button currentButton;
    protected List<FilterExpression.Operator> operators = Arrays.asList(FilterExpression.Operator.EQ, FilterExpression.Operator.NE);

    @Override
    public Composite createComposite(Composite parent) {
        Object[] values = this.attribute.getValues();
        this.enumComposite = this.createBasicComposite(parent);
        ScrolledComposite sc = new ScrolledComposite(this.enumComposite, 2560);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite enumOptionsComposite = new Composite((Composite)sc, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 5;
        enumOptionsComposite.setLayout((Layout)gridLayout);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            final Button button = new Button(enumOptionsComposite, 16);
            button.setText(this.attribute.getDisplayName(value));
            button.setData(value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    EnumComposite.this.refresh(button);
                }

                public void widgetSelected(SelectionEvent e) {
                    EnumComposite.this.refresh(button);
                }
            });
            this.buttons.put(value, button);
            ++n2;
        }
        sc.setContent((Control)enumOptionsComposite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(enumOptionsComposite.computeSize(-1, -1));
        sc.setShowFocusedControl(true);
        return this.enumComposite;
    }

    protected void refresh(Button button) {
        this.currentButton = button;
        for (Map.Entry<Object, Button> entry : this.buttons.entrySet()) {
            if (!entry.getValue().equals(button)) continue;
            this.filterExpression.setValue(entry.getKey());
            break;
        }
        this.refresh();
    }

    @Override
    protected List<FilterExpression.Operator> getOperators() {
        return this.operators;
    }

    @Override
    protected void refresh() {
        this.notifyListeners();
    }

    @Override
    public void initialize() {
        Button button;
        if (this.filterExpression == null) {
            this.filterExpression = this.attribute.getFilterExpression();
            this.filterExpression.setPropertyName(this.displayName);
        }
        if ((button = this.buttons.get(this.filterExpression.getValue())) != null) {
            button.setSelection(true);
            this.currentButton = button;
        }
        this.operatorSelectionToolItem.setText(this.filterExpression.getOperatorDisplayName());
        this.operatorSelectionToolItem.setToolTipText(this.filterExpression.getOperatorDisplayName());
    }

    @Override
    public void clearComposite() {
        this.enumComposite.dispose();
        this.currentButton = null;
        this.filterExpression = null;
        this.buttons.clear();
    }
}

