/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.chgpkg;

import com.ibm.cics.cm.model.PackageSchemeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class PackageSchemeEventLabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.listeners.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PackageSchemeEvent) {
            PackageSchemeEvent event = (PackageSchemeEvent)element;
            String apiCmd = event.getAttribute(PackageSchemeEvent.EventAttribute.CH_APICMD);
            String timestamp = event.getAttribute(PackageSchemeEvent.EventAttribute.CH_DATIME);
            String eventID = event.getAttribute(PackageSchemeEvent.EventAttribute.CH_EVID);
            return String.valueOf(timestamp) + " - " + apiCmd + " - " + eventID;
        }
        return element.toString();
    }
}

