/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.chgpkg;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageCommand;
import com.ibm.cics.cm.ui.wizards.ChangePackageActionWizard;
import com.ibm.cics.common.util.StringUtil;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangePackageCommandHandler
extends AbstractHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String UNREADY_PARM_ID = "com.ibm.cics.cm.ui.chgpkg.parm.unready";
    public static final String SCHEME_PARM_ID = "com.ibm.cics.cm.ui.chgpkg.parm.scheme";
    private static final String READY_COMMAND_ID = "com.ibm.cics.cm.ui.chgpkg.command.ready";
    private static final String UNREADY_COMMAND_ID = "com.ibm.cics.cm.ui.chgpkg.command.unready";
    private static final String MIGRATE_COMMAND_ID = "com.ibm.cics.cm.ui.chgpkg.command.migrate";
    private static final String BACKOUT_COMMAND_ID = "com.ibm.cics.cm.ui.chgpkg.command.backout";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstElement;
        Command triggeredCommand = event.getCommand();
        ChangePackageCommand command = null;
        String eclipseCommandID = triggeredCommand.getId();
        if (eclipseCommandID.equals(READY_COMMAND_ID)) {
            command = ChangePackageCommand.READY;
        } else if (eclipseCommandID.equals(MIGRATE_COMMAND_ID)) {
            command = ChangePackageCommand.MIGRATE;
        } else if (eclipseCommandID.equals(BACKOUT_COMMAND_ID)) {
            command = ChangePackageCommand.BACKOUT;
        }
        boolean unready = Boolean.parseBoolean(event.getParameter(UNREADY_PARM_ID));
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof ChangePackage) {
            ChangePackage cPackage = (ChangePackage)firstElement;
            MigrationScheme scheme = null;
            String schemeParm = event.getParameter(SCHEME_PARM_ID);
            if (StringUtil.hasContent((String)schemeParm)) {
                MigrationScheme lastScheme = cPackage.getLastScheme();
                if (schemeParm.equals(lastScheme.getName())) {
                    scheme = lastScheme;
                } else {
                    IFilteredCollection migrationSchemes = ConfigurationManager.getCurrent().getMigrationSchemes();
                    migrationSchemes.addRestrictionField("NAME", FilterExpression.Operator.EQ, schemeParm);
                    List results = migrationSchemes.getResults();
                    if (results.size() == 1) {
                        scheme = (MigrationScheme)results.get(0);
                    }
                }
            }
            if (scheme == null && (command != ChangePackageCommand.READY || unready)) {
                scheme = cPackage.getLastScheme();
            }
            if (command == ChangePackageCommand.READY && unready) {
                command = ChangePackageCommand.UNREADY;
            }
            WizardDialog wizard = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)new ChangePackageActionWizard(command, cPackage, scheme));
            wizard.open();
        }
        return null;
    }
}

