/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationContext;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.ScopedContext;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IAdapterFactory;

public class SMCMResourceListAdaptorFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private WeakHashMap<Object, ResourceList> cachedAdapters = new WeakHashMap();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ISystemManagerConnection connection = UIPlugin.getCPSM().getConnection();
        if (connection == null || !(connection instanceof ICMSMConnection)) {
            return null;
        }
        if (adaptableObject instanceof IResourceDescriptionDefinition || adaptableObject instanceof ICSDListDefinition) {
            ResourceList list = this.cachedAdapters.get(adaptableObject);
            if (list == null) {
                IPrimaryKey primaryKey = (IPrimaryKey)((ICoreObject)adaptableObject).getAdapter(IPrimaryKey.class);
                IContext context = primaryKey.getParentContext();
                if (context instanceof IFilteredContext) {
                    context = ((IFilteredContext)context).getParentContext();
                }
                if (context instanceof ConfigurationContext) {
                    ConfigurationContext cmContext = (ConfigurationContext)context;
                    list = cmContext.getConfiguration().getResourceList(primaryKey.getAttributeValue("NAME"));
                    this.cachedAdapters.put(adaptableObject, list);
                }
                if (context instanceof ScopedContext) {
                    String configName = ((ScopedContext)context).getContext();
                    Configuration config = ConfigurationManager.getCurrent().getConfiguration(configName);
                    if (config != null) {
                        list = config.getResourceList(primaryKey.getAttributeValue("NAME"));
                    }
                }
            }
            return list;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ResourceList.class};
    }
}

