/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.ReadyListObject;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IAdapterFactory;

public class ReadyListObjectToICMObjectAdaptorFactory
implements IAdapterFactory,
Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<ReadyListObject, ICMObject> cachedAdapters = new WeakHashMap<ReadyListObject, ICMObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ISystemManagerConnection connection = UIPlugin.getCPSM().getConnection();
        if (connection == null || !(connection instanceof ICMSMConnection)) {
            return null;
        }
        if (adaptableObject instanceof ReadyListObject) {
            Map<ReadyListObject, ICMObject> map = this.cachedAdapters;
            synchronized (map) {
                Configuration configuration;
                ReadyListObject inputObject = (ReadyListObject)adaptableObject;
                ICMObject definition = this.cachedAdapters.get(inputObject);
                if (definition != null) {
                    return definition;
                }
                Map inputAttributes = inputObject.getAttributes();
                String configStr = (String)inputAttributes.get("SEL_CCONFIG");
                String groupStr = (String)inputAttributes.get("SEL_GROUP");
                String nameStr = (String)inputAttributes.get("SEL_OBJNAME");
                String typeStr = (String)inputAttributes.get("SEL_OBJTYPE");
                if (StringUtil.hasContent((String)configStr) && (configuration = ConfigurationManager.getCurrent().getConfiguration(configStr)) != null && StringUtil.hasContent((String)nameStr) && StringUtil.hasContent((String)typeStr)) {
                    if (typeStr.equals("RESGROUP")) {
                        definition = configuration.getResourceGroup(nameStr);
                    } else if (typeStr.equals("RESDESC")) {
                        definition = configuration.getResourceList(nameStr);
                    } else if (StringUtil.hasContent((String)groupStr)) {
                        ResourceDefinitionGroup resourceGroup = configuration.getResourceGroup(groupStr);
                        definition = resourceGroup.getDefinition(typeStr, nameStr);
                    } else {
                        definition = configuration.getDefinition(typeStr, nameStr);
                    }
                }
                if (definition != null) {
                    this.cachedAdapters.put(inputObject, definition);
                }
                return definition;
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ICMObject.class};
    }
}

