/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.ui.adapters.CMObjectPropertySource;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertySourceAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IPropertySourceProvider propertySourceProvider = new IPropertySourceProvider(){

        public IPropertySource getPropertySource(Object object) {
            return new CMObjectPropertySource((ICMObject)object);
        }
    };
    private IPropertySourceProvider smPropertySourceProvider = new IPropertySourceProvider(){

        public IPropertySource getPropertySource(Object object) {
            ICICSObject cicsObject = (ICICSObject)Platform.getAdapterManager().getAdapter(object, ICICSDefinition.class);
            return new CICSObjectPropertySource(cicsObject);
        }
    };

    public PropertySourceAdapterFactory() {
        this.toString();
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IPropertySourceProvider adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            if (adaptableObject instanceof ResourceDefinition || adaptableObject instanceof History) {
                ICoreObject iCoreObject = (ICoreObject)Platform.getAdapterManager().getAdapter(adaptableObject, ICICSDefinition.class);
                adapter = iCoreObject != null ? this.smPropertySourceProvider : this.propertySourceProvider;
            } else if (adaptableObject instanceof ICMObject) {
                adapter = this.propertySourceProvider;
            }
        }
        return adapter;
    }

    public Class[] getAdapterList() {
        return new Class[]{IPropertySourceProvider.class};
    }
}

