/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.IHistoryCompatible;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;

public class ICSDGroupDefinitionToIHistoryProviderAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        HistoryProviderDelegate historyProvider = null;
        final ICSDGroupDefinition definition = (ICSDGroupDefinition)adaptableObject;
        final Configuration configuration = CMSMConnection.getConfiguration((IContext)((IContextProvider)adaptableObject).getIContext());
        if (configuration != null) {
            CSDGroupHistoryCompatible historyCompatible = new CSDGroupHistoryCompatible(configuration, definition);
            historyProvider = new HistoryProviderDelegate(historyCompatible){

                protected JournalCriteria getJournalCriteria() {
                    return JournalCriteria.newJournalCriteriaForResourceGroup((String)configuration.getName(), (String)definition.getName());
                }

                protected JournalCriteria getJournalEventCriteria() {
                    return JournalCriteria.newJournalEventCriteriaForResourceGroup((String)configuration.getName(), (String)definition.getName());
                }

                protected List<RestrictionCriteria> getAdditionalCriteria() {
                    return new ArrayList<RestrictionCriteria>();
                }
            };
            historyCompatible.setHistoryProvider((IHistoryProvider)historyProvider);
        }
        return historyProvider;
    }

    public Class[] getAdapterList() {
        return new Class[]{IHistoryProvider.class};
    }

    class CSDGroupHistoryCompatible
    implements IHistoryCompatible {
        private Configuration configuration;
        private IHistoryProvider historyProvider;
        private ICSDGroupDefinition theCSDGroupDefinition;

        CSDGroupHistoryCompatible(Configuration aConfiguration, ICSDGroupDefinition aCSDGroupDefinition) {
            this.configuration = aConfiguration;
            this.theCSDGroupDefinition = aCSDGroupDefinition;
        }

        public Date getChangeTime() {
            return this.configuration.getChangeTime();
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public IHistoryProvider getIHistoryProvider() {
            return this.historyProvider;
        }

        public String getName() {
            return this.theCSDGroupDefinition.getName();
        }

        void setHistoryProvider(IHistoryProvider aHistoryProvider) {
            this.historyProvider = aHistoryProvider;
        }
    }
}

