/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.comm.CMConnectionRecord;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationOverrides;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.OrphanedResourceContext;
import com.ibm.cics.cm.model.ResourceDefinitionGroupContext;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;

public class CMSMAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!UIPlugin.getCPSM().isConnected()) {
            return null;
        }
        ICMDefinition cmDefinition = (ICMDefinition)adaptableObject;
        Object context = cmDefinition.getResourceGroup() != null ? new ResourceDefinitionGroupContext(cmDefinition.getResourceGroup()) : new OrphanedResourceContext(cmDefinition);
        Map attributes = cmDefinition.getAttributes();
        String definitionType = cmDefinition.getType();
        ICICSType cicsType = CICSTypes.findForResourceTableName((String)definitionType);
        if (cicsType == null) {
            return null;
        }
        Class implementationType = cicsType.getImplementationType();
        try {
            Constructor constructor = implementationType.getConstructor(ICPSM.class, IContext.class, SMConnectionRecord.class);
            ConfigurationOverrides configurationOverrides = ConfigurationOverrides.getOverrides((Configuration)cmDefinition.getConfiguration(), (String)definitionType);
            CMConnectionRecord cmRecord = new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)configurationOverrides, (IContext)context);
            ICICSDefinition cicsDefinition = (ICICSDefinition)constructor.newInstance(UIPlugin.getCPSM(), cmRecord.getBaseContext(), cmRecord);
            return cicsDefinition;
        }
        catch (Exception e) {
            UIActivator.getDefault().logError("Unable to adapt " + adaptableObject + " into " + adapterType, e);
            return null;
        }
    }

    public Class[] getAdapterList() {
        return new Class[]{ICICSDefinition.class, ICICSObject.class};
    }
}

