/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.adapters;

import com.ibm.cics.cm.comm.CMConnectionRecord;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationOverrides;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryContext;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterFactory;

public class CMHistoryToSMAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        History historicalDefinition = (History)adaptableObject;
        String definitionType = historicalDefinition.getType();
        ICICSType cicsType = CICSTypes.findForResourceTableName((String)definitionType);
        if (cicsType == null) {
            return null;
        }
        Class implementationType = cicsType.getImplementationType();
        HistoryContext context = new HistoryContext(historicalDefinition);
        Map attributes = historicalDefinition.getAttributesBeforeChange();
        if (attributes != null) {
            attributes.put("DEFVER", "FORCE_ATTRIBUTE_UNSUPPORTED");
            attributes.put("GROUP", historicalDefinition.getResourceGroup());
            ConfigurationOverrides configurationOverrides = ConfigurationOverrides.getOverrides((Configuration)historicalDefinition.getProvider().getConfiguration(), (String)definitionType);
            CMConnectionRecord cmRecord = new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)configurationOverrides, (IContext)context);
            try {
                Constructor constructor = implementationType.getConstructor(ICPSM.class, IContext.class, SMConnectionRecord.class);
                final ICoreObject cicsDefinition = (ICoreObject)constructor.newInstance(UIPlugin.getCPSM(), cmRecord.getBaseContext(), cmRecord);
                Object newProxyInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cicsType.getInterfaceType(), ICoreObject.class}, new InvocationHandler((IContext)context, historicalDefinition){
                    private final /* synthetic */ IContext val$context;
                    private final /* synthetic */ History val$historicalDefinition;
                    {
                        this.val$context = iContext;
                        this.val$historicalDefinition = history;
                    }

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        String name = method.getName();
                        final HashMap filterAttributes = new HashMap();
                        if (name.equals("getPrimaryKey") || name.equals("getAdapter") && args != null && args.length > 0 && args[0].equals(IPrimaryKey.class)) {
                            return new IPrimaryKey(){

                                public String getContext() {
                                    return val$context.getContext();
                                }

                                public String getScope() {
                                    return val$context.getContext();
                                }

                                public IContext getParentContext() {
                                    return val$context;
                                }

                                public String getAttributeValue(String attributeName) {
                                    return (String)filterAttributes.get(attributeName);
                                }

                                public Set<String> getAttributeNames() {
                                    return filterAttributes.keySet();
                                }

                                public boolean matches(IPrimaryKey other) {
                                    IContext otherParentContext = other.getParentContext();
                                    if (otherParentContext instanceof HistoryContext) {
                                        HistoryContext otherHistoryContext = (HistoryContext)otherParentContext;
                                        return otherHistoryContext.getHistoricalDefinition().equals(val$historicalDefinition);
                                    }
                                    return false;
                                }
                            };
                        }
                        try {
                            return method.invoke((Object)cicsDefinition, args);
                        }
                        catch (IllegalAccessException iae) {
                            throw new RuntimeException("Failed to invoke method on compare proxy object", iae);
                        }
                        catch (IllegalArgumentException iae) {
                            throw new RuntimeException("Failed to invoke method on compare proxy object", iae);
                        }
                        catch (InvocationTargetException ite) {
                            throw new RuntimeException("Failed to invoke method on compare proxy object", ite);
                        }
                    }
                });
                return newProxyInstance;
            }
            catch (Exception e) {
                UIActivator.getDefault().logError("Unable to adapt " + adaptableObject + " into " + adapterType, e);
                return null;
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ICICSDefinition.class, ICICSObject.class};
    }
}

