/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.cm.ui.history.ResourceDefinitionType;
import com.ibm.cics.cm.ui.views.HistoryView;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class RestoreHistoryActionDelegate
extends Action
implements IObjectActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private History history;
    private IViewPart activePart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof IViewPart) {
            this.activePart = (IViewPart)targetPart;
        }
    }

    public void run(IAction action) {
        if (this.history == null || !ResourceDefinitionType.getResourceDefinitionType(this.history.getType()).isRestorable() || "RENAME".equals(this.history.getCommand())) {
            return;
        }
        Job job = new Job(Messages.getString("RestoreHistoryActionDelegate.job.desc")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(this.getName(), -1);
                try {
                    try {
                        ConfigurationManager.getCurrent().restoreHistory(RestoreHistoryActionDelegate.this.history);
                        IWorkbenchPartSite site = RestoreHistoryActionDelegate.this.activePart.getSite();
                        String messageString = RestoreHistoryActionDelegate.this.beforeOrAfterImage(RestoreHistoryActionDelegate.this.history) ? "RestoreHistoryActionDelegate.message.beforeimage.success" : "RestoreHistoryActionDelegate.message.afterimage.success";
                        RestoreHistoryActionDelegate.this.setMessage(MessageFormat.format(Messages.getString(messageString), RestoreHistoryActionDelegate.this.history.getName(), RestoreHistoryActionDelegate.this.history.getCreationTime()));
                        RestoreHistoryActionDelegate.this.setErrorMessage(null);
                        if ("ZFSFILE".equals(RestoreHistoryActionDelegate.this.history.getType())) {
                            ZfsDefinition definition = ConfigurationManager.getCurrent().getZfsDefinition(RestoreHistoryActionDelegate.this.history.getName(), RestoreHistoryActionDelegate.this.history.getConfiguration());
                            definition.notifyListeners(true);
                        }
                        if (RestoreHistoryActionDelegate.this.activePart instanceof HistoryView) {
                            ((HistoryView)RestoreHistoryActionDelegate.this.activePart).refreshInput();
                        }
                    }
                    catch (CMServerException e) {
                        RestoreHistoryActionDelegate.this.setErrorMessage(MessageFormat.format(Messages.getString("RestoreHistoryActionDelegate.4"), RestoreHistoryActionDelegate.this.history.getProvider().getName()));
                        monitor.done();
                    }
                    catch (SystemManagerConnectionException e) {
                        RestoreHistoryActionDelegate.this.setErrorMessage(MessageFormat.format(Messages.getString("RestoreHistoryActionDelegate.4"), RestoreHistoryActionDelegate.this.history.getProvider().getName()));
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        this.schedule(job);
    }

    private boolean beforeOrAfterImage(History history) {
        String command = history.getCommand();
        boolean isAfterImage = command.equals("COPY") || command.equals("CREATE") || command.equals("MIGRATE") || history.getHistoryEntry().getBeforeAttributes() == null && command.equals("RENAME");
        return !isAfterImage;
    }

    private void schedule(Job aJob) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.activePart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(aJob, 0L, true);
    }

    protected void setMessage(final String aMessage) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((IViewSite)RestoreHistoryActionDelegate.this.activePart.getSite()).getActionBars().getStatusLineManager().setMessage(aMessage);
            }
        });
    }

    protected void setErrorMessage(final String anErrorMessage) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((IViewSite)RestoreHistoryActionDelegate.this.activePart.getSite()).getActionBars().getStatusLineManager().setErrorMessage(anErrorMessage);
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.history = (History)((StructuredSelection)selection).getFirstElement();
        this.setEnabled(this.history != null && ResourceDefinitionType.getResourceDefinitionType(this.history.getType()).isRestorable());
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

