/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.core.ui.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewDefinitionWizardDropdownAction
extends Action {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static IContributionItem createContributionItem;
    private final String additionalFirstWizardId;
    private final boolean isCICSConfiguration;

    public NewDefinitionWizardDropdownAction(String additionalFirstWizardId, boolean isCICSConfiguration) {
        super(Messages.getString((String)"NewDefinitionWizardDropdownAction.new"));
        this.additionalFirstWizardId = additionalFirstWizardId;
        this.isCICSConfiguration = isCICSConfiguration;
    }

    public int getStyle() {
        return 4;
    }

    private static IContributionItem getCreateWizardItemsContributionItem() {
        if (createContributionItem == null) {
            createContributionItem = ContributionItemFactory.NEW_WIZARD_SHORTLIST.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        return createContributionItem;
    }

    public IMenuCreator getMenuCreator() {
        return new IMenuCreator(){
            private Menu childMenu;

            public void dispose() {
                if (this.childMenu != null && !this.childMenu.isDisposed()) {
                    this.childMenu.dispose();
                }
            }

            public Menu getMenu(Control parent) {
                return null;
            }

            public Menu getMenu(Menu parent) {
                this.dispose();
                this.childMenu = new Menu(parent);
                NewDefinitionWizardDropdownAction.getCreateWizardItemsContributionItem().fill(this.childMenu, 0);
                if (!NewDefinitionWizardDropdownAction.this.isCICSConfiguration) {
                    Menu tempMenu = new Menu(parent);
                    boolean foundSeparator = false;
                    MenuItem[] menuItemArray = this.childMenu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        ContributionItem ci = (ContributionItem)item.getData();
                        if (ci == null) {
                            foundSeparator = true;
                            ci = new Separator();
                            ci.fill(tempMenu, -1);
                        }
                        if (foundSeparator && ci instanceof ActionContributionItem) {
                            ci = new ActionContributionItem(((ActionContributionItem)ci).getAction());
                            ci.fill(tempMenu, -1);
                        }
                        ++n2;
                    }
                    this.dispose();
                    this.childMenu = tempMenu;
                    this.addWizard(this.childMenu, "com.ibm.cics.cm.ui.zfsdef.newwizard");
                }
                if (NewDefinitionWizardDropdownAction.this.additionalFirstWizardId != null) {
                    this.addWizard(this.childMenu, NewDefinitionWizardDropdownAction.this.additionalFirstWizardId);
                }
                return this.childMenu;
            }

            private void addWizard(Menu childMenu, String wizardId) {
                IWizardDescriptor wizardDesc = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(wizardId);
                if (wizardDesc != null) {
                    NewWizardShortcutAction newWizardShortcutAction = new NewWizardShortcutAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), wizardDesc);
                    ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)newWizardShortcutAction);
                    actionContributionItem.fill(childMenu, 0);
                }
            }
        };
    }
}

