/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.actions;

import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.CMServerInstallException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.Messages;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.InstallError;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SystemManagerActions;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class CSDInstallExecutionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ConfigurationConnection[] installTargets;
    private boolean quiesce;
    private boolean discard;

    public CSDInstallExecutionDelegate(ConfigurationConnection[] installTargets, boolean quiesce, boolean discard) {
        this.installTargets = installTargets;
        this.quiesce = quiesce;
        this.discard = discard;
    }

    public void execute(IDefinition target) throws CMServerException {
        SMConnectionResponse smResponse = null;
        Throwable cmException = null;
        try {
            ICMSMConnection icmsmConnection = ConfigurationManager.getCurrent().getICMSMConnection();
            ICICSType cicsDefinition = target.getCICSType();
            String resourceType = cicsDefinition.getResourceTableName();
            IPrimaryKey primaryKey = (IPrimaryKey)((ICoreObject)target).getAdapter(IPrimaryKey.class);
            smResponse = icmsmConnection.install(resourceType, (IFilteredContext)primaryKey, this.installTargets, this.quiesce, this.discard);
        }
        catch (CMServerInstallException ie) {
            cmException = ie;
        }
        catch (CMServerException se) {
            cmException = se;
        }
        if (smResponse != null) {
            ViewHelper.setDeferredStatusInformationMessage((String)Messages.getString("CSDInstallExecutionDelegate.success"));
        } else if (cmException != null) {
            if (cmException instanceof CMServerInstallException) {
                CMServerInstallException se = (CMServerInstallException)cmException;
            }
            Status status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("CSDInstallExecutionDelegate.error.failure"), cmException.getReturnResponse()), cmException);
            UIActivator.getDefault().getLog().log((IStatus)status);
            ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
        }
    }

    public String getOperationDescription(IDefinition target) {
        Object[] inserts = new String[]{this.optionsAsString(), ExceptionMessageHelper.getObjectTypeDescription((ICICSObject)target), target.getName(), ExceptionMessageHelper.getContextOrScopeNameFor((ICoreObject)((ICoreObject)target)), this.connectionsAsString()};
        return MessageFormat.format(Messages.getString("CMInstallUIDelegate.description"), inserts);
    }

    private String connectionsAsString() {
        StringBuffer sb = new StringBuffer();
        ConfigurationConnection[] configurationConnectionArray = this.installTargets;
        int n = this.installTargets.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationConnection connection = configurationConnectionArray[n2];
            sb.append(",");
            sb.append("\"");
            sb.append(connection.getName());
            sb.append("(" + connection.getApplid() + ")");
            sb.append("\"");
            ++n2;
        }
        sb.replace(0, 1, "");
        return sb.toString();
    }

    private String optionsAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Messages.getString("CMInstallUIDelegate.quiesce"));
        sb.append("=");
        sb.append(this.quiesce ? Messages.getString("CMInstallUIDelegate.true") : Messages.getString("CMInstallUIDelegate.false"));
        sb.append(",");
        sb.append(Messages.getString("CMInstallUIDelegate.discard"));
        sb.append("=");
        sb.append(this.discard ? Messages.getString("CMInstallUIDelegate.true") : Messages.getString("CMInstallUIDelegate.false"));
        sb.append(")");
        sb.insert(0, "(");
        return sb.toString();
    }

    private IStatus getInstallStatus(IDefinition definition, InstallError error) {
        String name = definition.getName();
        String functionName = error.getFunctionName();
        String message = "Install message";
        MultiStatus status = new MultiStatus("", 0, message, null);
        String errorMessage = functionName != null ? ExceptionMessageHelper.getPerformErrorMessage((String)functionName, (String)error.getResp1Name(), (int)error.getResp2()) : Messages.getString("error.install");
        status.add((IStatus)new Status(2, "", errorMessage));
        return status;
    }

    public String getOperationName() {
        return SystemManagerActions.Install.getActionName();
    }

    public int getID() {
        return 609;
    }
}

