/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationConnectionManager;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ICMNotificationListener;
import com.ibm.cics.cm.ui.CMNotificationListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.QueryCompositeImageDescriptor;
import com.ibm.cics.cm.ui.search.CMSearchQuery;
import com.ibm.cics.cm.ui.views.ChangePackagesView;
import com.ibm.cics.cm.ui.views.ConfigurationsView;
import com.ibm.cics.cm.ui.views.HistoryView;
import com.ibm.cics.cm.ui.views.MigrationSchemesView;
import com.ibm.cics.cm.ui.views.SearchResultsView;
import com.ibm.cics.cm.ui.views.ZfsDefinitionsView;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.etools.zusage.core.UsagePlugin;
import com.ibm.etools.zusage.core.model.IOfferingUsageRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIActivator
extends AbstractUIPlugin {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.cm.cpsm.comm");
    public static final String PLUGIN_ID = "com.ibm.cics.cm.ui";
    private static final Logger uiLogger = Logger.getLogger("com.ibm.cics.cm.ui");
    public static final ImageDescriptor IMGD_CONFIG_RESOURCE = UIActivator.getImageDescriptor("icons/full/elcl16/transaction.gif");
    public static final ImageDescriptor IMGD_RESOURCE_LIST = UIActivator.getImageDescriptor("icons/full/elcl16/classpath.gif");
    public static final ImageDescriptor IMGD_RESOURCE_GROUP = UIActivator.getImageDescriptor("icons/full/elcl16/template_obj.gif");
    public static final ImageDescriptor IMGD_WAITING = UIActivator.getImageDescriptor("icons/full/elcl16/waiting_16.gif");
    public static final ImageDescriptor IMGD_FILE_DESCRIPTOR = UIActivator.getImageDescriptor("icons/full/elcl16/file.gif");
    public static final ImageDescriptor IMGD_WARNING = UIActivator.getImageDescriptor("icons/full/elcl16/warn.gif");
    public static final ImageDescriptor IMGD_ERROR = UIActivator.getImageDescriptor("icons/full/elcl16/error.gif");
    public static final ImageDescriptor IMGD_FOLDER = UIActivator.getImageDescriptor("icons/full/elcl16/fldr_obj.gif");
    public static final ImageDescriptor IMGD_OK_TICK = UIActivator.getImageDescriptor("icons/full/elcl16/tick.gif");
    public static final ImageDescriptor IMGD_CPSM_DEOCORATION = UIActivator.getImageDescriptor("icons/full/ovr16/cpsm.gif");
    public static final ImageDescriptor IMGD_JOURNAL_ENTRY = UIActivator.getImageDescriptor("icons/full/elcl16/remote_entry.gif");
    public static final ImageDescriptor IMGD_CURRENT_ENTRY = UIActivator.getImageDescriptor("icons/full/elcl16/current_entry.gif");
    public static final ImageDescriptor IMGD_HISTORY_COMPARISON = UIActivator.getImageDescriptor("icons/full/elcl16/history_comparison.gif");
    public static final ImageDescriptor IMGD_GROUP_BY_DATE = UIActivator.getImageDescriptor("icons/full/elcl16/group_by_date.gif");
    public static final ImageDescriptor IMGD_APPLY_FILTER = UIActivator.getImageDescriptor("icons/full/elcl16/applyfilter.gif");
    public static final ImageDescriptor IMGD_CLEAR_FILTER = UIActivator.getImageDescriptor("icons/full/elcl16/clear_filter.gif");
    public static final ImageDescriptor IMGD_REMOVE_FILTERS = UIActivator.getImageDescriptor("icons/full/elcl16/clear.gif");
    public static final ImageDescriptor IMGD_DATE_RANGE = UIActivator.getImageDescriptor("icons/full/elcl16/report_window_wiz.gif");
    public static final ImageDescriptor IMGD_SEARCH_REPOSITORY = UIActivator.getImageDescriptor("icons/full/elcl16/search_repository.gif");
    public static final ImageDescriptor IMGD_ADD = UIActivator.getImageDescriptor("icons/full/elcl16/add.gif");
    public static final ImageDescriptor IMGD_DELETE = UIActivator.getImageDescriptor("icons/full/elcl16/delete.gif");
    public static final ImageDescriptor IMGD_DELETE_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/delete.gif");
    public static final ImageDescriptor IMGD_ARROW_UP = UIActivator.getImageDescriptor("icons/full/elcl16/arrow_up.gif");
    public static final ImageDescriptor IMGD_ARROW_DOWN = UIActivator.getImageDescriptor("icons/full/elcl16/arrow_down.gif");
    public static final ImageDescriptor IMGD_ARROW_UP_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/arrow_up.gif");
    public static final ImageDescriptor IMGD_ARROW_DOWN_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/arrow_down.gif");
    public static final ImageDescriptor IMGD_CONFIGURATION_CSD = UIActivator.getImageDescriptor("icons/full/elcl16/storageTemplates_obj.gif");
    public static final ImageDescriptor IMGD_CONFIGURATION_CPSM = UIActivator.getImageDescriptor("icons/full/elcl16/storagePool_obj.gif");
    public static final ImageDescriptor IMGD_CONFIGURATION_EXPORT = UIActivator.getImageDescriptor("icons/full/elcl16/mapstorage_tsk.gif");
    public static final ImageDescriptor IMGD_EQUALS = UIActivator.getImageDescriptor("icons/full/elcl16/equal.gif");
    public static final ImageDescriptor IMGD_NOT_EQUALS = UIActivator.getImageDescriptor("icons/full/elcl16/notequal.gif");
    public static final ImageDescriptor IMGD_RUN = UIActivator.getImageDescriptor("icons/full/elcl16/run.gif");
    public static final ImageDescriptor IMGD_RUN_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/run.gif");
    public static ImageDescriptor IMGD_CSD;
    public static final ImageDescriptor IMGD_CPSM;
    public static final ImageDescriptor IMGD_BOTH_CHANGED;
    public static final ImageDescriptor IMGD_LEFT_CHANGED;
    public static final ImageDescriptor IMGD_RIGHT_CHANGED;
    public static final ImageDescriptor IMGD_ATTRIBUTE;
    public static final ImageDescriptor IMGD_DAWIZ;
    public static final ImageDescriptor IMGD_DA_EXPORT_HTML;
    public static final ImageDescriptor IMGD_DA_EXPORT_HTML_DISABLED;
    public static final ImageDescriptor IMGD_DA_SUBMIT_JCL;
    public static final ImageDescriptor IMGD_DA_SUBMIT_JCL_DISABLED;
    public static final ImageDescriptor IMGD_CPWIZ;
    public static final ImageDescriptor IMGD_CPWIZ_APPROVE;
    public static final ImageDescriptor IMGD_CPWIZ_DISAPPROVE;
    public static final ImageDescriptor IMGD_CPWIZ_INSTALL;
    public static final ImageDescriptor IMGD_CPWIZ_BACKOUT;
    public static final ImageDescriptor IMGD_CPWIZ_READY;
    public static final ImageDescriptor IMGD_CPWIZ_UNREADY;
    public static final ImageDescriptor IMGD_CPWIZ_MIGRATE;
    public static final ImageDescriptor IMGD_CONFIGWIZ;
    public static final ImageDescriptor IMGD_CSD_CONN_WIZ;
    public static final ImageDescriptor IMGD_TRANS_VAR_WIZ;
    public static final ImageDescriptor IMGD_SYSTEM_OPTIONS_WIZ;
    public static final ImageDescriptor IMGD_SYSTEM_OPTIONS_TOOLBAR;
    public static final ImageDescriptor IMGD_EXPAND_ALL;
    public static final ImageDescriptor IMGD_EXPAND_ALL_DISABLED;
    public static final ImageDescriptor IMGD_EXPAND;
    public static final ImageDescriptor IMGD_EXPAND_DISABLED;
    public static final ImageDescriptor IMGD_COLLAPSE_ALL;
    public static final ImageDescriptor IMGD_COLLAPSE_ALL_DISABLED;
    public static final ImageDescriptor IMGD_COLLAPSE;
    public static final ImageDescriptor IMGD_COLLAPSE_DISABLED;
    public static final ImageDescriptor IMGD_CSYSGRP;
    public static final ImageDescriptor IMGD_CSYSDEF;
    public static final ImageDescriptor IMGD520_CHANGE_PACKAGE;
    public static final ImageDescriptor IMGD520_CHANGE_PACKAGE_NEW;
    public static final ImageDescriptor IMGD520_CHANGE_PACKAGE_NEW_WIZARD;
    public static final ImageDescriptor IMGD520_CONFIGURATIONS;
    public static final ImageDescriptor IMGD520_CONFIGURATIONS_NEW;
    public static final ImageDescriptor IMGD520_CONFIGURATIONS_NEW_WIZARD;
    public static final ImageDescriptor IMGD520_CSD;
    public static final ImageDescriptor IMGD520_CSD_CONFIGURATION;
    public static final ImageDescriptor IMGD520_DATA_REPOSITORY;
    public static final ImageDescriptor IMGD520_DATA_REPOSITORY_CONFIGURATION;
    public static final ImageDescriptor IMGD520_HISTORY;
    public static final ImageDescriptor IMGD520_HISTORY_ITEM;
    public static final ImageDescriptor IMGD520_HISTORY_ATTRIBUTE;
    public static final ImageDescriptor IMGD520_MIGRATE;
    public static final ImageDescriptor IMGD520_MIGRATION_SCHEME;
    public static final ImageDescriptor IMGD520_MIGRATION_SCHEME_NEW;
    public static final ImageDescriptor IMGD520_MIGRATION_SCHEME_NEW_WIZARD;
    public static final ImageDescriptor IMG_ZFS_CONFIGURATION;
    public static final ImageDescriptor IMG_ZFS_DEFINITION;
    public static final ImageDescriptor IMG_ZFS_DEFINITION_NEW_WIZARD;
    public static final String SHOW_LISTS = "SHOW_LISTS";
    private Map<ImageDescriptor, Image> imageTable = new HashMap<ImageDescriptor, Image>();
    private static UIActivator plugin;
    private IWorkbenchWindow workbenchWindow;
    private IPartListener partListener;
    public static boolean DEBUG_GENERAL;
    public static Color COLOR_DECORATOR_FOREGROUND;
    public static final String CM_UI = "com.ibm.cics.cm.ui";
    public static final String OPTION_DEBUG_GENERAL = "com.ibm.cics.cm.ui/general";

    static {
        IMGD_CPSM = UIActivator.getImageDescriptor("icons/full/elcl16/cpsm_drep.gif");
        IMGD_BOTH_CHANGED = UIActivator.getImageDescriptor("icons/both_changed.gif");
        IMGD_LEFT_CHANGED = UIActivator.getImageDescriptor("icons/left_changed.gif");
        IMGD_RIGHT_CHANGED = UIActivator.getImageDescriptor("icons/right_changed.gif");
        IMGD_ATTRIBUTE = UIActivator.getImageDescriptor("icons/attribute.gif");
        IMGD_DAWIZ = UIActivator.getImageDescriptor("icons/full/elcl16/wn_auto_anal16.gif");
        IMGD_DA_EXPORT_HTML = UIActivator.getImageDescriptor("icons/full/elcl16/htmlexport_co.gif");
        IMGD_DA_EXPORT_HTML_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/htmlexport_co.gif");
        IMGD_DA_SUBMIT_JCL = UIActivator.getImageDescriptor("icons/full/elcl16/submit_jcl.gif");
        IMGD_DA_SUBMIT_JCL_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/submit_jcl.gif");
        IMGD_CPWIZ = UIActivator.getImageDescriptor("icons/full/wizban/chgpkg_wiz.gif");
        IMGD_CPWIZ_APPROVE = UIActivator.getImageDescriptor("icons/full/wizban/changePackageApprove_wiz.gif");
        IMGD_CPWIZ_DISAPPROVE = UIActivator.getImageDescriptor("icons/full/wizban/changePackageDisapprove_wiz.gif");
        IMGD_CPWIZ_INSTALL = UIActivator.getImageDescriptor("icons/full/wizban/changePackageInstall_wiz.gif");
        IMGD_CPWIZ_BACKOUT = UIActivator.getImageDescriptor("icons/full/wizban/changePackageBackout_wiz.gif");
        IMGD_CPWIZ_READY = UIActivator.getImageDescriptor("icons/full/wizban/changePackageReady_wiz.gif");
        IMGD_CPWIZ_UNREADY = UIActivator.getImageDescriptor("icons/full/wizban/changePackageUnReady_wiz.gif");
        IMGD_CPWIZ_MIGRATE = UIActivator.getImageDescriptor("icons/full/wizban/changePackageMigrate_wiz.gif");
        IMGD_CONFIGWIZ = UIActivator.getImageDescriptor("icons/full/wizban/config_wiz.gif");
        IMGD_CSD_CONN_WIZ = UIActivator.getImageDescriptor("icons/full/wizban/csd_conn_wiz.png");
        IMGD_TRANS_VAR_WIZ = UIActivator.getImageDescriptor("icons/full/wizban/trans_var_wiz.png");
        IMGD_SYSTEM_OPTIONS_WIZ = UIActivator.getImageDescriptor("icons/full/wizban/system_options.gif");
        IMGD_SYSTEM_OPTIONS_TOOLBAR = UIActivator.getImageDescriptor("icons/full/elcl16/system_options.gif");
        IMGD_EXPAND_ALL = UIActivator.getImageDescriptor("icons/full/elcl16/expandall.gif");
        IMGD_EXPAND_ALL_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/expandall.gif");
        IMGD_EXPAND = UIActivator.getImageDescriptor("icons/full/elcl16/expand.gif");
        IMGD_EXPAND_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/expand.gif");
        IMGD_COLLAPSE_ALL = UIActivator.getImageDescriptor("icons/full/elcl16/collapseall.gif");
        IMGD_COLLAPSE_ALL_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/collapseall.gif");
        IMGD_COLLAPSE = UIActivator.getImageDescriptor("icons/full/elcl16/collapse.gif");
        IMGD_COLLAPSE_DISABLED = UIActivator.getImageDescriptor("icons/full/dlcl16/collapse.gif");
        IMGD_CSYSGRP = UIActivator.getImageDescriptor("icons/CSYSGRP.GIF");
        IMGD_CSYSDEF = UIActivator.getImageDescriptor("icons/CSYSDEF.GIF");
        IMGD520_CHANGE_PACKAGE = UIActivator.getImageDescriptor("icons/full/520icons/ChangePackages.gif");
        IMGD520_CHANGE_PACKAGE_NEW = UIActivator.getImageDescriptor("icons/full/520icons/ChangePackages_New.gif");
        IMGD520_CHANGE_PACKAGE_NEW_WIZARD = UIActivator.getImageDescriptor("icons/full/520icons/ChangePackagesNewWiz.gif");
        IMGD520_CONFIGURATIONS = UIActivator.getImageDescriptor("icons/full/520icons/Configurations.gif");
        IMGD520_CONFIGURATIONS_NEW = UIActivator.getImageDescriptor("icons/full/520icons/Configurations_New.gif");
        IMGD520_CONFIGURATIONS_NEW_WIZARD = UIActivator.getImageDescriptor("icons/full/520icons/ConfigurationsNewWiz.gif");
        IMGD520_CSD = UIActivator.getImageDescriptor("icons/full/520icons/CSD.gif");
        IMGD520_CSD_CONFIGURATION = UIActivator.getImageDescriptor("icons/full/520icons/CSDconfig.gif");
        IMGD520_DATA_REPOSITORY = UIActivator.getImageDescriptor("icons/full/520icons/DataRepository.gif");
        IMGD520_DATA_REPOSITORY_CONFIGURATION = UIActivator.getImageDescriptor("icons/full/520icons/DataRepositoryConfig.gif");
        IMGD520_HISTORY = UIActivator.getImageDescriptor("icons/full/520icons/History.gif");
        IMGD520_HISTORY_ITEM = UIActivator.getImageDescriptor("icons/full/520icons/HistoryItem.gif");
        IMGD520_HISTORY_ATTRIBUTE = UIActivator.getImageDescriptor("icons/full/520icons/HistoryAttribute.gif");
        IMGD520_MIGRATE = UIActivator.getImageDescriptor("icons/full/520icons/Migrate.gif");
        IMGD520_MIGRATION_SCHEME = UIActivator.getImageDescriptor("icons/full/520icons/MigrationScheme.gif");
        IMGD520_MIGRATION_SCHEME_NEW = UIActivator.getImageDescriptor("icons/full/520icons/MigrationScheme_New.gif");
        IMGD520_MIGRATION_SCHEME_NEW_WIZARD = UIActivator.getImageDescriptor("icons/full/520icons/MigrationSchemeNewWiz.gif");
        IMG_ZFS_CONFIGURATION = UIActivator.getImageDescriptor("icons/full/elcl16/FileSystemConfig.gif");
        IMG_ZFS_DEFINITION = UIActivator.getImageDescriptor("icons/full/elcl16/ZFSFILE.gif");
        IMG_ZFS_DEFINITION_NEW_WIZARD = UIActivator.getImageDescriptor("icons/full/wizban/zfsDefinition_wiz.png");
        DEBUG_GENERAL = UIActivator.getBooleanOption(OPTION_DEBUG_GENERAL, true);
    }

    private static boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = Platform.getDebugOption((String)option);
        if (optionValue != null) {
            return optionValue.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public UIActivator() {
        CMConnection.logIncomingSOAPmessages = "true".equals(Platform.getDebugOption((String)"com.ibm.cics.cm.ui/logIncomingSOAPmessages"));
        CMConnection.logOutgoingSOAPmessages = "true".equals(Platform.getDebugOption((String)"com.ibm.cics.cm.ui/logOutgoingSOAPmessages"));
        ConnectionServiceListener resourceManagerListener = new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if (event.getConnectable().getConnection() instanceof ICMSMConnection) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        ICMSMConnection cmsmConnection = (ICMSMConnection)event.getConnectable().getConnection();
                        CMConnection cmConnection = cmsmConnection.getCMConnection();
                        ConfigurationManager.getCurrent().setConnection(cmConnection);
                        ConfigurationConnectionManager.getCurrent().setConnection(cmConnection);
                        ConfigurationManager.getCurrent().setICMSMConnection(cmsmConnection);
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        ConfigurationManager.getCurrent().setConnection(null);
                        ConfigurationConnectionManager.getCurrent().setConnection(null);
                    }
                }
            }
        };
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(resourceManagerListener);
        ConfigurationManager.getCurrent().setUIListener((ICMNotificationListener)new CMNotificationListener());
    }

    public void logError(String message, Exception e) {
        this.getLog().log((IStatus)new Status(4, "com.ibm.cics.cm.ui", message, (Throwable)e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getPluginPreferences().getString("FOO");
        IMGD_CSD = new QueryCompositeImageDescriptor(UIActivator.getImage(UIActivator.getImageDescriptor("icons/full/elcl16/configuration.gif")), UIActivator.getImage(UIActivator.getImageDescriptor("icons/full/ovr16/csd.gif")));
        if (DEBUG_GENERAL) {
            logger.setLevel(Level.FINER);
            uiLogger.setLevel(Level.FINER);
        }
        uiLogger.setUseParentHandlers(true);
        String pid = "5697CIC";
        String name = Messages.getString("productName");
        IOfferingUsageRegistry offeringRegistry = UsagePlugin.getOfferingRegistry();
        offeringRegistry.findOrRegisterOffering(pid, name);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static UIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return UIActivator.imageDescriptorFromPlugin((String)"com.ibm.cics.cm.ui", (String)path);
    }

    public static Image getImage(Configuration configuration) {
        return UIActivator.getImage(UIActivator.getImageDescriptor(configuration));
    }

    public static Image getImage(ImageDescriptor descriptor) {
        Image image = UIActivator.getDefault().imageTable.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            UIActivator.plugin.imageTable.put(descriptor, image);
        }
        return image;
    }

    public static Image getBusyImage() {
        return UIActivator.getImage(IMGD_WAITING);
    }

    void init(IWorkbenchWindow workbenchWindow) {
        this.createStaticColors();
    }

    private void createStaticColors() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        COLOR_DECORATOR_FOREGROUND = display.getSystemColor(15);
    }

    public static ImageDescriptor getImageDescriptor(Configuration configuration) {
        if (configuration instanceof CSDConfiguration) {
            return IMGD520_CSD_CONFIGURATION;
        }
        if (configuration instanceof CPSMConfiguration) {
            return IMGD520_DATA_REPOSITORY_CONFIGURATION;
        }
        if (configuration instanceof ZfsConfiguration) {
            return IMG_ZFS_CONFIGURATION;
        }
        return IMGD_CONFIG_RESOURCE;
    }

    public static void decorateAsBusy(TableItem dummyTableItem) {
        dummyTableItem.setText(Messages.getString("UIActivator.DummyTableItemFetching"));
        dummyTableItem.setImage(UIActivator.getBusyImage());
    }

    public static boolean hasContent(Text searchText) {
        String searchString = searchText.getText();
        return searchString != null && searchString.trim().length() > 0;
    }

    public static HistoryView getHistoryView() {
        try {
            return (HistoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.cm.view.history");
        }
        catch (PartInitException e) {
            logger.logp(Level.SEVERE, UIActivator.class.getName(), "getHistoryView", e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static ChangePackagesView getChangePackagesView() {
        try {
            return (ChangePackagesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.cm.view.changepackages");
        }
        catch (PartInitException e) {
            logger.logp(Level.SEVERE, UIActivator.class.getName(), "getChangePackagesView", e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static ConfigurationsView getConfigurationsView() {
        try {
            return (ConfigurationsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.cm.view.configurations");
        }
        catch (PartInitException e) {
            logger.logp(Level.SEVERE, UIActivator.class.getName(), "getConfigurationsView", e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static ZfsDefinitionsView getZfsDefinitionsView() {
        try {
            return (ZfsDefinitionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.cm.view.zfsdefinitions");
        }
        catch (PartInitException e) {
            logger.logp(Level.SEVERE, UIActivator.class.getName(), "getZfsDefinitionsView", e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static MigrationSchemesView getMigrationSchemesView() {
        try {
            return (MigrationSchemesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.cm.view.migrationSchemes");
        }
        catch (PartInitException e) {
            logger.logp(Level.SEVERE, UIActivator.class.getName(), "getMigrationSchemesView", e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static SearchResultsView getSearchResultsView() {
        try {
            return (SearchResultsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.cm.view.searchresults");
        }
        catch (PartInitException e) {
            logger.logp(Level.SEVERE, UIActivator.class.getName(), "getSearchResultsView", e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static void cancelSearch() {
        SearchResultsView view = SearchResultsView.getDefault();
        if (view != null) {
            view.cancelSearch();
        }
    }

    public static void executeSearch(CMSearchQuery aQuery) {
        UIActivator.cancelSearch();
        SearchResultsView searchResultsView = UIActivator.getSearchResultsView();
        if (searchResultsView != null) {
            searchResultsView.executeSearch(aQuery);
        }
    }
}

