/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class SearchText {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Timer timer = new Timer(true);
    private Text text;
    private Requestor requestor;
    private TimerTask searchTimerTask;

    public static SearchText createFor(Text aText, Requestor aRequestor) {
        return new SearchText(aText, aRequestor);
    }

    private SearchText(Text aText, Requestor aRequestor) {
        this.text = aText;
        this.requestor = aRequestor;
        aText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SearchText.this.requestor == null) {
                    return;
                }
                if (SearchText.this.searchTimerTask != null) {
                    SearchText.this.searchTimerTask.cancel();
                }
                SearchText.this.searchTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        SearchText.this.text.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SearchText.this.requestor.searchRequested(SearchText.this.text.getText());
                            }
                        });
                    }
                };
                timer.schedule(SearchText.this.searchTimerTask, 1000L);
            }
        });
    }

    public static interface Requestor {
        public void searchRequested(String var1);
    }
}

