/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.OperatorSelection;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;

public class FilterDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CCombo commandCombo;
    private Text userText;
    private Button userButton;
    private Button commandButton;
    protected FilterExpression.Operator userOperator = FilterExpression.Operator.EQ;
    protected FilterExpression.Operator commandOperator = FilterExpression.Operator.EQ;
    private Map<String, RestrictionCriteria> restrictionFilters;
    private RestrictionCriteria commandRestrictionCriteria;
    private RestrictionCriteria userRestrictionCriteria;
    private Button nameButton;
    private RestrictionCriteria nameRestrictionCriteria;
    private FilterExpression.Operator nameOperator = FilterExpression.Operator.EQ;
    private Text nameText;
    private Button typeButton;
    private RestrictionCriteria typeRestrictionCriteria;
    private FilterExpression.Operator typeOperator = FilterExpression.Operator.EQ;
    private CCombo typeCombo;
    private Map<ICICSType, String> typesToDescriptiveNames;
    private Button groupButton;
    private RestrictionCriteria groupRestrictionCriteria;
    private FilterExpression.Operator groupOperator = FilterExpression.Operator.EQ;
    private Text groupText;

    public FilterDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        String group;
        String name;
        String userid;
        String command;
        this.setTitle(Messages.getString("FilterDialog.title"));
        this.setMessage(Messages.getString("FilterDialog.desc"));
        this.setTitleImage(ImageFactory.getFilterBanner());
        ArrayList<FilterExpression.Operator> operators = new ArrayList<FilterExpression.Operator>();
        operators.add(FilterExpression.Operator.EQ);
        operators.add(FilterExpression.Operator.NE);
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        mainComposite.setLayout((Layout)gridLayout);
        this.userButton = new Button(mainComposite, 32);
        GridData data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        this.userButton.setLayoutData((Object)data);
        Label userLabel = new Label(mainComposite, 0);
        userLabel.setText(Messages.getString("FilterDialog.label.userid"));
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        data.horizontalIndent = 5;
        userLabel.setLayoutData((Object)data);
        this.userRestrictionCriteria = this.restrictionFilters.get("JNLUSERID");
        if (this.userRestrictionCriteria != null) {
            this.userOperator = this.userRestrictionCriteria.getOperator();
        }
        OperatorSelection userOperatorSelection = new OperatorSelection(mainComposite, operators, this.userOperator){

            @Override
            protected void setOperator(FilterExpression.Operator operator) {
                FilterDialog.this.userOperator = operator;
            }
        };
        ToolItem userSelectionToolBar = userOperatorSelection.getSelectionToolBar();
        this.userText = new Text(mainComposite, 2048);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterDialog.this.userButton.setSelection(FilterDialog.this.userText.getText().length() > 0);
            }
        });
        data = new GridData(16384, 0x1000000, true, false);
        data.minimumWidth = 100;
        this.userText.setLayoutData((Object)data);
        this.commandButton = new Button(mainComposite, 32);
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 3;
        this.commandButton.setLayoutData((Object)data);
        Label commandLabel = new Label(mainComposite, 0);
        commandLabel.setText(Messages.getString("FilterDialog.label.command"));
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 3;
        data.horizontalIndent = 5;
        commandLabel.setLayoutData((Object)data);
        this.commandRestrictionCriteria = this.restrictionFilters.get("JNLAPI_COMMAND");
        if (this.commandRestrictionCriteria != null) {
            this.commandOperator = this.commandRestrictionCriteria.getOperator();
        }
        OperatorSelection commandOperatorSelection = new OperatorSelection(mainComposite, operators, this.commandOperator){

            @Override
            protected void setOperator(FilterExpression.Operator operator) {
                FilterDialog.this.commandOperator = operator;
            }
        };
        ToolItem commandSelectionToolBar = commandOperatorSelection.getSelectionToolBar();
        this.commandCombo = new CCombo(mainComposite, 2048);
        String[] items = new String[]{"CREATE", "DELETE", "RENAME", "UPDATE"};
        this.commandCombo.setItems(items);
        this.commandCombo.setEditable(false);
        data = new GridData(16384, 0x1000000, true, false);
        data.minimumWidth = 100;
        this.commandCombo.setLayoutData((Object)data);
        this.commandCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterDialog.this.commandButton.setSelection(FilterDialog.this.commandCombo.getText().length() > 0);
            }
        });
        this.nameButton = new Button(mainComposite, 32);
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        this.nameButton.setLayoutData((Object)data);
        Label nameLabel = new Label(mainComposite, 0);
        nameLabel.setText(Messages.getString("FilterDialog.label.name"));
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        data.horizontalIndent = 5;
        nameLabel.setLayoutData((Object)data);
        this.nameRestrictionCriteria = this.restrictionFilters.get("JNLOBJNAME");
        if (this.nameRestrictionCriteria != null) {
            this.nameOperator = this.nameRestrictionCriteria.getOperator();
        }
        OperatorSelection nameOperatorSelection = new OperatorSelection(mainComposite, operators, this.nameOperator){

            @Override
            protected void setOperator(FilterExpression.Operator operator) {
                FilterDialog.this.nameOperator = operator;
            }
        };
        ToolItem nameSelectionToolBar = nameOperatorSelection.getSelectionToolBar();
        this.nameText = new Text(mainComposite, 2048);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterDialog.this.nameButton.setSelection(FilterDialog.this.nameText.getText().length() > 0);
            }
        });
        data = new GridData(16384, 0x1000000, true, false);
        data.minimumWidth = 100;
        this.nameText.setLayoutData((Object)data);
        this.typeButton = new Button(mainComposite, 32);
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        this.typeButton.setLayoutData((Object)data);
        Label typeLabel = new Label(mainComposite, 0);
        typeLabel.setText(Messages.getString("FilterDialog.label.type"));
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        data.horizontalIndent = 5;
        typeLabel.setLayoutData((Object)data);
        this.typeRestrictionCriteria = this.restrictionFilters.get("JNLOBJTYPE");
        if (this.typeRestrictionCriteria != null) {
            this.typeOperator = this.typeRestrictionCriteria.getOperator();
        }
        OperatorSelection typeOperatorSelection = new OperatorSelection(mainComposite, operators, this.typeOperator){

            @Override
            protected void setOperator(FilterExpression.Operator operator) {
                FilterDialog.this.typeOperator = operator;
            }
        };
        ToolItem typeSelectionToolBar = typeOperatorSelection.getSelectionToolBar();
        this.typeCombo = new CCombo(mainComposite, 2048);
        String[] typeItems = CMUIUtilities.getDescriptiveTypeNames();
        this.typeCombo.setItems(typeItems);
        this.typeCombo.setEditable(false);
        data = new GridData(16384, 0x1000000, true, false);
        data.minimumWidth = 100;
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterDialog.this.typeButton.setSelection(FilterDialog.this.typeCombo.getText().length() > 0);
            }
        });
        this.groupButton = new Button(mainComposite, 32);
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        this.groupButton.setLayoutData((Object)data);
        Label groupLabel = new Label(mainComposite, 0);
        groupLabel.setText(Messages.getString("FilterDialog.label.group"));
        data = new GridData(131072, 0x1000000, true, false);
        data.verticalIndent = 5;
        data.horizontalIndent = 5;
        groupLabel.setLayoutData((Object)data);
        this.groupRestrictionCriteria = this.restrictionFilters.get("JNLOBJGROUP");
        if (this.groupRestrictionCriteria != null) {
            this.groupOperator = this.groupRestrictionCriteria.getOperator();
        }
        OperatorSelection groupOperatorSelection = new OperatorSelection(mainComposite, operators, this.groupOperator){

            @Override
            protected void setOperator(FilterExpression.Operator operator) {
                FilterDialog.this.groupOperator = operator;
            }
        };
        ToolItem groupSelectionToolBar = groupOperatorSelection.getSelectionToolBar();
        this.groupText = new Text(mainComposite, 2048);
        this.groupText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterDialog.this.groupButton.setSelection(FilterDialog.this.groupText.getText().length() > 0);
            }
        });
        data = new GridData(16384, 0x1000000, true, false);
        data.minimumWidth = 100;
        this.groupText.setLayoutData((Object)data);
        if (this.commandRestrictionCriteria != null && (command = this.commandRestrictionCriteria.getValue()) != null && !"".equals(command)) {
            this.commandCombo.setText(command);
        }
        if (this.userRestrictionCriteria != null && (userid = this.userRestrictionCriteria.getValue()) != null && !"".equals(userid)) {
            this.userText.setText(userid);
        }
        if (this.nameRestrictionCriteria != null && (name = this.nameRestrictionCriteria.getValue()) != null && !"".equals(name)) {
            this.nameText.setText(name);
        }
        if (this.typeRestrictionCriteria != null) {
            String type = this.typeRestrictionCriteria.getValue();
            if ((type = CMUIUtilities.getDescriptiveTypeName(type)) != null && !"".equals(type)) {
                this.typeCombo.setText(type);
            }
        }
        if (this.groupRestrictionCriteria != null && (group = this.groupRestrictionCriteria.getValue()) != null && !"".equals(group)) {
            this.groupText.setText(group);
        }
        return mainComposite;
    }

    public void setCurrentFilters(Map<String, RestrictionCriteria> restrictionFilters) {
        this.restrictionFilters = restrictionFilters;
    }

    public Map<String, RestrictionCriteria> getFilters() {
        return this.restrictionFilters;
    }

    protected void okPressed() {
        this.restrictionFilters.clear();
        if (this.userButton.getSelection()) {
            String userid = this.userText.getText();
            if (this.userRestrictionCriteria == null) {
                this.userRestrictionCriteria = new RestrictionCriteria("JNLUSERID", this.userOperator, userid);
                this.restrictionFilters.put("JNLUSERID", this.userRestrictionCriteria);
            } else {
                this.userRestrictionCriteria.setValue(userid);
                this.userRestrictionCriteria.setOperator(this.userOperator);
            }
        }
        if (this.commandButton.getSelection()) {
            String command = this.commandCombo.getText();
            if (this.commandRestrictionCriteria == null) {
                this.commandRestrictionCriteria = new RestrictionCriteria("JNLAPI_COMMAND", this.commandOperator, command);
                this.restrictionFilters.put("JNLAPI_COMMAND", this.commandRestrictionCriteria);
            } else {
                this.commandRestrictionCriteria.setValue(command);
                this.commandRestrictionCriteria.setOperator(this.commandOperator);
            }
        }
        if (this.nameButton.getSelection()) {
            String name = this.nameText.getText();
            if (this.nameRestrictionCriteria == null) {
                this.nameRestrictionCriteria = new RestrictionCriteria("JNLOBJNAME", this.nameOperator, name);
                this.restrictionFilters.put("JNLOBJNAME", this.nameRestrictionCriteria);
            } else {
                this.nameRestrictionCriteria.setValue(name);
                this.nameRestrictionCriteria.setOperator(this.nameOperator);
            }
        }
        if (this.typeButton.getSelection()) {
            String type = this.typeCombo.getText();
            type = CMUIUtilities.getTypeNameFromDescriptiveName(type);
            if (this.typeRestrictionCriteria == null) {
                this.typeRestrictionCriteria = new RestrictionCriteria("JNLOBJTYPE", this.typeOperator, type);
                this.restrictionFilters.put("JNLOBJTYPE", this.typeRestrictionCriteria);
            } else {
                this.typeRestrictionCriteria.setValue(type);
                this.typeRestrictionCriteria.setOperator(this.typeOperator);
            }
        }
        if (this.groupButton.getSelection()) {
            String group = this.groupText.getText();
            if (this.groupRestrictionCriteria == null) {
                this.groupRestrictionCriteria = new RestrictionCriteria("JNLOBJGROUP", this.groupOperator, group);
                this.restrictionFilters.put("JNLOBJGROUP", this.groupRestrictionCriteria);
            } else {
                this.groupRestrictionCriteria.setValue(group);
                this.groupRestrictionCriteria.setOperator(this.groupOperator);
            }
        }
        super.okPressed();
    }
}

