/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupMember;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CMUIUtilities
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private static HashMap<ICICSType<?>, String> typesToDescriptiveNames;
    private static HashMap<String, ICICSType> descriptiveNamesToTypes;
    private static String[] descriptiveNames;

    public static Label createHorizontalSeparator(Composite parent, int horizontalSpan) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = horizontalSpan;
        separator.setLayoutData((Object)data);
        return separator;
    }

    public static Text createName(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(Messages.getString("CMUIUtilities.0"));
        Text result = new Text(parent, 2048);
        TextInput.setAccessibleLabel((Text)result, (Label)l);
        return result;
    }

    public static Text createDescription(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(Messages.getString("CMUIUtilities.1"));
        Text descriptionText = new Text(parent, 2048);
        TextInput.setAccessibleLabel((Text)descriptionText, (Label)l);
        GridData data = new GridData(4, 0x1000000, true, false);
        descriptionText.setLayoutData((Object)data);
        return descriptionText;
    }

    public static void setCharWidth(Control aControl, int numberOfCharacters) {
        GridData data = aControl.getLayoutData() instanceof GridData ? (GridData)aControl.getLayoutData() : new GridData(4, 0x1000000, true, false);
        GC gc = new GC((Drawable)aControl);
        data.widthHint = gc.getFontMetrics().getAverageCharWidth() * numberOfCharacters;
        gc.dispose();
    }

    public static boolean isEmpty(Text aTextField) {
        return aTextField.getText() == null || aTextField.getText().trim().length() == 0;
    }

    public static void setMaxCharacters(final Text textField, final int maxNumberOfCharacters) {
        textField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (textField.getText().length() + e.text.length() > maxNumberOfCharacters) {
                    e.doit = false;
                }
            }
        });
    }

    public static Map<String, List<ResourceDefinition>> asMapOfDefinitionType(IFilteredCollection<ICMDefinition> definitions) {
        return null;
    }

    public static String getTypeAsString(ICICSDefinition cicsDefinition) {
        ICICSType cicsType = cicsDefinition.getObjectType();
        return cicsType.getResourceTableName();
    }

    public static String getDescriptiveTypeName(String resourceTableName) {
        if ("ZFSFILE".equals(resourceTableName)) {
            return Messages.getString("CMObjects.zfsDefinition");
        }
        return com.ibm.cics.core.ui.Messages.getTableDescription((String)resourceTableName);
    }

    public static String getDescriptiveTypeNamePlural(String resourceTableName) {
        if ("ZFSFILE".equals(resourceTableName)) {
            return Messages.getString("CMObjects.zfsDefinitions");
        }
        return com.ibm.cics.core.ui.Messages.getPluralTableDescription((String)resourceTableName);
    }

    public static HashMap<ICICSType<?>, String> getTypesToDescriptiveNames() {
        if (typesToDescriptiveNames == null) {
            ICICSType[] values;
            typesToDescriptiveNames = new HashMap();
            descriptiveNamesToTypes = new HashMap();
            ICICSType[] iCICSTypeArray = values = CICSTypes.values();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                ICICSType type = iCICSTypeArray[n2];
                if (CMUtilities.isValidResourceTypeForRelease((ICICSType)type)) {
                    String descriptiveName = com.ibm.cics.core.ui.Messages.getTableDescription((String)type.getResourceTableName());
                    typesToDescriptiveNames.put(type, descriptiveName);
                    descriptiveNamesToTypes.put(descriptiveName, type);
                }
                ++n2;
            }
        }
        return typesToDescriptiveNames;
    }

    public static String[] getDescriptiveTypeNames() {
        if (descriptiveNames == null) {
            CMUIUtilities.getTypesToDescriptiveNames();
            descriptiveNames = new String[descriptiveNamesToTypes.size()];
            descriptiveNamesToTypes.keySet().toArray(descriptiveNames);
            Arrays.sort(descriptiveNames);
        }
        return descriptiveNames;
    }

    public static String getTypeNameFromDescriptiveName(String descriptiveName) {
        if (descriptiveNamesToTypes == null) {
            CMUIUtilities.getTypesToDescriptiveNames();
        }
        return descriptiveNamesToTypes.get(descriptiveName).getResourceTableName();
    }

    public static ICICSType getTypeFromDescriptiveName(String descriptiveName) {
        if (descriptiveNamesToTypes == null) {
            CMUIUtilities.getTypesToDescriptiveNames();
        }
        return descriptiveNamesToTypes.get(descriptiveName);
    }

    public static boolean isCMConnection(ConnectionServiceListener.ConnectionServiceEvent event) {
        return CMUIUtilities.isCMConnection(event.getConnectionProfile());
    }

    public static boolean isCMConnection(ConnectionProfile configuration) {
        String id = configuration.getConnectionDescriptor().getId();
        return id != null && id.matches(CMSMConnection.ID);
    }

    public static String getDescriptiveNameForCPSMNoGroupResource(ICMDefinition definition) {
        String resourceString = definition.getName();
        if (definition instanceof CICSRegionGroupMember) {
            Map attr = definition.getAttributes();
            if (definition.getType().equals("CSGLCGCS")) {
                String cicsname = (String)attr.get("CICSNAME");
                String group = (String)attr.get("GROUP");
                if (cicsname != null && group != null) {
                    return MessageFormat.format(Messages.getString("ChangePackageEditor.linkname"), cicsname, group, resourceString);
                }
            } else {
                String togroup = (String)attr.get("TOGROUP");
                String group = (String)attr.get("GROUP");
                if (togroup != null && group != null) {
                    return MessageFormat.format(Messages.getString("ChangePackageEditor.linkname"), group, togroup, resourceString);
                }
            }
        } else if (definition.getType().equals("WLMDEF") || definition.getType().equals("WLMGROUP") || definition.getType().equals("TRANGRP")) {
            Map attr = definition.getAttributes();
            String desc = (String)attr.get("DESC");
            if (desc != null) {
                return MessageFormat.format(Messages.getString("ChangePackageEditor.wlmresname"), desc, resourceString);
            }
        } else if (definition.getType().equals("LNKSWSCS")) {
            Map attr = definition.getAttributes();
            String system = (String)attr.get("SYSTEM");
            String spec = (String)attr.get("SPEC");
            if (system != null && spec != null) {
                return MessageFormat.format(Messages.getString("ChangePackageEditor.linkname"), spec, system, resourceString);
            }
        } else if (definition.getType().equals("LNKSWSCG")) {
            Map attr = definition.getAttributes();
            String group = (String)attr.get("GROUP");
            String spec = (String)attr.get("SPEC");
            if (group != null && spec != null) {
                return MessageFormat.format(Messages.getString("ChangePackageEditor.linkname"), spec, group, resourceString);
            }
        } else if (definition.getType().equals("WLMINSPC")) {
            Map attr = definition.getAttributes();
            String name = (String)attr.get("NAME");
            String group = (String)attr.get("GROUP");
            if (name != null && group != null) {
                return MessageFormat.format(Messages.getString("ChangePackageEditor.linkname.in"), group, name, resourceString);
            }
        } else if (definition.getType().equals("WLMINGRP")) {
            Map attr = definition.getAttributes();
            String def = (String)attr.get("DEF");
            String group = (String)attr.get("GROUP");
            if (def != null && group != null) {
                return MessageFormat.format(Messages.getString("ChangePackageEditor.linkname.in"), def, group, resourceString);
            }
        } else if (definition.getType().equals("DTRINGRP")) {
            Map attr = definition.getAttributes();
            String trangrp = (String)attr.get("TRANGRP");
            String tranid = (String)attr.get("TRANID");
            if (trangrp != null && tranid != null) {
                return MessageFormat.format(Messages.getString("ChangePackageEditor.linkname.in"), tranid, trangrp, resourceString);
            }
        }
        return null;
    }
}

