/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui;

import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.model.ICICSplexRepository;
import com.ibm.cics.model.ICICSplex;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class CICSPlexConfigurationDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ICICSplex) {
            this.decoratePlex(((ICICSplex)element).getName(), decoration);
        } else if (element instanceof ICICSplexRepository) {
            this.decoratePlex(((ICICSplexRepository)element).getName(), decoration);
        }
    }

    private void decoratePlex(String plexName, IDecoration decoration) {
        Configuration configurationForPlex;
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection");
        IConnection connection = resourceManager.getConnection();
        if (connection instanceof ICMSMConnection && (configurationForPlex = ConfigurationManager.getCurrent().getConfigurationForPlex(plexName)) != null) {
            this.addSuffix(decoration, configurationForPlex.getName());
        }
    }

    private void addSuffix(IDecoration decoration, String suffix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" [");
        buffer.append(suffix);
        buffer.append("]");
        decoration.addSuffix(buffer.toString());
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

