/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.wizards;

import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.ProjectManager;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.zos.ui.wizards.NewJCLProjectWizard;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class NewCMProjectWizard
extends NewJCLProjectWizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(NewCMProjectWizard.class);

    public NewCMProjectWizard() {
        this.defaultProjectname = Messages.getString("NewProject_project_name");
    }

    public boolean performFinish() {
        debug.enter("performFinish");
        IProject project = this.createExternalQueriesProject(this.page.getProjectName());
        if (project != null) {
            try {
                ProjectManager.initialise(project);
                if (ProjectManager.getCurrentProject() == null) {
                    new InstanceScope().getNode(UIActivator.getDefault().getBundle().getSymbolicName()).put("PROJECT", this.page.getProjectName());
                }
            }
            catch (CoreException e) {
                debug.error("performFinish", (Throwable)e);
            }
            catch (IOException e) {
                debug.error("performFinish", (Throwable)e);
            }
        }
        debug.exit("performFinish", (Object)(project != null ? 1 : 0));
        return project != null;
    }
}

