/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.ui.da.model.PhaseReportType;
import com.ibm.cics.cm.ui.da.model.ReportSetLabel;
import com.ibm.cics.common.util.Debug;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class Deploy
extends DALabel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(Deploy.class);
    private List<Phase> phases = new ArrayList<Phase>();

    public Deploy() {
        super("DEPLOY");
    }

    public List<Phase> getPhases() {
        return this.phases;
    }

    public void addPhase(Phase phase) {
        debug.enter("addPhase");
        this.phases.add(phase);
        debug.exit("addPhase");
    }

    public List<MarkerInformation> getErrors(boolean recursive) {
        debug.enter("getErrors");
        ArrayList<MarkerInformation> errors = new ArrayList<MarkerInformation>();
        int reportSet1Runtimes = 0;
        int reportSet1Candidates = 0;
        int reportSet2Runtimes = 0;
        int reportSet2Candidates = 0;
        PhaseReportType.ReportType type = null;
        for (Phase phase : this.phases) {
            if (phase.getPhasetype() == Phase.Stage.REPORT && phase.getReportType() != null && phase.getReportType().getType() != null) {
                type = phase.getReportType().getType();
            }
            if (!recursive) continue;
            errors.addAll(phase.getErrors());
        }
        if (type == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_REPORT_PHASE_TYPE"), this.position));
        } else {
            for (Phase phase : this.phases) {
                if (phase.getPhasetype() != Phase.Stage.COLLECT) continue;
                if (phase.getReportset().getType() == ReportSetLabel.ReportSetType.ONE) {
                    if (phase.getReportType().getType() == PhaseReportType.ReportType.Runtime) {
                        ++reportSet1Runtimes;
                        if (!type.isReportSet1RuntimesAllowed()) {
                            errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.RUNTIME_PHASES_NOT_ALLOWED"), ReportSetLabel.ReportSetType.ONE.toString(), type.getReportReadable()), phase.getDisplacement()));
                            continue;
                        }
                        if (reportSet1Runtimes <= 1) continue;
                        errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TOO_MANY_RUNTIMES"), ReportSetLabel.ReportSetType.ONE.toString(), type.getReportReadable()), phase.getDisplacement()));
                        continue;
                    }
                    if (phase.getReportType().getType() != PhaseReportType.ReportType.Candidates) continue;
                    ++reportSet1Candidates;
                    if (!type.isReportSet1CandidatesAllowed()) {
                        errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.CANDIDATES_PHASES_NOT_ALLOWED"), ReportSetLabel.ReportSetType.ONE.toString(), type.getReportReadable()), phase.getDisplacement()));
                        continue;
                    }
                    if (reportSet1Candidates <= 2) continue;
                    errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TOO_MANY_CANDIDATES"), ReportSetLabel.ReportSetType.ONE.toString(), type.getReportReadable()), phase.getDisplacement()));
                    continue;
                }
                if (phase.getReportset().getType() != ReportSetLabel.ReportSetType.TWO) continue;
                if (phase.getReportType().getType() == PhaseReportType.ReportType.Runtime) {
                    ++reportSet2Runtimes;
                    if (!type.isReportSet2RuntimesAllowed()) {
                        errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.RUNTIME_PHASES_NOT_ALLOWED"), ReportSetLabel.ReportSetType.TWO.toString(), type.getReportReadable()), phase.getDisplacement()));
                        continue;
                    }
                    if (reportSet2Runtimes <= 1) continue;
                    errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TOO_MANY_RUNTIMES"), ReportSetLabel.ReportSetType.TWO.toString(), type.getReportReadable()), phase.getDisplacement()));
                    continue;
                }
                if (phase.getReportType().getType() != PhaseReportType.ReportType.Candidates) continue;
                ++reportSet2Candidates;
                if (!type.isReportSet2CandidatesAllowed()) {
                    errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.CANDIDATES_PHASES_NOT_ALLOWED"), ReportSetLabel.ReportSetType.TWO.toString(), type.getReportReadable()), phase.getDisplacement()));
                    continue;
                }
                if (reportSet2Candidates <= 2) continue;
                errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TOO_MANY_CANDIDATES"), ReportSetLabel.ReportSetType.TWO.toString(), type.getReportReadable()), phase.getDisplacement()));
            }
            this.checkReportSourcesForReport(type, reportSet1Runtimes, reportSet1Candidates, reportSet2Runtimes, reportSet2Candidates, errors);
        }
        debug.exit("getErrors", errors);
        return errors;
    }

    @Override
    public List<MarkerInformation> getErrors() {
        return this.getErrors(true);
    }

    private void checkReportSourcesForReport(PhaseReportType.ReportType type, int reportSet1Runtimes, int reportSet1Candidates, int reportSet2Runtimes, int reportSet2Candidates, List<MarkerInformation> errors) {
        if (type.isReportSet1RuntimesAllowed() && reportSet1Runtimes < 1) {
            errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.RUNTIME_PHASE_NEEDED"), ReportSetLabel.ReportSetType.ONE.toString(), type.getReportReadable()), this.position));
        }
        if (type.isReportSet1CandidatesAllowed() && reportSet1Candidates < 1) {
            errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.CANDIDATES_PHASE_NEEDED"), ReportSetLabel.ReportSetType.ONE.toString(), type.getReportReadable()), this.position));
        }
        if (type.isReportSet2RuntimesAllowed() && reportSet2Runtimes < 1) {
            errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.RUNTIME_PHASE_NEEDED"), ReportSetLabel.ReportSetType.TWO.toString(), type.getReportReadable()), this.position));
        }
        if (type.isReportSet2CandidatesAllowed() && reportSet2Candidates < 1) {
            errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.CANDIDATES_PHASE_NEEDED"), ReportSetLabel.ReportSetType.TWO.toString(), type.getReportReadable()), this.position));
        }
    }

    public int reportSet1Count() {
        return this.reportSetCount(ReportSetLabel.ReportSetType.ONE);
    }

    public int reportSet2Count() {
        return this.reportSetCount(ReportSetLabel.ReportSetType.TWO);
    }

    private int reportSetCount(ReportSetLabel.ReportSetType type) {
        int i = 0;
        for (Phase p : this.phases) {
            if (p.getReportset() == null || p.getReportset().getType() == null || p.getReportset().getType() != type) continue;
            ++i;
        }
        return i;
    }

    @Override
    public String toString() {
        StringBuffer response = new StringBuffer("DEPLOY ");
        for (Phase phase : this.phases) {
            response.append(" ");
            response.append(phase);
        }
        return response.toString();
    }

    @Override
    public String toCCVPARMSString() {
        String str = "    DEPLOY     ";
        boolean first = true;
        for (Phase phase : this.phases) {
            if (first) {
                first = false;
            } else {
                str = String.valueOf(str) + ",\n               ";
            }
            str = String.valueOf(str) + phase.toCCVPARMSString();
        }
        return str;
    }

    @Override
    protected String jclParameter() {
        return null;
    }

    @Override
    protected String getXMLTag() {
        return null;
    }
}

