/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.Connect;
import com.ibm.cics.cm.ui.da.model.DAParameterContainer;
import com.ibm.cics.cm.ui.da.model.Deploy;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.cm.ui.da.model.Ready;
import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.List;

public class DAParameterSet
extends DAParameterContainer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DAParameterSet.class);
    private Connect connectObject;
    private Deploy deployObject;
    private Ready readyObject;

    public DAParameterSet() {
        super("PARAMETERS");
    }

    public Connect getConnectObject() {
        return this.connectObject;
    }

    public void setConnectObject(Connect connectObject) {
        this.connectObject = connectObject;
    }

    public Deploy getDeployObject() {
        return this.deployObject;
    }

    public void setDeployObject(Deploy deployObject) {
        this.deployObject = deployObject;
    }

    public Ready getReadyObject() {
        return this.readyObject;
    }

    public void setReadyObject(Ready readyObject) {
        this.readyObject = readyObject;
    }

    @Override
    public List<MarkerInformation> getErrors() {
        debug.enter("getErrors");
        ArrayList<MarkerInformation> errors = new ArrayList<MarkerInformation>();
        if (this.connectObject == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_CONNECT"), 0));
        } else {
            errors.addAll(this.connectObject.getErrors());
        }
        if (this.deployObject == null && this.readyObject == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_DEPLOY"), 0));
        } else if (this.deployObject != null) {
            errors.addAll(this.deployObject.getErrors());
        } else {
            errors.addAll(this.readyObject.getErrors());
        }
        debug.exit("getErrors", errors);
        return errors;
    }

    public int findMaxProblemSeverity() {
        List<MarkerInformation> errors = this.getErrors();
        int maxSeverity = -1;
        if (errors != null) {
            for (MarkerInformation marker : errors) {
                int severity = marker.getSeverity();
                if (severity <= maxSeverity) continue;
                maxSeverity = severity;
            }
        }
        return maxSeverity;
    }

    @Override
    public String toString() {
        return "PARAMETERS " + (this.connectObject == null ? "no CONNECT" : this.connectObject.toString()) + " " + (this.deployObject == null ? "no DEPLOY" : this.deployObject.toString());
    }

    @Override
    public String toCCVPARMSString() {
        return String.valueOf(this.connectObject != null ? this.connectObject.toCCVPARMSString() : "") + (this.deployObject != null ? "\n" + this.deployObject.toCCVPARMSString() : "") + "\n/*";
    }
}

