/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.model.runtime.MessageBuffer;
import com.ibm.cics.cm.model.runtime.MessageFactory;
import com.ibm.cics.cm.ui.da.model.Configuration;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.DAParameterSet;
import com.ibm.cics.cm.ui.da.model.Group;
import com.ibm.cics.cm.ui.da.model.GrpList;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.ui.da.model.PhaseReportType;
import java.util.List;

public class DAMessageFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String constructDeployMessage(DAParameterSet parameters) {
        if (parameters != null && parameters.getDeployObject() != null) {
            MessageBuffer buffer = new MessageBuffer();
            MessageFactory.appendMessageStart((MessageBuffer)buffer);
            String collectPhases = "";
            int collectPhaseCount = 0;
            String reportPhase = "";
            List<Phase> phases = parameters.getDeployObject().getPhases();
            if (phases != null) {
                for (Phase phase : phases) {
                    if (phase.getPhasetype() == Phase.Stage.COLLECT) {
                        if (!collectPhases.isEmpty()) {
                            collectPhases = String.valueOf(collectPhases) + "\n";
                        }
                        collectPhases = String.valueOf(collectPhases) + "<LISTELEMENT>\n";
                        collectPhases = String.valueOf(collectPhases) + "<INPUTCRITERIA>\n";
                        collectPhases = String.valueOf(collectPhases) + phase.getReportset().toXMLTag() + "\n";
                        if (phase.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CSD || phase.getLocalSYSID() != null && !phase.getLocalSYSID().getLabel().isEmpty() && phase.getGroupies() != null && !phase.getGroupies().isEmpty()) {
                            if (phase.getReportType().getType() == PhaseReportType.ReportType.Runtime) {
                                collectPhases = String.valueOf(collectPhases) + "<COLLECTORTYPE>IMCS</COLLECTORTYPE>\n";
                            } else if (phase.getReportType().getType() == PhaseReportType.ReportType.Candidates) {
                                collectPhases = String.valueOf(collectPhases) + "<COLLECTORTYPE>CLCS</COLLECTORTYPE>\n";
                            }
                        } else if (phase.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CICSPlexSM || phase.getScope() != null && !phase.getScope().getLabel().isEmpty()) {
                            if (phase.getReportType().getType() == PhaseReportType.ReportType.Runtime) {
                                collectPhases = String.valueOf(collectPhases) + "<COLLECTORTYPE>IMCP</COLLECTORTYPE>\n";
                            } else if (phase.getReportType().getType() == PhaseReportType.ReportType.Candidates) {
                                collectPhases = String.valueOf(collectPhases) + "<COLLECTORTYPE>CLCP</COLLECTORTYPE>\n";
                            }
                        }
                        if (phase.getConfiguration() != null && !phase.getConfiguration().toXMLTag().isEmpty()) {
                            collectPhases = String.valueOf(collectPhases) + phase.getConfiguration().toXMLTag() + "\n";
                        }
                        if (phase.getScope() != null && !phase.getScope().toXMLTag().isEmpty()) {
                            collectPhases = String.valueOf(collectPhases) + phase.getScope().toXMLTag() + "\n";
                        }
                        if (phase.getConnection() != null && !phase.getConnection().toXMLTag().isEmpty()) {
                            collectPhases = String.valueOf(collectPhases) + phase.getConnection().toXMLTag() + "\n";
                        }
                        if (phase.getLocalSYSID() != null && !phase.getLocalSYSID().getLabel().isEmpty()) {
                            collectPhases = String.valueOf(collectPhases) + phase.getLocalSYSID().toXMLTag() + "\n";
                        }
                        if (phase.getGroupies() != null && !phase.getGroupies().isEmpty()) {
                            int groupiesCount = 0;
                            String groupies = "";
                            for (DALabel label : phase.getGroupies()) {
                                if (!(label instanceof GrpList) && !(label instanceof Group)) continue;
                                groupies = String.valueOf(groupies) + label.toXMLTag() + "\n";
                                ++groupiesCount;
                            }
                            collectPhases = String.valueOf(collectPhases) + "<GRPLISTCOUNT>" + groupiesCount + "</GRPLISTCOUNT>\n";
                            collectPhases = String.valueOf(collectPhases) + groupies;
                        }
                        collectPhases = String.valueOf(collectPhases) + "</INPUTCRITERIA>\n";
                        collectPhases = String.valueOf(collectPhases) + "<OUTPUTCRITERIA>\n";
                        collectPhases = String.valueOf(collectPhases) + "</OUTPUTCRITERIA>\n";
                        collectPhases = String.valueOf(collectPhases) + "<PROCESSPARMS>\n";
                        if (phase.getReportType().getType() == PhaseReportType.ReportType.Runtime) {
                            collectPhases = String.valueOf(collectPhases) + "<SAVEIMDATA>YES</SAVEIMDATA>\n";
                        } else if (phase.getReportType().getType() == PhaseReportType.ReportType.Candidates) {
                            collectPhases = String.valueOf(collectPhases) + "<SAVECLDATA>YES</SAVECLDATA>\n";
                        }
                        collectPhases = String.valueOf(collectPhases) + "</PROCESSPARMS>\n";
                        collectPhases = String.valueOf(collectPhases) + "</LISTELEMENT>";
                        ++collectPhaseCount;
                        continue;
                    }
                    reportPhase = String.valueOf(reportPhase) + phase.getReportType().toXMLTag() + "\n";
                    reportPhase = String.valueOf(reportPhase) + "<FILTERPARMS>\n";
                    reportPhase = String.valueOf(reportPhase) + "<FILTERCCONFIG>\n";
                    reportPhase = String.valueOf(reportPhase) + "</FILTERCCONFIG>\n";
                    reportPhase = String.valueOf(reportPhase) + (phase.getFilterDSN() != null ? String.valueOf(phase.getFilterDSN().toXMLTag()) + "\n" : "");
                    reportPhase = String.valueOf(reportPhase) + "</FILTERPARMS>\n";
                }
            }
            buffer.append("<DEPLOY>");
            buffer.append("<COLLECT>");
            buffer.append("<LISTCOUNT>" + collectPhaseCount + "</LISTCOUNT>");
            buffer.append(collectPhases);
            buffer.append("</COLLECT>");
            buffer.append("<MERGE>");
            buffer.append("</MERGE>");
            buffer.append("<AUGMENT>");
            buffer.append("</AUGMENT>");
            buffer.append("<ANALYZE>");
            buffer.append("</ANALYZE>");
            buffer.append("<REPORT>");
            buffer.append(reportPhase);
            buffer.append("</REPORT>");
            buffer.append("</DEPLOY>");
            MessageFactory.appendMessageEnd((MessageBuffer)buffer);
            return buffer.toString();
        }
        return null;
    }
}

