/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class DALabel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String label;
    protected int position;

    public String getLabel() {
        return this.label;
    }

    public DALabel(String label) {
        this.label = label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<MarkerInformation> getErrors() {
        ArrayList<MarkerInformation> errors = new ArrayList<MarkerInformation>();
        if (this.label != null && (this.label.indexOf(60) > -1 || this.label.indexOf(62) > -1)) {
            errors.add(new MarkerInformation(2, MessageFormat.format(Messages.getString("Validation.TEMPLATE_CHARACTERS"), this.basicString()), this.position));
        }
        return errors;
    }

    public void setDisplacement(int i) {
        this.position = i;
    }

    public int getDisplacement() {
        return this.position;
    }

    public String toString() {
        return String.valueOf(this.basicString()) + ' ' + this.getLabel();
    }

    public String toCCVPARMSString() {
        return String.valueOf(this.jclParameter()) + '=' + this.getLabel();
    }

    public String toXMLTag() {
        return MessageFormat.format(this.getXMLTag(), this.getLabel());
    }

    protected String basicString() {
        return "";
    }

    protected abstract String jclParameter();

    protected abstract String getXMLTag();
}

