/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.model;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.common.util.Debug;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Connect
extends DALabel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(Connect.class);
    private static final Pattern isNumeric = Pattern.compile("[-+]?\\d+(\\.\\d+)?");
    private String ipAddress = null;
    private String port = null;
    private Boolean ssl = null;

    public Connect() {
        super("CONNECT");
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public Boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    @Override
    public List<MarkerInformation> getErrors() {
        debug.enter("getErrors");
        ArrayList<MarkerInformation> errors = new ArrayList<MarkerInformation>();
        if (this.ipAddress == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_IPADDRESS"), this.position));
        } else if (this.ipAddress.indexOf(60) > -1 || this.ipAddress.indexOf(62) > -1) {
            errors.add(new MarkerInformation(1, MessageFormat.format(Messages.getString("Validation.TEMPLATE_CHARACTERS"), this.toString()), this.position));
        }
        if (this.port == null) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.NO_PORT"), this.position));
        } else if (!isNumeric.matcher(this.port).matches()) {
            errors.add(new MarkerInformation(2, Messages.getString("Validation.PORT_NOT_NUMERIC"), this.position));
        } else if (this.port.indexOf(60) > -1 || this.port.indexOf(62) > -1) {
            errors.add(new MarkerInformation(1, MessageFormat.format(Messages.getString("Validation.TEMPLATE_CHARACTERS"), this.toString()), this.position));
        }
        debug.exit("getErrors", errors);
        return errors;
    }

    @Override
    public String toString() {
        return "CONNECT " + (this.ipAddress == null ? "no IPADDRESS" : this.ipAddress.toString()) + ":" + (this.port == null ? " no port number" : this.port.toString());
    }

    public void setSSL(String nextToken) {
        this.setSsl(Boolean.parseBoolean(nextToken));
    }

    @Override
    public String toCCVPARMSString() {
        return "    CONNECT    IPADDRESS=" + (this.ipAddress != null ? this.ipAddress : "<IP Address or host name required>") + ",PORT=" + (this.port != null ? this.port : "<Port number required>") + ",SSL=" + (this.ssl != false ? "YES" : "NO");
    }

    @Override
    protected String jclParameter() {
        return null;
    }

    @Override
    protected String getXMLTag() {
        return null;
    }
}

