/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.handlers;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.ProjectManager;
import com.ibm.cics.cm.ui.da.wizards.NewCMProjectWizard;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.builder.IResourceProcessor;
import com.ibm.cics.zos.ui.editor.SubmitJobAction;
import com.ibm.cics.zos.ui.editor.jcl.JCLResourceEditor;
import com.ibm.cics.zos.ui.editor.jcl.JCLUtilities;
import com.ibm.cics.zos.ui.editor.jcl.ZOSJCLMessages;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class TemplateHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(TemplateHandler.class);
    protected StringBuffer jcl;
    protected IWorkbenchPart workbenchPart;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        debug.enter("execute");
        String id = event.getParameter("com.ibm.cics.cm.ui.da.templateName");
        if (ProjectManager.getCurrentProject() == null) {
            WizardDialog dialog1 = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)new NewCMProjectWizard());
            dialog1.setBlockOnOpen(true);
            dialog1.create();
            dialog1.open();
        }
        String mainElement = "";
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ICICSObject) {
                mainElement = ((ICICSObject)element).getName();
            } else if (element instanceof CMObject) {
                mainElement = ((CMObject)element).getName();
            }
        }
        this.jcl = ProjectManager.getTemplate(id, selection);
        if (this.jcl != null) {
            this.workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
            IFile file = ProjectManager.getNewFileName(id, mainElement);
            try {
                if (!file.exists()) {
                    file.create(JCLUtilities.getInputStream((String)this.jcl.toString()), 1, null);
                } else {
                    file.setContents(JCLUtilities.getInputStream((String)this.jcl.toString()), 0, null);
                }
                for (IResourceProcessor processor : ZOSActivator.getDefault().getBuilders()) {
                    processor.process((IResource)file);
                }
                boolean openeditor = UIActivator.getDefault().getPreferenceStore().getBoolean("EDITOR");
                if (openeditor || file.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2) > 0) {
                    FileEditorInput input = new FileEditorInput(file);
                    file.setPersistentProperty(new QualifiedName("isDA", "isDA"), "true");
                    JCLResourceEditor editor = (JCLResourceEditor)this.workbenchPart.getSite().getPage().openEditor((IEditorInput)input, "com.ibm.cics.jcl_editor");
                    editor.setTransient();
                } else {
                    TemplateHandler.submit(this.jcl.toString(), this.workbenchPart);
                    file.delete(true, null);
                }
            }
            catch (CoreException e) {
                debug.error("execute", (Throwable)e);
            }
        }
        debug.exit("execute");
        return "";
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public static void submit(final String jcl, final IWorkbenchPart workbenchPart) {
        final SubmitJobAction submitJobAction = new SubmitJobAction();
        IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        final IZOSConnectable connectable = (IZOSConnectable)connectionService.getConnectable("com.ibm.cics.zos.comm.connection");
        if (connectable == null) {
            IStatusLineManager statusLineManager;
            IStatusLineManager iStatusLineManager = statusLineManager = workbenchPart == null ? null : Utilities.getStatusLineManager((IWorkbenchPart)workbenchPart);
            if (statusLineManager != null) {
                statusLineManager.setErrorMessage(ZOSJCLMessages.JobSubmission_unable1);
            }
            debug.exit("execute", (Object)"No available connection");
            return;
        }
        if (connectable.getConnection() == null) {
            IStatusLineManager statusLineManager;
            IStatusLineManager iStatusLineManager = statusLineManager = workbenchPart == null ? null : Utilities.getStatusLineManager((IWorkbenchPart)workbenchPart);
            if (statusLineManager != null) {
                statusLineManager.setErrorMessage(ZOSJCLMessages.JobSubmission_unable2);
            }
            debug.exit("execute", (Object)"No available connection");
            return;
        }
        Action submitAction = new Action("", Activator.getImageDescriptor((String)"IMG_JOB")){

            public void run() {
                if (!connectable.getConnection().isConnected()) {
                    try {
                        connectable.getConnection().connect();
                    }
                    catch (ConnectionException e) {
                        IStatusLineManager statusLineManager;
                        debug.error("run", (Throwable)e);
                        IStatusLineManager iStatusLineManager = statusLineManager = workbenchPart == null ? null : Utilities.getStatusLineManager((IWorkbenchPart)workbenchPart);
                        if (statusLineManager != null) {
                            statusLineManager.setErrorMessage(ZOSJCLMessages.JobSubmission_unable3);
                        }
                        debug.exit("execute", (Object)"No connection");
                    }
                }
                submitJobAction.setJCL(connectable, jcl);
                submitJobAction.run((IAction)this);
            }
        };
        submitAction.run();
    }
}

