/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.builder.DAReportFileManager;
import com.ibm.cics.cm.ui.da.editors.ReportPage;
import com.ibm.cics.cm.ui.da.model.Report;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ReportViewer
extends FormEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.cm.ui.da.dareportviewer";
    private Report report;
    private ReportPage mainReportPage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(MessageFormat.format(Messages.getString("ReportViewer.partname"), input.getName()));
        if (input instanceof IFileEditorInput) {
            IFileEditorInput daInput = (IFileEditorInput)input;
            Report report = null;
            try {
                report = DAReportFileManager.createDAReportFromXML(daInput.getFile().getContents(), daInput.getFile().getName());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.report = report;
            this.setPartName(report.getName());
        }
    }

    public FormToolkit getToolkit() {
        if (super.getToolkit() == null) {
            super.createToolkit(Display.getCurrent());
        }
        return super.getToolkit();
    }

    protected void addPages() {
        try {
            this.mainReportPage = new ReportPage(this);
            this.addPage((IFormPage)this.mainReportPage);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public void setFocus() {
        if (this.mainReportPage != null) {
            this.mainReportPage.setFocus();
        } else {
            super.setFocus();
        }
    }

    public Report getReport() {
        return this.report;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

