/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.DeployMessageResponse;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.DAUtilities;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.ProjectManager;
import com.ibm.cics.cm.ui.da.builder.DAReportFileManager;
import com.ibm.cics.cm.ui.da.composites.CPSMOptions;
import com.ibm.cics.cm.ui.da.composites.CSDCandidateOptions;
import com.ibm.cics.cm.ui.da.composites.CSDRuntimeOptions;
import com.ibm.cics.cm.ui.da.composites.ConfigurationComposite;
import com.ibm.cics.cm.ui.da.model.Configuration;
import com.ibm.cics.cm.ui.da.model.Connection;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.DAMessageFactory;
import com.ibm.cics.cm.ui.da.model.DAParameterSet;
import com.ibm.cics.cm.ui.da.model.Deploy;
import com.ibm.cics.cm.ui.da.model.GrpList;
import com.ibm.cics.cm.ui.da.model.Localsysid;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.ui.da.model.PhaseReportType;
import com.ibm.cics.cm.ui.da.model.ReportSetLabel;
import com.ibm.cics.cm.ui.da.model.Scope;
import com.ibm.cics.cm.ui.widgets.CPSMScopeTextInput;
import com.ibm.cics.cm.ui.widgets.CSDConnectionsForConfigurationTextInput;
import com.ibm.cics.cm.utilities.ListeningArrayList;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.ui.editor.jcl.JCLResourceEditor;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;

public class ReportQueryEditorPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAGE_ID = "dareportqueryeditor";
    private PhaseReportType.ReportType type;
    private JCLResourceEditor editor;
    private DAParameterSet parameters;
    private Composite reportSetArea;
    private Form editorForm;
    private Composite rs1Area;
    private Composite rs2Area;
    private ListeningArrayList<Composite> rs1Sections;
    private ListeningArrayList<Composite> rs2Sections;
    private boolean loadingPage;
    private Composite reportArea;
    private Composite body;
    private ScrolledForm sForm;
    private IManagedForm mForm;
    private ConnectionServiceListener listener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            ReportQueryEditorPage.this.runButtonsCheck();
        }
    };
    private boolean reportQueryChanging;
    private Action submitJobButton;
    private Action runNowButton;
    private Text reportDescription;
    private HyperlinkAdapter messageHyperlinkListener;

    public ReportQueryEditorPage(JCLResourceEditor editor) {
        super((FormEditor)editor, PAGE_ID, Messages.getString("ReportQueryEditor.title"));
        this.initialize((FormEditor)editor);
        this.editor = editor;
        this.type = PhaseReportType.ReportType.ColdStartCompare;
        this.loadingPage = false;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.mForm = managedForm;
        FormToolkit toolkit = this.mForm.getToolkit();
        this.sForm = this.mForm.getForm();
        Form form = this.sForm.getForm();
        this.body = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        this.body.setLayout((Layout)layout);
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.listener);
        this.editorForm = this.editor.getHeaderForm().getForm().getForm();
        this.editorForm.setText(Messages.getString("ReportQueryEditor.title"));
        this.editorForm.setImage(this.editor.getTitleImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, this.getHelpContextID());
        int borderStyle = toolkit.getBorderStyle();
        toolkit.setBorderStyle(0);
        this.reportDescription = toolkit.createText(this.body, "", 74);
        GridData rd = new GridData(4, 16384, true, false);
        rd.widthHint = 300;
        this.reportDescription.setLayoutData((Object)rd);
        this.reportDescription.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = MessageFormat.format(Messages.getString("ReportQueryEditor.accessible.reportDescription"), ReportQueryEditorPage.this.editorForm.getText(), ReportQueryEditorPage.this.reportDescription.getText());
            }
        });
        toolkit.setBorderStyle(borderStyle);
        this.reportArea = toolkit.createComposite(this.body, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.reportArea.setLayout((Layout)layout);
        this.reportArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.reportSetArea = toolkit.createComposite(this.reportArea, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        this.reportSetArea.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 300;
        this.reportSetArea.setLayoutData((Object)gd);
        this.refreshToolbar();
        this.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (ReportQueryEditorPage.this.reportQueryChanging) {
                    ReportQueryEditorPage.this.reportQueryChanging = false;
                } else {
                    ReportQueryEditorPage.this.reloadDocument();
                }
                ReportQueryEditorPage.this.runButtonsCheck();
                ReportQueryEditorPage.this.checkDeployErrors();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private void refreshToolbar() {
        IToolBarManager toolbar = this.editor.getHeaderForm().getForm().getToolBarManager();
        ArrayList<IContributionItem> currentItems = new ArrayList<IContributionItem>();
        IContributionItem[] iContributionItemArray = toolbar.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            boolean removed = false;
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()).getActionDefinitionId() != null && action.getActionDefinitionId().equals("com.ibm.cics.zos.ui.submitjob")) {
                toolbar.remove(item);
                removed = true;
            }
            if (!removed) {
                currentItems.add(toolbar.remove(item));
            }
            ++n2;
        }
        this.runNowButton = new Action(Messages.getString("ReportQueryEditor.link.runnow"), 1){

            public int getStyle() {
                return 1;
            }

            public ImageDescriptor getImageDescriptor() {
                return UIActivator.IMGD_RUN;
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return UIActivator.IMGD_RUN_DISABLED;
            }

            public void run() {
                ReportQueryEditorPage.this.runNow();
            }
        };
        this.runNowButton.setId("com.ibm.cics.cm.ui.da.runnow");
        this.getEditorSite().getActionBars().updateActionBars();
        toolbar.add((IAction)this.runNowButton);
        this.submitJobButton = new Action(Messages.getString("ReportQueryEditor.link.submitjcl"), 1){

            public int getStyle() {
                return 1;
            }

            public ImageDescriptor getImageDescriptor() {
                return UIActivator.IMGD_DA_SUBMIT_JCL;
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return UIActivator.IMGD_DA_SUBMIT_JCL_DISABLED;
            }

            public void run() {
                String[] error;
                if (ReportQueryEditorPage.this.editor.isDirty()) {
                    MessageDialog mBox = new MessageDialog(UIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("ReportQueryEditor.dialog.run.save.title"), null, Messages.getString("ReportQueryEditor.dialog.run.save.jcl"), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                    if (mBox.open() == 0) {
                        ReportQueryEditorPage.this.editor.doSave(null);
                    } else {
                        return;
                    }
                }
                if ((error = ReportQueryEditorPage.this.runJCLCheck()) != null) {
                    ReportQueryEditorPage.this.showRunJCLErrorMessage(error);
                } else {
                    ReportQueryEditorPage.this.editor.submitJob();
                }
            }
        };
        this.submitJobButton.setId("com.ibm.cics.cm.ui.da.submitjob");
        this.getEditorSite().getActionBars().updateActionBars();
        toolbar.add((IAction)this.submitJobButton);
        for (IContributionItem item : currentItems) {
            toolbar.add(item);
        }
        this.getEditorSite().getActionBars().updateActionBars();
        toolbar.update(true);
    }

    private void createReportSetArea() {
        Control[] children;
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.rs1Sections = new ListeningArrayList();
        this.rs2Sections = new ListeningArrayList();
        Control[] controlArray = children = this.reportSetArea.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Section reportSet1 = toolkit.createSection(this.reportSetArea, 322);
        reportSet1.setText(Messages.getString("ReportQueryEditor.section.REPORTSET.1"));
        reportSet1.setLayoutData((Object)new GridData(4, -1, true, false));
        this.rs1Area = toolkit.createComposite((Composite)reportSet1, 0);
        GridLayout gl1 = new GridLayout(1, false);
        gl1.marginWidth = 0;
        this.rs1Area.setLayout((Layout)gl1);
        reportSet1.setClient((Control)this.rs1Area);
        this.rs1Area.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        final Composite rs1Toolbar = new Composite((Composite)reportSet1, 0);
        RowLayout rs1Layout = new RowLayout(256);
        rs1Layout.spacing = 0;
        rs1Layout.marginTop = 0;
        rs1Layout.marginRight = 0;
        rs1Layout.marginLeft = 0;
        rs1Layout.marginBottom = 0;
        rs1Toolbar.setLayout((Layout)rs1Layout);
        reportSet1.setTextClient((Control)rs1Toolbar);
        final ImageHyperlink rs1AddLink = new ImageHyperlink(rs1Toolbar, 0);
        rs1AddLink.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ADD));
        rs1AddLink.setToolTipText(Messages.getString("ReportQueryEditor.link.add.reportSetArea"));
        rs1AddLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (ReportQueryEditorPage.this.type == PhaseReportType.ReportType.Candidates || ReportQueryEditorPage.this.type == PhaseReportType.ReportType.CandidatesCompare || ReportQueryEditorPage.this.type == PhaseReportType.ReportType.Check) {
                    Phase candidates = ReportQueryEditorPage.this.addCollectPhase(ReportSetLabel.ReportSetType.ONE, PhaseReportType.ReportType.Candidates);
                    ReportQueryEditorPage.this.rs1Sections.add((Object)ReportQueryEditorPage.this.createReportSetSourceSection(PhaseReportType.ReportType.Candidates, ReportQueryEditorPage.this.rs1Area, ReportQueryEditorPage.this.getManagedForm().getToolkit(), ReportSetLabel.ReportSetType.ONE, candidates));
                    ReportQueryEditorPage.this.refreshComposite(ReportQueryEditorPage.this.rs1Area);
                    ReportQueryEditorPage.this.refreshDocument();
                } else {
                    Phase runtime = ReportQueryEditorPage.this.addCollectPhase(ReportSetLabel.ReportSetType.ONE, PhaseReportType.ReportType.Runtime);
                    ReportQueryEditorPage.this.rs1Sections.add((Object)ReportQueryEditorPage.this.createReportSetSourceSection(PhaseReportType.ReportType.Runtime, ReportQueryEditorPage.this.rs1Area, ReportQueryEditorPage.this.getManagedForm().getToolkit(), ReportSetLabel.ReportSetType.ONE, runtime));
                    ReportQueryEditorPage.this.refreshComposite(ReportQueryEditorPage.this.rs1Area);
                    ReportQueryEditorPage.this.refreshDocument();
                }
            }
        });
        int borderStyle = toolkit.getBorderStyle();
        toolkit.setBorderStyle(0);
        Text reportSet1Desc = toolkit.createText(this.rs1Area, this.type.getReportSet1Desc(), 74);
        GridData gd = new GridData(4, 16384, true, false);
        gd.widthHint = 300;
        reportSet1Desc.setLayoutData((Object)gd);
        toolkit.setBorderStyle(borderStyle);
        ListeningArrayList<Composite> listeningArrayList = this.rs1Sections;
        listeningArrayList.getClass();
        this.rs1Sections.addListener(new ListeningArrayList.ArrayListListener(listeningArrayList, this.rs1Sections){

            public void notify(boolean changed, ListeningArrayList<?> source) {
                if (source.size() == 1 && (ReportQueryEditorPage.this.type == PhaseReportType.ReportType.Candidates || ReportQueryEditorPage.this.type == PhaseReportType.ReportType.CandidatesCompare || ReportQueryEditorPage.this.type == PhaseReportType.ReportType.Check)) {
                    rs1AddLink.setVisible(true);
                } else {
                    rs1AddLink.setVisible(false);
                }
                ReportQueryEditorPage.this.refreshComposite(rs1Toolbar);
            }
        });
        if (this.parameters.getDeployObject().reportSet2Count() > 0 || this.type != PhaseReportType.ReportType.Runtime && this.type != PhaseReportType.ReportType.Candidates && this.type != PhaseReportType.ReportType.Check) {
            Section reportSet2 = toolkit.createSection(this.reportSetArea, 322);
            reportSet2.setText(Messages.getString("ReportQueryEditor.section.REPORTSET.2"));
            reportSet2.setLayoutData((Object)new GridData(4, -1, true, false));
            this.rs2Area = toolkit.createComposite((Composite)reportSet2, 0);
            GridLayout gl2 = new GridLayout(1, false);
            gl2.marginWidth = 0;
            this.rs2Area.setLayout((Layout)gl2);
            reportSet2.setClient((Control)this.rs2Area);
            this.rs2Area.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
            final Composite rs2Toolbar = new Composite((Composite)reportSet2, 0);
            RowLayout rs2Layout = new RowLayout(256);
            rs2Layout.spacing = 0;
            rs2Layout.marginTop = 0;
            rs2Layout.marginRight = 0;
            rs2Layout.marginLeft = 0;
            rs2Layout.marginBottom = 0;
            rs2Toolbar.setLayout((Layout)rs2Layout);
            reportSet2.setTextClient((Control)rs2Toolbar);
            final ImageHyperlink rs2AddLink = new ImageHyperlink(rs2Toolbar, 0);
            rs2AddLink.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ADD));
            rs2AddLink.setToolTipText(Messages.getString("ReportQueryEditor.link.add.reportSetArea"));
            rs2AddLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (ReportQueryEditorPage.this.type == PhaseReportType.ReportType.ColdStartCompare || ReportQueryEditorPage.this.type == PhaseReportType.ReportType.CandidatesCompare) {
                        Phase candidates = ReportQueryEditorPage.this.addCollectPhase(ReportSetLabel.ReportSetType.TWO, PhaseReportType.ReportType.Candidates);
                        ReportQueryEditorPage.this.rs2Sections.add((Object)ReportQueryEditorPage.this.createReportSetSourceSection(PhaseReportType.ReportType.Candidates, ReportQueryEditorPage.this.rs2Area, ReportQueryEditorPage.this.getManagedForm().getToolkit(), ReportSetLabel.ReportSetType.TWO, candidates));
                        ReportQueryEditorPage.this.refreshComposite(ReportQueryEditorPage.this.rs2Area);
                        ReportQueryEditorPage.this.refreshDocument();
                    } else {
                        Phase runtime = ReportQueryEditorPage.this.addCollectPhase(ReportSetLabel.ReportSetType.TWO, PhaseReportType.ReportType.Runtime);
                        ReportQueryEditorPage.this.rs2Sections.add((Object)ReportQueryEditorPage.this.createReportSetSourceSection(PhaseReportType.ReportType.Runtime, ReportQueryEditorPage.this.rs2Area, ReportQueryEditorPage.this.getManagedForm().getToolkit(), ReportSetLabel.ReportSetType.TWO, runtime));
                        ReportQueryEditorPage.this.refreshComposite(ReportQueryEditorPage.this.rs2Area);
                        ReportQueryEditorPage.this.refreshDocument();
                    }
                }
            });
            borderStyle = toolkit.getBorderStyle();
            toolkit.setBorderStyle(0);
            Text reportSet2Desc = toolkit.createText(this.rs2Area, this.type.getReportSet2Desc(), 74);
            gd = new GridData(4, 16384, true, false);
            gd.widthHint = 300;
            reportSet2Desc.setLayoutData((Object)gd);
            toolkit.setBorderStyle(borderStyle);
            ListeningArrayList<Composite> listeningArrayList2 = this.rs2Sections;
            listeningArrayList2.getClass();
            this.rs2Sections.addListener(new ListeningArrayList.ArrayListListener(listeningArrayList2, this.rs2Sections){

                public void notify(boolean changed, ListeningArrayList<?> source) {
                    if (source.size() == 1 && (ReportQueryEditorPage.this.type == PhaseReportType.ReportType.ColdStartCompare || ReportQueryEditorPage.this.type == PhaseReportType.ReportType.CandidatesCompare)) {
                        rs2AddLink.setVisible(true);
                    } else {
                        rs2AddLink.setVisible(false);
                    }
                    ReportQueryEditorPage.this.refreshComposite(rs2Toolbar);
                }
            });
        }
        this.editorForm.setText(this.type.getReportReadable());
        this.reportDescription.setText(this.type.getReportDescription());
        this.refreshComposite(this.rs1Area);
        this.refreshComposite(this.rs2Area);
    }

    public Composite createReportSetSourceSection(final PhaseReportType.ReportType type, Composite parent, final FormToolkit toolkit, ReportSetLabel.ReportSetType rsType, final Phase phase) {
        List<DALabel> plainGroupies;
        String configurationName;
        final Composite composite = this.createReportSetSection(parent, type == PhaseReportType.ReportType.Runtime ? Messages.getString("ReportQueryEditor.section.RUNTIME") : Messages.getString("ReportQueryEditor.section.CANDIDATES"), toolkit, rsType, phase);
        final ConfigurationComposite configuration = new ConfigurationComposite(composite, 0, toolkit, phase);
        configuration.getText().addModifyListener((ModifyListener)new FieldModifyListener());
        final HashMap optionsWidgets = new HashMap();
        ConfigurationComposite configurationComposite = configuration;
        configurationComposite.getClass();
        configuration.addListener(new ConfigurationComposite.ConfigurationCompositeListener(configurationComposite, configuration){

            @Override
            public void notify(boolean changed, ConfigurationComposite.ConfigurationCompositeListener source) {
                com.ibm.cics.cm.model.Configuration rawConfig;
                boolean exists = false;
                boolean contentChanged = false;
                boolean cpsmSelection = configuration.getCPSMRadio().getSelection();
                boolean csdSelection = configuration.getCSDRadio().getSelection();
                CPSMScopeTextInput cpsmScopeInput = null;
                CSDConnectionsForConfigurationTextInput csdConnectionInput = null;
                ArrayList<Control> toRemove = new ArrayList<Control>();
                for (Control control : optionsWidgets.keySet()) {
                    if (cpsmSelection) {
                        if (((String)optionsWidgets.get(control)).equalsIgnoreCase("cpsm")) {
                            exists = true;
                            if (control instanceof CPSMScopeTextInput) {
                                cpsmScopeInput = (CPSMScopeTextInput)control;
                            }
                        } else {
                            control.dispose();
                            toRemove.add(control);
                            contentChanged = true;
                        }
                        phase.getGroupies().clear();
                        phase.setLocalSYSID(null);
                        phase.setConnection(null);
                        continue;
                    }
                    if (!csdSelection) continue;
                    if (((String)optionsWidgets.get(control)).equalsIgnoreCase("csd")) {
                        exists = true;
                        if (control instanceof CSDConnectionsForConfigurationTextInput) {
                            csdConnectionInput = (CSDConnectionsForConfigurationTextInput)control;
                        }
                    } else {
                        control.dispose();
                        toRemove.add(control);
                        contentChanged = true;
                    }
                    phase.setScope(null);
                }
                for (Control control : toRemove) {
                    optionsWidgets.remove(control);
                }
                toRemove.clear();
                if (cpsmSelection) {
                    if (phase.getScope() == null) {
                        phase.setScope(new Scope("<CICS region to be used as scope>", phase));
                    }
                    if (!exists) {
                        CPSMOptions cpsm = new CPSMOptions(composite, toolkit, phase, optionsWidgets, configuration);
                        cpsmScopeInput = cpsm.getScopeInput();
                        cpsmScopeInput.text.addModifyListener((ModifyListener)new FieldModifyListener());
                    }
                    if (phase.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CICSPlexSM) {
                        if (cpsmScopeInput != null && ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected()) {
                            rawConfig = ConfigurationManager.getCurrent().getCachedConfiguration(phase.getConfiguration().getLabel());
                            if (rawConfig != null && rawConfig instanceof CPSMConfiguration) {
                                cpsmScopeInput.setCPSMConfiguration((CPSMConfiguration)rawConfig);
                            } else {
                                cpsmScopeInput.setCPSMConfiguration(null);
                            }
                        }
                    } else if (cpsmScopeInput != null) {
                        cpsmScopeInput.setCPSMConfiguration(null);
                    }
                    contentChanged = true;
                }
                if (csdSelection) {
                    if (type == PhaseReportType.ReportType.Runtime && phase.getConnection() == null) {
                        phase.setConnection(new Connection("<Connection used by the CICS CM server>", phase));
                    } else if (type == PhaseReportType.ReportType.Candidates && phase.getLocalSYSID() == null) {
                        phase.setLocalSYSID(new Localsysid("<CICS sysid evaluated as local>", phase));
                    }
                    if (!exists) {
                        Object csd;
                        if (type == PhaseReportType.ReportType.Runtime) {
                            csd = new CSDRuntimeOptions(composite, toolkit, phase, optionsWidgets);
                            csdConnectionInput = ((CSDRuntimeOptions)csd).getConnectionInput();
                            csdConnectionInput.text.addModifyListener((ModifyListener)new FieldModifyListener());
                        } else {
                            csd = new CSDCandidateOptions(composite, toolkit, phase, optionsWidgets);
                            ((CSDCandidateOptions)csd).getLocalSysIDText().addModifyListener((ModifyListener)new FieldModifyListener());
                        }
                    }
                    if (phase.getConfigurationTypeForPhase() == Configuration.ConfigurationType.CSD) {
                        if (csdConnectionInput != null && ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected()) {
                            rawConfig = ConfigurationManager.getCurrent().getCachedConfiguration(phase.getConfiguration().getLabel());
                            if (rawConfig != null && rawConfig instanceof CSDConfiguration) {
                                csdConnectionInput.setCSDConfiguration((CSDConfiguration)rawConfig);
                            } else {
                                csdConnectionInput.setCSDConfiguration(null);
                            }
                        }
                    } else if (csdConnectionInput != null) {
                        csdConnectionInput.setCSDConfiguration(null);
                    }
                    contentChanged = true;
                }
                if (contentChanged) {
                    ReportQueryEditorPage.this.refreshComposite(composite);
                }
            }
        });
        if (phase != null && phase.getConfiguration() != null && (configurationName = phase.getConfiguration().getLabel()) != null && !configurationName.isEmpty()) {
            if (!configurationName.contains("<") || !configurationName.contains(">")) {
                configuration.getText().setText(configurationName);
            } else {
                configuration.getText().setText(" ");
                configuration.getText().setText("");
            }
        }
        if ((plainGroupies = phase.getGroupies()) instanceof ListeningArrayList) {
            ListeningArrayList groupies;
            ListeningArrayList listeningArrayList = groupies = (ListeningArrayList)plainGroupies;
            listeningArrayList.getClass();
            ListeningArrayList.ArrayListListener groupiesListener = new ListeningArrayList.ArrayListListener(listeningArrayList, groupies){

                public void notify(boolean changed, ListeningArrayList<?> source) {
                    ReportQueryEditorPage.this.refreshDocument();
                }
            };
            groupies.addListener(groupiesListener);
        }
        return composite;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.loadingPage = true;
        if (active) {
            this.reloadDocument();
        }
        this.loadingPage = false;
        this.refreshComposite(null);
    }

    private ITypedRegion getCCVPARMSRegion() {
        ITypedRegion[] partitions;
        ITypedRegion[] iTypedRegionArray = partitions = this.getDocument().getDocumentPartitioner().computePartitioning(0, this.getDocument().getLength());
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion region = iTypedRegionArray[n2];
            if (region.getType().equals("__dftl_partition_content_type")) {
                return region;
            }
            ++n2;
        }
        return null;
    }

    private void reloadDocument() {
        this.parameters = new DAParameterSet();
        ITypedRegion region = this.getCCVPARMSRegion();
        if (region != null) {
            DAUtilities.createDAObjects(region.getOffset(), region.getLength(), this.getDocument(), this.parameters);
            this.type = null;
            List<Phase> phases = this.getPhases();
            for (Phase phase : phases) {
                PhaseReportType.ReportType type;
                Phase.Stage stage = phase.getPhasetype();
                if (stage != Phase.Stage.REPORT || (type = phase.getReportType().getType()) == null) continue;
                this.type = type;
                break;
            }
            if (this.type == null) {
                this.type = PhaseReportType.ReportType.ColdStartCompare;
            }
            if (this.isActive()) {
                this.createReportSetArea();
                this.fillReportSetArea();
            }
        }
    }

    private void fillReportSetArea() {
        List<Phase> phases = this.getPhases();
        if (phases != null && !phases.isEmpty()) {
            int rs1Runtimes = 0;
            int rs1Candidates = 0;
            int rs2Runtimes = 0;
            int rs2Candidates = 0;
            for (Phase phase : phases) {
                if (phase.getPhasetype() != Phase.Stage.COLLECT) continue;
                PhaseReportType.ReportType type = phase.getReportType().getType();
                FormToolkit toolkit = this.getManagedForm().getToolkit();
                ReportSetLabel.ReportSetType rsType = phase.getReportset().getType();
                if (rsType == ReportSetLabel.ReportSetType.ONE) {
                    if (type == PhaseReportType.ReportType.Runtime && this.type.isReportSet1RuntimesAllowed() && rs1Runtimes < 1) {
                        this.rs1Sections.add((Object)this.createReportSetSourceSection(PhaseReportType.ReportType.Runtime, this.rs1Area, toolkit, rsType, phase));
                        ++rs1Runtimes;
                        continue;
                    }
                    if (type != PhaseReportType.ReportType.Candidates || !this.type.isReportSet1CandidatesAllowed() || rs1Candidates >= 2) continue;
                    this.rs1Sections.add((Object)this.createReportSetSourceSection(PhaseReportType.ReportType.Candidates, this.rs1Area, toolkit, rsType, phase));
                    ++rs1Candidates;
                    continue;
                }
                if (type == PhaseReportType.ReportType.Runtime && this.type.isReportSet2RuntimesAllowed() && rs2Runtimes < 1) {
                    this.rs2Sections.add((Object)this.createReportSetSourceSection(PhaseReportType.ReportType.Runtime, this.rs2Area, toolkit, rsType, phase));
                    ++rs2Runtimes;
                    continue;
                }
                if (type != PhaseReportType.ReportType.Candidates || !this.type.isReportSet2CandidatesAllowed() || rs2Candidates >= 2) continue;
                this.rs2Sections.add((Object)this.createReportSetSourceSection(PhaseReportType.ReportType.Candidates, this.rs2Area, toolkit, rsType, phase));
                ++rs2Candidates;
            }
        }
    }

    public void refreshDocument() {
        try {
            if (!this.loadingPage) {
                this.reportQueryChanging = true;
                ITypedRegion region = this.getCCVPARMSRegion();
                if (region != null) {
                    this.getDocument().replace(region.getOffset(), region.getLength(), this.parameters.toCCVPARMSString());
                }
            }
            this.runButtonsCheck();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.da.report_query_editor_page";
    }

    private IDocument getDocument() {
        return this.editor.getJCLTextEditor().getDocument();
    }

    private List<Phase> getPhases() {
        Deploy deploy;
        if (this.parameters != null && (deploy = this.parameters.getDeployObject()) != null) {
            return deploy.getPhases();
        }
        return null;
    }

    private Phase addCollectPhase(ReportSetLabel.ReportSetType reportSetType, PhaseReportType.ReportType reportType) {
        List<Phase> phases = this.getPhases();
        if (phases != null) {
            Phase phase = new Phase(Phase.Stage.COLLECT.toString());
            phase.setReportset(new ReportSetLabel());
            phase.getReportset().setType(reportSetType.toString());
            phase.setPhaseReportType(new PhaseReportType(reportType.toString()));
            switch (reportType) {
                case Candidates: {
                    phase.setConfiguration(new Configuration("<Config-name for a CSD file>"));
                    phase.addGrpList(new GrpList("<CSD-List name>", phase));
                    phase.setLocalSYSID(new Localsysid("<CICS sysid evaluated as local>", phase));
                    break;
                }
                case Runtime: {
                    phase.setConfiguration(new Configuration("<Config-name for a CSD file>"));
                    phase.setConnection(new Connection("<Connection used by the CICS CM server>", phase));
                    break;
                }
            }
            int i = 0;
            while (i < phases.size()) {
                Phase iPhase = phases.get(i);
                Phase.Stage rsPhase = iPhase.getPhasetype();
                if (rsPhase == Phase.Stage.COLLECT) {
                    ReportSetLabel.ReportSetType rsType;
                    ReportSetLabel rs = iPhase.getReportset();
                    if (rs != null && (rsType = rs.getType()) != null && reportSetType == ReportSetLabel.ReportSetType.ONE && rsType == ReportSetLabel.ReportSetType.TWO) {
                        phases.add(i, phase);
                        return phase;
                    }
                } else {
                    phases.add(i, phase);
                    return phase;
                }
                ++i;
            }
            phases.add(phase);
            return phase;
        }
        return null;
    }

    private void removeCollectPhase(Phase phase) {
        List<Phase> phases = this.getPhases();
        if (phases != null) {
            phases.remove(phase);
        }
    }

    public Composite createReportSetSection(Composite parent, String title, FormToolkit toolkit, final ReportSetLabel.ReportSetType rsType, final Phase phase) {
        final Section section = toolkit.createSection(parent, 322);
        section.setText(title);
        section.setLayoutData((Object)new GridData(4, -1, true, false));
        final Composite area = toolkit.createComposite((Composite)section, 0);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.horizontalSpacing = 15;
        area.setLayout((Layout)gLayout);
        section.setClient((Control)area);
        area.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        final Composite toolbar = new Composite((Composite)section, 0);
        RowLayout layout = new RowLayout(256);
        layout.spacing = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        toolbar.setLayout((Layout)layout);
        section.setTextClient((Control)toolbar);
        final ImageHyperlink deleteLink = new ImageHyperlink(toolbar, 0);
        deleteLink.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_DELETE));
        deleteLink.setToolTipText(Messages.getString("ReportQueryEditor.link.delete.reportSetArea"));
        ListeningArrayList<Composite> lal = null;
        ListeningArrayList.ArrayListListener all = null;
        if (rsType == ReportSetLabel.ReportSetType.ONE) {
            lal = this.rs1Sections;
        } else if (rsType == ReportSetLabel.ReportSetType.TWO) {
            lal = this.rs2Sections;
        }
        if (lal != null) {
            ListeningArrayList<Composite> listeningArrayList = lal;
            listeningArrayList.getClass();
            all = new ListeningArrayList.ArrayListListener(listeningArrayList, lal){

                public void notify(boolean changed, ListeningArrayList<?> source) {
                    if (source.size() > 1) {
                        deleteLink.setVisible(true);
                    } else {
                        deleteLink.setVisible(false);
                    }
                    ReportQueryEditorPage.this.refreshComposite(toolbar);
                }
            };
            lal.addListener(all);
        }
        final ListeningArrayList<Composite> lal2 = lal;
        final ListeningArrayList.ArrayListListener all2 = all;
        deleteLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (rsType == ReportSetLabel.ReportSetType.ONE) {
                    ReportQueryEditorPage.this.rs1Sections.remove((Object)area);
                } else if (rsType == ReportSetLabel.ReportSetType.TWO) {
                    ReportQueryEditorPage.this.rs2Sections.remove((Object)area);
                }
                ReportQueryEditorPage.this.removeCollectPhase(phase);
                if (lal2 != null && all2 != null) {
                    lal2.removeListener(all2);
                }
                section.dispose();
                ReportQueryEditorPage.this.refreshComposite(ReportQueryEditorPage.this.rs1Area);
                ReportQueryEditorPage.this.refreshComposite(ReportQueryEditorPage.this.rs2Area);
                ReportQueryEditorPage.this.refreshDocument();
            }
        });
        return area;
    }

    private void refreshComposite(Composite composite) {
        if (composite != null) {
            composite.layout();
        }
        if (!this.loadingPage) {
            this.sForm.layout(true, true);
            this.sForm.reflow(true);
        }
    }

    private void runButtonsCheck() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean runNowOK;
                boolean jclOK;
                boolean bl = jclOK = ReportQueryEditorPage.this.runJCLCheck() == null;
                if (ReportQueryEditorPage.this.submitJobButton != null) {
                    ReportQueryEditorPage.this.submitJobButton.setEnabled(jclOK);
                }
                boolean bl2 = runNowOK = ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected() && ReportQueryEditorPage.this.parameters.findMaxProblemSeverity() < 2;
                if (ReportQueryEditorPage.this.runNowButton != null) {
                    ReportQueryEditorPage.this.runNowButton.setEnabled(runNowOK);
                }
            }
        });
    }

    private String[] runJCLCheck() {
        block4: {
            IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
            IZOSConnectable connectable = (IZOSConnectable)connectionService.getConnectable("com.ibm.cics.zos.comm.connection");
            try {
                if (connectable != null && connectable.isConnected() && connectable.canPerform("ACTION_SUPPORT_JOBS", null) && "jcl".equalsIgnoreCase(((FileEditorInput)this.editor.getEditorInput()).getFile().getFileExtension()) && ((FileEditorInput)this.editor.getEditorInput()).getFile().exists()) {
                    if (((FileEditorInput)this.editor.getEditorInput()).getFile().findMaxProblemSeverity("com.ibm.cics.zos.ui.jclproblem", true, 0) >= 2) {
                        return new String[]{Messages.getString("ReportQueryEditor.job.errors.title"), Messages.getString("ReportQueryEditor.job.errors.description")};
                    }
                    break block4;
                }
                return new String[]{Messages.getString("ReportQueryEditor.job.nozos.title"), Messages.getString("ReportQueryEditor.job.nozos.description")};
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private void showRunJCLErrorMessage(String[] error) {
        MessageDialog mBox = new MessageDialog(UIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), error[0], null, error[1], 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        mBox.open();
    }

    private void runNow() {
        if (this.editor.isDirty()) {
            MessageDialog mBox = new MessageDialog(UIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("ReportQueryEditor.dialog.run.save.title"), null, Messages.getString("ReportQueryEditor.dialog.run.save.now"), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            if (mBox.open() == 0) {
                this.editor.doSave(null);
            } else {
                return;
            }
        }
        Job reportJob = new Job(Messages.getString("RunReport.job.text")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("RunReport.job.text"), 1);
                if (ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected()) {
                    ITypedRegion[] partitions = ReportQueryEditorPage.this.getDocument().getDocumentPartitioner().computePartitioning(0, ReportQueryEditorPage.this.getDocument().getLength());
                    DAParameterSet parameters = new DAParameterSet();
                    ITypedRegion[] iTypedRegionArray = partitions;
                    int n = partitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypedRegion region = iTypedRegionArray[n2];
                        if (region.getType().equals("__dftl_partition_content_type")) {
                            DAUtilities.createDAObjects(region.getOffset(), region.getLength(), ReportQueryEditorPage.this.getDocument(), parameters);
                            break;
                        }
                        ++n2;
                    }
                    if (parameters != null && parameters.findMaxProblemSeverity() < 2) {
                        String xmlMessage = DAMessageFactory.constructDeployMessage(parameters);
                        DeployMessageResponse mr = ConfigurationManager.getCurrent().deploy(xmlMessage);
                        if (mr.returnCode < 8) {
                            String jclFileExt;
                            IFile jclFile;
                            FileEditorInput fEditorInput;
                            String newFileName = "DAReportResult";
                            FileEditorInput fileEditorInput = fEditorInput = ReportQueryEditorPage.this.editor.getEditorInput() instanceof FileEditorInput ? (FileEditorInput)ReportQueryEditorPage.this.editor.getEditorInput() : null;
                            if (fEditorInput != null && (jclFile = fEditorInput.getFile()) != null && (jclFileExt = jclFile.getFileExtension()) != null && !jclFileExt.trim().isEmpty()) {
                                String jclFileName = jclFile.getName();
                                newFileName = jclFileName.substring(0, jclFileName.length() - jclFileExt.length() - 1);
                            }
                            final IFile daFile = ProjectManager.getNewDAReportFileName(newFileName);
                            final StringReader stringReader = new StringReader(DAReportFileManager.createDAReportXML(mr.getDataSources(), mr.getReportSets(), mr.getReportItems(), parameters.toCCVPARMSString()));
                            InputStream in = new InputStream(){

                                @Override
                                public int read() throws IOException {
                                    return stringReader.read();
                                }
                            };
                            try {
                                if (!daFile.exists()) {
                                    daFile.create(in, 1, null);
                                } else {
                                    daFile.setContents(in, 0, null);
                                }
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        UIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(daFile), "com.ibm.cics.cm.ui.da.dareportviewer");
                                    }
                                    catch (PartInitException partInitException) {
                                        // empty catch block
                                    }
                                }
                            });
                        } else {
                            return new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("RunReport.job.badRC"), mr.returnCode, mr.getReadableReturnCode(), mr.reasonCode, mr.getReadableReasonCode()));
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        reportJob.schedule();
    }

    private void checkDeployErrors() {
        Deploy deploy;
        if (this.parameters != null && (deploy = this.parameters.getDeployObject()) != null) {
            final List<MarkerInformation> errors = deploy.getErrors(false);
            if (errors.size() < 1) {
                this.editorForm.setMessage(null);
            } else {
                this.messageHyperlinkListener = new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        String page_id = ReportQueryEditorPage.this.editor.getJCLTextEditor().getId();
                        if (page_id != null) {
                            ReportQueryEditorPage.this.editor.setActivePage(page_id);
                        }
                        ReportQueryEditorPage.this.editor.getJCLTextEditor().setHighlightRange(((MarkerInformation)errors.get(0)).getDisplacement(), 0, true);
                    }
                };
                this.editorForm.setMessage(Messages.getString("Validation.JCL_CONTAINS_ERRORS"), 3);
                this.editorForm.addMessageHyperlinkListener((IHyperlinkListener)this.messageHyperlinkListener);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    private class FieldModifyListener
    implements ModifyListener {
        private FieldModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ReportQueryEditorPage.this.refreshDocument();
        }
    }
}

