/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.model.ReportItem;
import com.ibm.cics.cm.model.ReportItemAttribute;
import com.ibm.cics.cm.model.ReportSet;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.editors.DataSourceViewerHelper;
import com.ibm.cics.cm.ui.da.editors.ReportItemViewerHelper;
import com.ibm.cics.cm.ui.da.editors.ReportSetViewerHelper;
import com.ibm.cics.cm.ui.da.editors.ReportViewer;
import com.ibm.cics.cm.ui.da.model.Report;
import com.ibm.cics.cm.ui.da.model.ReportCategories;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.editor.HelpAction;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ReportPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ReportPage.class.getPackage().getName());
    public static final String PAGE_ID = "overviewpage";
    private FormEditor editor;
    private Report report;
    private Text reportNameText;
    private String messageId;

    public ReportPage(ReportViewer reportViewer) {
        super((FormEditor)reportViewer, PAGE_ID, Messages.getString("ReportViewer.page.main.title"));
        this.initialize(reportViewer);
        this.editor = reportViewer;
        if (this.editor != null) {
            this.report = reportViewer.getReport();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        IManagedForm mForm = managedForm;
        FormToolkit toolkit = mForm.getToolkit();
        Form form = mForm.getForm().getForm();
        final Composite body = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        body.setLayout((Layout)layout);
        toolkit.decorateFormHeading(form);
        form.setText(this.report.getName());
        form.setImage(this.editor.getTitleImage());
        HelpAction helpAction = new HelpAction(this.getHelpContextID());
        form.getToolBarManager().add((IAction)helpAction);
        form.updateToolBar();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, this.getHelpContextID());
        int sectionStyle = 322;
        int areaStyle = 0;
        int treeViewerStyle = 65554;
        Color keyLabelColour = Display.getCurrent().getSystemColor(16);
        Composite reportName = toolkit.createComposite(body, areaStyle);
        layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.marginWidth = 0;
        reportName.setLayout((Layout)layout);
        reportName.setLayoutData((Object)new GridData(4, 128, true, false));
        Label reportNameLabel = toolkit.createLabel(reportName, Messages.getString("ReportQueryEditor.reportName"));
        reportNameLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        int borderStyle = toolkit.getBorderStyle();
        toolkit.setBorderStyle(0);
        this.reportNameText = toolkit.createText(reportName, this.report.getName(), 0x40000008);
        this.reportNameText.setLayoutData((Object)new GridData(4, -1, true, false));
        toolkit.setBorderStyle(borderStyle);
        TextInput.setAccessibleLabel((Text)this.reportNameText, (Label)reportNameLabel);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 10;
        layout.marginWidth = 0;
        Section reportOptionsSection = toolkit.createSection(body, sectionStyle);
        reportOptionsSection.setText(Messages.getString("ReportViewer.page.main.section.reportoptions"));
        reportOptionsSection.setLayoutData((Object)this.getSectionGridData());
        Composite reportOptionsArea = toolkit.createComposite((Composite)reportOptionsSection, areaStyle);
        reportOptionsArea.setLayout((Layout)layout);
        reportOptionsSection.setClient((Control)reportOptionsArea);
        reportOptionsArea.setLayoutData((Object)this.getAreaGridData());
        borderStyle = toolkit.getBorderStyle();
        toolkit.setBorderStyle(0);
        Text reportOptionsText = toolkit.createText(reportOptionsArea, this.report.getJCL(), 74);
        GridData gd = new GridData(4, 16384, true, false);
        gd.widthHint = 300;
        reportOptionsText.setLayoutData((Object)gd);
        toolkit.setBorderStyle(borderStyle);
        reportOptionsText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        reportOptionsSection.setExpanded(false);
        Section dataSourcesSection = toolkit.createSection(body, sectionStyle);
        dataSourcesSection.setText(Messages.getString("ReportViewer.page.main.section.datasources"));
        dataSourcesSection.setLayoutData((Object)this.getSectionGridData());
        Composite dataSourcesArea = toolkit.createComposite((Composite)dataSourcesSection, areaStyle);
        dataSourcesArea.setLayout((Layout)layout);
        dataSourcesSection.setClient((Control)dataSourcesArea);
        dataSourcesArea.setLayoutData((Object)this.getAreaGridData());
        DataSourceViewerHelper dsHelper = new DataSourceViewerHelper();
        TableViewer viewer = new TableViewer(dataSourcesArea, treeViewerStyle);
        viewer.getTable().setLayoutData((Object)this.getTreeViewerGridData());
        viewer.setContentProvider((IContentProvider)new DataSourceViewerHelper.DataSourceContentProvider(dsHelper));
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        dsHelper.createColumns(viewer);
        viewer.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = String.valueOf(Messages.getString("ReportViewer.datasource.column.ID")) + ": " + e.result;
            }

            public void getDescription(AccessibleEvent e) {
                super.getDescription(e);
                e.result = e.result;
            }
        });
        viewer.setInput(this.report.getDataSources());
        if (viewer.getTable().getItemCount() > 0) {
            viewer.getTable().select(0);
        }
        Label trLabel = toolkit.createLabel(dataSourcesArea, Messages.getString("ReportViewer.datasource.key.tr"));
        trLabel.setForeground(keyLabelColour);
        trLabel.setLayoutData((Object)this.getLabelGridData());
        Label ccmLabel = toolkit.createLabel(dataSourcesArea, Messages.getString("ReportViewer.datasource.key.ccm"));
        ccmLabel.setForeground(keyLabelColour);
        ccmLabel.setLayoutData((Object)this.getLabelGridData());
        Section reportSummarySection = toolkit.createSection(body, sectionStyle);
        reportSummarySection.setText(Messages.getString("ReportViewer.page.main.section.reportsummary"));
        reportSummarySection.setLayoutData((Object)this.getSectionGridData());
        Composite reportSummaryArea = toolkit.createComposite((Composite)reportSummarySection, areaStyle);
        reportSummaryArea.setLayout((Layout)layout);
        reportSummarySection.setClient((Control)reportSummaryArea);
        reportSummaryArea.setLayoutData((Object)this.getAreaGridData());
        ReportSetViewerHelper rsHelper = new ReportSetViewerHelper(this.report);
        viewer = new TableViewer(reportSummaryArea, treeViewerStyle);
        viewer.getTable().setLayoutData((Object)this.getTreeViewerGridData());
        viewer.setContentProvider((IContentProvider)rsHelper.new ReportSetViewerHelper.ReportSetContentProvider());
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        rsHelper.createColumns(viewer);
        viewer.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = String.valueOf(MessageFormat.format(Messages.getString("ReportViewer.reportset.column.reportset"), 1)) + ": " + e.result;
            }

            public void getDescription(AccessibleEvent e) {
                super.getDescription(e);
                e.result = e.result;
            }
        });
        ArrayList<ReportSet.Tags> t = new ArrayList<ReportSet.Tags>();
        t.add(ReportSet.Tags.MATCHED_COUNT);
        t.add(ReportSet.Tags.MISMATCHED_COUNT);
        t.add(ReportSet.Tags.EXCLUDED_COUNT);
        viewer.setInput(t);
        if (viewer.getTable().getItemCount() > 0) {
            viewer.getTable().select(0);
        }
        Section filteringSummarySection = toolkit.createSection(body, sectionStyle);
        filteringSummarySection.setText(Messages.getString("ReportViewer.page.main.section.filteringsummary"));
        filteringSummarySection.setLayoutData((Object)this.getSectionGridData());
        Composite filteringSummaryArea = toolkit.createComposite((Composite)filteringSummarySection, areaStyle);
        filteringSummaryArea.setLayout((Layout)layout);
        filteringSummarySection.setClient((Control)filteringSummaryArea);
        filteringSummaryArea.setLayoutData((Object)this.getAreaGridData());
        viewer = new TableViewer(filteringSummaryArea, treeViewerStyle);
        viewer.getTable().setLayoutData((Object)this.getTreeViewerGridData());
        viewer.setContentProvider((IContentProvider)rsHelper.new ReportSetViewerHelper.ReportSetContentProvider());
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        rsHelper.createColumns(viewer);
        viewer.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = String.valueOf(MessageFormat.format(Messages.getString("ReportViewer.reportset.column.reportset"), 1)) + ": " + e.result;
            }

            public void getDescription(AccessibleEvent e) {
                super.getDescription(e);
                e.result = e.result;
            }
        });
        t = new ArrayList();
        t.add(ReportSet.Tags.MATCH_FILTERED_COUNT);
        t.add(ReportSet.Tags.NEW_FILTERED_COUNT);
        t.add(ReportSet.Tags.MISSING_FILTERED_COUNT);
        t.add(ReportSet.Tags.MISMATCH_FILTERED_COUNT);
        t.add(ReportSet.Tags.LIST_FILTERED_COUNT);
        t.add(ReportSet.Tags.DUPLICATE_COUNT);
        t.add(ReportSet.Tags.DUPLICATE_FILTER_COUNT);
        t.add(ReportSet.Tags.RI_CHECK_COUNT);
        t.add(ReportSet.Tags.RI_CHECK_FILTER_COUNT);
        t.add(ReportSet.Tags.FILTERED_COUNT);
        viewer.setInput(t);
        if (viewer.getTable().getItemCount() > 0) {
            viewer.getTable().select(0);
        }
        HashMap<Integer, ReportItem> items = this.report.getReportItems();
        HashMap<String, ArrayList<ReportItem>> itemsByCode = new HashMap<String, ArrayList<ReportItem>>();
        for (Map.Entry<Integer, ReportItem> e : items.entrySet()) {
            String catCode = (String)e.getValue().getAttributes().get(ReportItem.Tags.CLASSIFICATION.toString());
            ArrayList<ReportItem> al = (ArrayList<ReportItem>)itemsByCode.get(catCode);
            if (al == null) {
                al = new ArrayList<ReportItem>();
                itemsByCode.put(catCode, al);
            }
            al.add(e.getValue());
        }
        ReportItemViewerHelper riHelper = new ReportItemViewerHelper(this.report);
        ReportCategories.Catagories[] catagoriesArray = ReportCategories.Catagories.values();
        int al = catagoriesArray.length;
        int catCode = 0;
        while (catCode < al) {
            final ReportCategories.Catagories cat = catagoriesArray[catCode];
            String catCode2 = cat.getCode();
            ArrayList sectionItems = (ArrayList)itemsByCode.get(catCode2);
            if (sectionItems != null) {
                Section reportItemsSection = toolkit.createSection(body, sectionStyle);
                reportItemsSection.setText(cat.toString());
                reportItemsSection.setLayoutData((Object)this.getSectionGridData());
                Composite reportItemsArea = toolkit.createComposite((Composite)reportItemsSection, areaStyle);
                reportItemsArea.setLayout((Layout)layout);
                reportItemsSection.setClient((Control)reportItemsArea);
                reportItemsArea.setLayoutData((Object)this.getAreaGridData());
                final TreeViewer catViewer = new TreeViewer(reportItemsArea, treeViewerStyle);
                catViewer.getTree().setLayoutData((Object)this.getTreeViewerGridData());
                catViewer.setContentProvider((IContentProvider)new ReportItemViewerHelper.ReportItemContentProvider(riHelper));
                catViewer.getTree().setHeaderVisible(true);
                catViewer.getTree().setLinesVisible(true);
                catViewer.getTree().addTreeListener(new TreeListener(){

                    public void treeExpanded(TreeEvent e) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                body.layout(true);
                            }
                        });
                    }

                    public void treeCollapsed(TreeEvent e) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                body.layout(true);
                            }
                        });
                    }
                });
                riHelper.createColumns(catViewer, cat);
                catViewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                    public void getName(AccessibleEvent e) {
                        super.getName(e);
                        e.result = "";
                        TreeItem[] items = catViewer.getTree().getSelection();
                        if (items.length == 1) {
                            if (items[0].getData() != null) {
                                Object data = items[0].getData();
                                if (data instanceof ReportItem) {
                                    e.result = Messages.getString("ReportViewer.accessible.ReportItemSelected");
                                } else if (data instanceof ReportItemAttribute) {
                                    e.result = Messages.getString("ReportViewer.accessible.ReportItemAttributeSelected");
                                }
                            }
                        } else {
                            e.result = Messages.getString("ReportViewer.accessible.MultipleItemsSelected");
                        }
                        if (e.result == null || e.result.isEmpty()) {
                            e.result = MessageFormat.format(Messages.getString("ReportViewer.accessible.TableSelected"), cat.toString());
                        }
                    }

                    public void getDescription(AccessibleEvent e) {
                        super.getDescription(e);
                        e.result = "";
                        TreeItem[] items = catViewer.getTree().getSelection();
                        if (items.length > 0) {
                            e.result = "";
                            TreeItem[] treeItemArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem item = treeItemArray[n2];
                                if (item.getData() != null) {
                                    Object data = item.getData();
                                    if (data instanceof ReportItem) {
                                        int col = 0;
                                        while (col < catViewer.getTree().getColumnCount()) {
                                            e.result = String.valueOf(e.result) + " " + catViewer.getTree().getColumn(col).getText() + ": " + item.getText(col);
                                            ++col;
                                        }
                                    } else if (data instanceof ReportItemAttribute) {
                                        e.result = String.valueOf(Messages.getString("ReportViewer.attribute")) + ": " + ((ReportItemAttribute)data).getAttribute();
                                        e.result = String.valueOf(e.result) + ", " + Messages.getString("ReportViewer.value") + ": " + ((ReportItemAttribute)data).getValue();
                                    }
                                }
                                ++n2;
                            }
                        }
                        if (e.result == null || e.result.isEmpty()) {
                            e.result = Messages.getString("ReportViewer.accessible.SelectItemInTable");
                        }
                    }
                });
                catViewer.setInput((Object)sectionItems);
                if (catViewer.getTree().getItemCount() > 0) {
                    catViewer.getTree().select(catViewer.getTree().getItem(0));
                }
            }
            ++catCode;
        }
        ArrayList classificationNineReportItems = (ArrayList)itemsByCode.get(ReportCategories.Catagories.CAT09.getCode());
        HashSet<String> messagesIdSet = new HashSet<String>();
        if (classificationNineReportItems != null) {
            for (ReportItem reportItem : classificationNineReportItems) {
                this.messageId = reportItem.getReportVerify().getAtttributeValue((Enum)ReportItem.Tags.MSGID);
                if (this.messageId == null) continue;
                messagesIdSet.add(this.messageId);
            }
        }
        if (messagesIdSet != null) {
            Section reportItemsSection = toolkit.createSection(body, sectionStyle);
            reportItemsSection.setText(Messages.getString("ReportViewer.page.main.section.verificationmessages"));
            reportItemsSection.setLayoutData((Object)this.getSectionGridData());
            Composite reportItemsArea = toolkit.createComposite((Composite)reportItemsSection, areaStyle);
            TableWrapLayout tableLayout = new TableWrapLayout();
            tableLayout.makeColumnsEqualWidth = false;
            tableLayout.numColumns = 1;
            reportItemsArea.setLayout((Layout)tableLayout);
            reportItemsSection.setClient((Control)reportItemsArea);
            toolkit.adapt(reportItemsArea);
            FormText formText = toolkit.createFormText(reportItemsArea, true);
            formText.setWhitespaceNormalized(true);
            TableWrapData td = new TableWrapData(128);
            formText.setLayoutData((Object)td);
            StringBuffer buf = this.createHyperlinkStringBuffer(messagesIdSet);
            formText.setText(buf.toString(), true, false);
            formText.addHyperlinkListener(this.getActionsHyperlinkListener());
            reportItemsArea.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            toolkit.paintBordersFor(reportItemsArea);
            reportItemsSection.setClient((Control)reportItemsArea);
            if (viewer.getTable().getItemCount() > 0) {
                viewer.getTable().select(0);
            }
        }
    }

    private StringBuffer createHyperlinkStringBuffer(HashSet<String> messagesIdSet) {
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        for (String messageId : messagesIdSet) {
            buf.append("<li style=\"text\">");
            buf.append("<a href=\"" + this.getKnowledgeCentreUrl(messageId) + "\">" + messageId + "</a>");
            buf.append("</li>");
        }
        buf.append("</form>");
        return buf;
    }

    public String getKnowledgeCentreUrl(String messageId) {
        return "http://www.ibm.com/support/knowledgecenter/SS2L7A_5.4.0/com.ibm.cics.cm.doc/" + messageId.toLowerCase() + ".html";
    }

    private IHyperlinkListener getActionsHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                String url = href.toString();
                IWebBrowser browser = null;
                try {
                    browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("DEPLOYMENT_ANALYSIS_REPORT_BROWSER");
                    browser.openURL(new URL(url));
                }
                catch (PartInitException e1) {
                    Status status = new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ReportViewer.page.main.section.verificationmessages.browserFailedToOpen"), new Object[]{e1.getMessage(), e1}));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                }
                catch (MalformedURLException e2) {
                    Status status = new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ReportViewer.page.main.section.verificationmessages.malformedUrl"), e2.getMessage(), e2));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                }
            }
        };
    }

    private GridData getSectionGridData() {
        return new GridData(4, -1, true, false);
    }

    private GridData getAreaGridData() {
        return new GridData(4, -1, true, false, 1, 1);
    }

    private GridData getTreeViewerGridData() {
        return new GridData(4, -1, true, false);
    }

    private GridData getLabelGridData() {
        return new GridData(16384, -1, false, false);
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.da.report_viewer";
    }

    public void setFocus() {
        if (this.reportNameText != null) {
            this.reportNameText.setFocus();
        } else {
            super.setFocus();
        }
    }

    protected void refresh() {
    }
}

