/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.model.DataSource;
import com.ibm.cics.cm.ui.da.Messages;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;

public class DataSourceViewerHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EMPTY_STRING = "";

    protected void createColumns(TableViewer viewer) {
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.ID"), 40, true, true, DataSource.Tags.ID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.date"), 90, true, true, DataSource.Tags.DATE.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.time"), 75, true, true, DataSource.Tags.TIME.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.records"), 80, true, true, DataSource.Tags.RECORD_COUNT.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.collection_type"), 130, true, true, DataSource.Tags.TYPE.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.report_set"), 90, true, true, DataSource.Tags.REPORT_SET_ID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.smf_id"), 75, true, true, DataSource.Tags.SMFID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.tr.context"), 90, true, true, EMPTY_STRING);
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.tr.scope"), 90, true, true, EMPTY_STRING);
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.tr.appl_id"), 90, true, true, String.valueOf(DataSource.Tags.TARGET_REGION.toString()) + DataSource.Tags.APPL_ID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.tr.sys_id"), 90, true, true, String.valueOf(DataSource.Tags.TARGET_REGION.toString()) + DataSource.Tags.SYS_ID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.ccm.region"), 90, true, true, String.valueOf(DataSource.Tags.CCM_REGION.toString()) + DataSource.Tags.JOB_NAME.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.ccm.appl_id"), 95, true, true, String.valueOf(DataSource.Tags.CCM_REGION.toString()) + DataSource.Tags.APPL_ID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.ccm.sys_id"), 90, true, true, String.valueOf(DataSource.Tags.CCM_REGION.toString()) + DataSource.Tags.SYS_ID.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.ccm.cts_vrm"), 90, true, true, String.valueOf(DataSource.Tags.CCM_REGION.toString()) + DataSource.Tags.CTS_VRM.toString());
        this.createColumn(viewer, Messages.getString("ReportViewer.datasource.column.ccm.ccm_vrm"), 90, true, true, String.valueOf(DataSource.Tags.CCM_REGION.toString()) + DataSource.Tags.CCM_VRM.toString());
    }

    private TableViewerColumn createColumn(TableViewer viewer, String name, int width, boolean resizable, boolean moveable, String attr) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText(name);
        col.getColumn().setWidth(width);
        col.getColumn().setResizable(resizable);
        col.getColumn().setMoveable(moveable);
        col.setLabelProvider((CellLabelProvider)new CustomColumnLabelProvider(attr));
        return col;
    }

    private class CustomColumnLabelProvider
    extends ColumnLabelProvider {
        private String attribute;

        public CustomColumnLabelProvider(String attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            if (element instanceof DataSource && this.attribute != null) {
                DataSource item = (DataSource)element;
                HashMap attr = item.getAttributes();
                if (this.attribute.equals(DataSourceViewerHelper.EMPTY_STRING)) {
                    return DataSourceViewerHelper.EMPTY_STRING;
                }
                if (this.attribute.startsWith(DataSource.Tags.TARGET_REGION.toString())) {
                    String key = this.attribute.substring(DataSource.Tags.TARGET_REGION.toString().length());
                    String value = (String)item.getTargetRegion().getAttributes().get(key);
                    if (value != null) {
                        return value;
                    }
                    return DataSourceViewerHelper.EMPTY_STRING;
                }
                if (this.attribute.startsWith(DataSource.Tags.CCM_REGION.toString())) {
                    String key = this.attribute.substring(DataSource.Tags.CCM_REGION.toString().length());
                    String value = (String)item.getCCMRegion().getAttributes().get(key);
                    if (value != null) {
                        return value;
                    }
                    return DataSourceViewerHelper.EMPTY_STRING;
                }
                String value = (String)attr.get(this.attribute);
                if (value != null) {
                    if (this.attribute.equals(DataSource.Tags.RECORD_COUNT.toString())) {
                        return new Integer(value).toString();
                    }
                    if (this.attribute.equals(DataSource.Tags.TYPE.toString())) {
                        return DataSource.getCollectionType((String)value);
                    }
                    return value;
                }
            }
            return DataSourceViewerHelper.EMPTY_STRING;
        }
    }

    protected class DataSourceContentProvider
    implements IStructuredContentProvider {
        protected DataSourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((HashMap)inputElement).values().toArray();
        }
    }
}

