/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.ui.da.DAUtilities;
import com.ibm.cics.cm.ui.da.model.DAParameterSet;
import com.ibm.cics.cm.ui.da.model.MarkerInformation;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.zos.ui.editor.jcl.Validator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DAParmsValidator
implements Validator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DAParmsValidator.class);
    public static final String DA_PROBLEM_MARKER = "com.ibm.cics.cm.ui.daproblem";
    private IDocument document = null;
    private DAParameterSet parameters = null;
    private String specific;

    public DAParmsValidator(String program) {
        this.specific = program;
    }

    private IMarker createMarker(IFile file, String message, int line, int severity) throws CoreException {
        IMarker m = file.createMarker(DA_PROBLEM_MARKER);
        m.setAttribute("lineNumber", line);
        m.setAttribute("message", (Object)message);
        m.setAttribute("priority", 2);
        m.setAttribute("severity", severity);
        return m;
    }

    public Validator intialise(IDocument document, IFile file) {
        if (file != null) {
            try {
                file.deleteMarkers(DA_PROBLEM_MARKER, false, 0);
            }
            catch (CoreException e) {
                debug.error("intialise", (Throwable)e);
            }
        }
        this.document = document;
        this.parameters = new DAParameterSet();
        return this;
    }

    public void processRegion(int offset, int length) {
        debug.enter("processRegion");
        DAUtilities.createDAObjects(offset, length, this.document, this.parameters);
        debug.exit("processRegion");
    }

    public List<IMarker> stop(IFile file) {
        ArrayList<IMarker> results = new ArrayList<IMarker>();
        if (this.parameters != null) {
            for (MarkerInformation info : this.parameters.getErrors()) {
                try {
                    results.add(this.createMarker(file, info.getMessage(), this.document.getLineOfOffset(info.getDisplacement()) + 1, info.getSeverity()));
                }
                catch (BadLocationException e) {
                    try {
                        results.add(this.createMarker(file, info.getMessage(), 1, info.getSeverity()));
                    }
                    catch (CoreException e2) {
                        debug.error("stop", (Throwable)e2);
                    }
                }
                catch (CoreException e) {
                    debug.error("stop", (Throwable)e);
                }
            }
        }
        return results;
    }

    public String explicitProgramName() {
        return this.specific;
    }

    public DAParameterSet getParameterSet() {
        return this.parameters;
    }
}

