/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.editors;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.Group;
import com.ibm.cics.cm.ui.da.model.GrpList;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.utilities.ListeningArrayList;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddGrpDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button addButton;
    private CSDConfiguration configuration;
    private String configurationName;
    private GroupyType groupyType = GroupyType.GRPLIST;
    private Phase phase;
    private ListeningArrayList<DALabel> newGroupies;
    private Text nameText;

    public AddGrpDialog(Shell parentShell, String configurationName, Phase phase) {
        super(parentShell);
        Configuration configuration;
        this.configurationName = configurationName;
        this.configuration = configurationName != null && ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected() ? ((configuration = ConfigurationManager.getCurrent().getCachedConfiguration(configurationName)) != null && configuration instanceof CSDConfiguration ? (CSDConfiguration)configuration : null) : null;
        this.phase = phase;
        this.newGroupies = new ListeningArrayList();
        ListeningArrayList<DALabel> listeningArrayList = this.newGroupies;
        listeningArrayList.getClass();
        this.newGroupies.addListener(new ListeningArrayList.ArrayListListener(listeningArrayList, this.newGroupies){

            public void notify(boolean changed, ListeningArrayList<?> source) {
                boolean enabled = false;
                if (!source.isEmpty()) {
                    enabled = true;
                }
                if (AddGrpDialog.this.addButton != null) {
                    AddGrpDialog.this.addButton.setEnabled(enabled);
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        childArea.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        childArea.setLayout((Layout)gridLayout);
        this.setTitle(Messages.getString("GrpDialog.dialog.title"));
        this.getShell().setText(Messages.getString("GrpDialog.dialog.title"));
        this.setTitleImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_CSD_CONN_WIZ));
        this.setMessage(Messages.getString("GrpDialog.dialog.description"));
        Label configurationLabel = new Label(childArea, 0);
        configurationLabel.setText(Messages.getString("ReportQueryEditor.field.CONFIGURATION"));
        configurationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label configurationLabelValue = new Label(childArea, 0);
        configurationLabelValue.setText(!this.configurationName.contains("<") && !this.configurationName.contains(">") ? this.configurationName : "");
        configurationLabelValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label typeLabel = new Label(childArea, 0);
        typeLabel.setText(Messages.getString("GrpDialog.field.TYPE"));
        typeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Utilities.addMandatoryField((Control)typeLabel);
        Combo typeCombo = new Combo(childArea, 8);
        typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        boolean GRPLIST_index = false;
        boolean GROUP_index = true;
        String[] typeItems = new String[]{MessageFormat.format(Messages.getString("GrpDialog.field.TYPE.value.GRPLIST"), "GRPLIST"), MessageFormat.format(Messages.getString("GrpDialog.field.TYPE.value.GROUP"), "GROUP")};
        typeCombo.setItems(typeItems);
        typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddGrpDialog.this.groupyType = ((Combo)e.widget).getSelectionIndex() == 0 ? GroupyType.GRPLIST : GroupyType.GROUP;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label nameLabel = new Label(childArea, 0);
        nameLabel.setText(Messages.getString("GrpDialog.field.NAME"));
        nameLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        Utilities.addMandatoryField((Control)nameLabel);
        if (this.configuration == null) {
            TextInput nameInput = new TextInput(childArea, nameLabel);
            nameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.nameText = nameInput.text;
            this.nameText.setTextLimit(8);
            this.nameText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (((Text)e.widget).getText().trim().isEmpty()) {
                        AddGrpDialog.this.addButton.setEnabled(false);
                        AddGrpDialog.this.newGroupies.clear();
                    } else {
                        AddGrpDialog.this.addButton.setEnabled(true);
                        AddGrpDialog.this.newGroupies.clear();
                        AddGrpDialog.this.newGroupies.add((Object)(AddGrpDialog.this.groupyType == GroupyType.GRPLIST ? new GrpList(AddGrpDialog.this.nameText.getText().trim(), AddGrpDialog.this.phase) : new Group(AddGrpDialog.this.nameText.getText().trim(), AddGrpDialog.this.phase)));
                    }
                }
            });
        } else {
            final ListViewer groupyList = new ListViewer(childArea, 514);
            groupyList.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            groupyList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof Object[]) {
                        return (Object[])inputElement;
                    }
                    if (inputElement instanceof List) {
                        return ((List)inputElement).toArray();
                    }
                    return null;
                }
            });
            groupyList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof GrpList) {
                        return UIPlugin.getImage((ImageDescriptor)UIPlugin.IMGD_RESOURCE_DESCRIPTION_DEFINITION);
                    }
                    if (element instanceof Group) {
                        return UIPlugin.getImage((ImageDescriptor)UIPlugin.IMGD_RESOURCE_GROUP_DEFINITION);
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof GrpList || element instanceof Group) {
                        return ((DALabel)element).getLabel();
                    }
                    return null;
                }
            });
            groupyList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AddGrpDialog.this.newGroupies.clear();
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    for (Object groupy : selection.toList()) {
                        if (!(groupy instanceof GrpList) && !(groupy instanceof Group)) continue;
                        AddGrpDialog.this.newGroupies.add((Object)((DALabel)groupy));
                    }
                }
            });
            typeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddGrpDialog.this.refreshList(groupyList);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.refreshList(groupyList);
        }
        typeCombo.select(0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.cm.ui.da.grplist_group_add");
        return c;
    }

    private void refreshList(ListViewer viewer) {
        Object[] objects = null;
        ArrayList<DALabel> labels = new ArrayList<DALabel>();
        if (this.groupyType == GroupyType.GRPLIST) {
            objects = this.configuration.getResourceLists().getResults().toArray();
        } else if (this.groupyType == GroupyType.GROUP) {
            objects = this.configuration.getResourceGroups().getResults().toArray();
        }
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof CMObject) {
                    String name = ((CMObject)obj).getName();
                    if (this.groupyType == GroupyType.GRPLIST) {
                        labels.add(new GrpList(name, this.phase));
                    } else if (this.groupyType == GroupyType.GROUP) {
                        labels.add(new Group(name, this.phase));
                    }
                }
                ++n2;
            }
        }
        viewer.setInput((Object)labels.toArray());
        viewer.setSelection(null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.addButton = this.createButton(parent, 0, Messages.getString("GrpDialog.buttons.add"), true);
        this.addButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public List<DALabel> getNewGroupies() {
        return this.newGroupies;
    }

    private static enum GroupyType {
        GRPLIST,
        GROUP;

    }
}

