/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.dialogs;

import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.editor.jcl.ZOSJCLMessages;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class EditorSelectionDialog
extends ElementTreeSelectionDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(EditorSelectionDialog.class);
    private ImageDescriptor delete_image;
    private Text text;
    private TreeEditor editor;
    private IProject project;
    private IWorkbenchPartSite site;

    public EditorSelectionDialog(IWorkbenchPartSite site, IProject project) {
        super(site.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getName();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof IContainer) {
                    return Activator.getImage((String)"IMG_FOLDER");
                }
                if (element instanceof IFile && ((IFile)element).getFileExtension().equalsIgnoreCase("dar")) {
                    return UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_HISTORY_COMPARISON);
                }
                return ZOSActivator.getImage((String)"IMG_JCL");
            }
        }, new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object element) {
                ArrayList<IResource> children = new ArrayList<IResource>();
                if (element instanceof IContainer) {
                    try {
                        IResource[] iResourceArray = ((IContainer)element).members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource resource = iResourceArray[n2];
                            if (resource instanceof IFolder) {
                                children.add(resource);
                            } else if (resource instanceof IFile && ("jcl".equals(((IFile)resource).getFullPath().getFileExtension()) || "jct".equals(((IFile)resource).getFullPath().getFileExtension()) || "dar".equalsIgnoreCase(((IFile)resource).getFullPath().getFileExtension()))) {
                                children.add(resource);
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        debug.error("getChildren", (Throwable)e);
                    }
                }
                return children.toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IContainer) {
                    try {
                        return ((IContainer)element).members().length > 0;
                    }
                    catch (CoreException e) {
                        debug.error("hasChildren", (Throwable)e);
                    }
                }
                return false;
            }
        });
        this.project = project;
        this.site = site;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getTreeViewer().expandAll();
        this.editor = new TreeEditor(this.getTreeViewer().getTree());
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        final IAction delete = this.deleteAction();
        final IAction rename = this.renameAction();
        MenuManager menuManager = new MenuManager();
        Menu popUpMenu = menuManager.createContextMenu((Control)this.getTreeViewer().getTree());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (EditorSelectionDialog.this.getTreeViewer().getSelection().isEmpty()) {
                    return;
                }
                for (Object selected : ((StructuredSelection)EditorSelectionDialog.this.getTreeViewer().getSelection()).toList()) {
                    if (selected instanceof IFile && !((IFile)selected).getParent().getName().equals(ZOSJCLMessages.Folder_template) && !"jct".equals(((IFile)selected).getFullPath().getFileExtension())) continue;
                    return;
                }
                manager.add(delete);
                manager.add(rename);
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        this.getTreeViewer().getTree().setMenu(popUpMenu);
        this.getTreeViewer().getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    if (EditorSelectionDialog.this.getTreeViewer().getSelection().isEmpty()) {
                        return;
                    }
                    for (Object selected : ((StructuredSelection)EditorSelectionDialog.this.getTreeViewer().getSelection()).toList()) {
                        if (selected instanceof IFile && !((IFile)selected).getParent().getName().equals(ZOSJCLMessages.Folder_template) && !"jct".equals(((IFile)selected).getFullPath().getFileExtension())) continue;
                        return;
                    }
                    EditorSelectionDialog.this.doDelete((IFile)EditorSelectionDialog.this.getFirstResult());
                }
                if (e.keyCode == 0x100000B) {
                    if (EditorSelectionDialog.this.getTreeViewer().getSelection().isEmpty()) {
                        return;
                    }
                    for (Object selected : ((StructuredSelection)EditorSelectionDialog.this.getTreeViewer().getSelection()).toList()) {
                        if (selected instanceof IFile && !((IFile)selected).getParent().getName().equals(ZOSJCLMessages.Folder_template) && !"jct".equals(((IFile)selected).getFullPath().getFileExtension())) continue;
                        return;
                    }
                    EditorSelectionDialog.this.doRename();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0 && selection[0] instanceof IFile) {
                    if (EditorSelectionDialog.this.text != null && !EditorSelectionDialog.this.text.isDisposed()) {
                        String msg = ((IFile)selection[0]).getName();
                        return new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("EditorSelectionDialog_confirmRename"), msg));
                    }
                    String msg = ((IFile)selection[0]).getName();
                    return new Status(0, "com.ibm.cics.cm.ui", msg);
                }
                String msg = Messages.getString("EditorDialog.AFile");
                return new Status(4, "com.ibm.cics.cm.ui", msg);
            }
        });
        this.setInitialElementSelections(new ArrayList());
        this.setAllowMultiple(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getHelpContextID());
        return control;
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.da.editor_selection";
    }

    private IAction deleteAction() {
        Action deleteItem = new Action(Messages.getString("EditorSelectionDialog_deleteQuestion")){

            public void run() {
                IResource selectedResource = (IResource)EditorSelectionDialog.this.getFirstResult();
                if (selectedResource != null) {
                    EditorSelectionDialog.this.doDelete((IFile)EditorSelectionDialog.this.getFirstResult());
                }
            }

            public ImageDescriptor getImageDescriptor() {
                if (EditorSelectionDialog.this.delete_image == null) {
                    try {
                        EditorSelectionDialog.this.delete_image = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.eclipse.common/icons/full/elcl16/delete.gif"));
                    }
                    catch (MalformedURLException e) {
                        debug.error("getImageDescriptor", (Throwable)e);
                    }
                }
                return EditorSelectionDialog.this.delete_image;
            }
        };
        return deleteItem;
    }

    private IAction renameAction() {
        Action renameItem = new Action(Messages.getString("EditorSelectionDialog_renameQuestion")){

            public void run() {
                EditorSelectionDialog.this.doRename();
            }
        };
        return renameItem;
    }

    protected void doDelete(IFile selectedResource) {
        String selectionName = selectedResource.getName();
        String message = NLS.bind((String)Messages.getString("EditorSelectionDialog_deleteQuestion"), (Object)selectionName);
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog d = new MessageDialog(this.getShell(), Messages.getString("EditorSelectionDialog_confirmDelete"), null, message, 3, buttons, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        if (d.open() == 0) {
            try {
                selectedResource.delete(true, null);
                this.getTreeViewer().refresh();
            }
            catch (CoreException e) {
                debug.error("doDelete", (Throwable)e);
            }
        }
    }

    protected void doRename() {
        final TreeItem item = this.getTreeViewer().getTree().getSelection()[0];
        this.text = new Text((Composite)this.getTreeViewer().getTree(), 0);
        this.text.setText(item.getText());
        this.text.selectAll();
        this.text.setFocus();
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                EditorSelectionDialog.this.setText(item, EditorSelectionDialog.this.text.getText());
                EditorSelectionDialog.this.text.dispose();
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.keyCode) {
                    case 13: {
                        EditorSelectionDialog.this.setText(item, EditorSelectionDialog.this.text.getText());
                        EditorSelectionDialog.this.text.dispose();
                        break;
                    }
                    case 27: {
                        EditorSelectionDialog.this.text.dispose();
                        EditorSelectionDialog.this.updateOKStatus();
                    }
                }
            }
        });
        this.editor.setEditor((Control)this.text, item);
        this.updateOKStatus();
    }

    private void setText(TreeItem item, String text) {
        IPath path;
        IFile file;
        if (!text.endsWith(".jcl")) {
            text = String.valueOf(text) + ".jcl";
        }
        if ((file = (IFile)item.getData()).exists() && (path = file.getParent().getFullPath()).isValidPath(text)) {
            final boolean[] done = new boolean[]{Boolean.FALSE, Boolean.FALSE};
            try {
                file.move(path.append(text), true, (IProgressMonitor)new NullProgressMonitor(){

                    public void done() {
                        if (!done[0]) {
                            done[0] = true;
                            Job jb2 = new Job(""){

                                protected IStatus run(IProgressMonitor monitor) {
                                    EditorSelectionDialog.this.setInput(null);
                                    try {
                                        EditorSelectionDialog.this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor(){

                                            public void done() {
                                                if (!done[1]) {
                                                    done[1] = true;
                                                    Display.getDefault().asyncExec(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            EditorSelectionDialog.this.setInput(EditorSelectionDialog.this.project);
                                                            EditorSelectionDialog.this.getTreeViewer().refresh();
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }
                                    catch (CoreException e) {
                                        debug.error("setText1", (Throwable)e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            jb2.schedule();
                            jb2.setPriority(20);
                            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)EditorSelectionDialog.this.site.getAdapter(IWorkbenchSiteProgressService.class);
                            siteService.schedule(jb2);
                        }
                    }
                });
            }
            catch (CoreException e) {
                debug.error("setText2", (Throwable)e);
            }
        }
    }
}

