/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.composites;

import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.editors.ValidationUtilities;
import com.ibm.cics.cm.ui.da.model.Connection;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.ui.widgets.CSDConnectionsForConfigurationTextInput;
import com.ibm.cics.cm.utilities.Utilities;
import java.util.HashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CSDRuntimeOptions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Phase phase;
    private CSDConnectionsForConfigurationTextInput connectionInput;

    public CSDRuntimeOptions(Composite runtime, FormToolkit toolkit, Phase pPhase, HashMap<Control, String> controls) {
        String connectionName;
        this.phase = pPhase;
        Label connectionLabel = toolkit.createLabel(runtime, Messages.getString("ReportQueryEditor.field.CONNECTION"));
        controls.put((Control)connectionLabel, "csd");
        Utilities.addMandatoryField((Control)connectionLabel);
        this.connectionInput = new CSDConnectionsForConfigurationTextInput(runtime, connectionLabel);
        controls.put((Control)this.connectionInput, "csd");
        this.connectionInput.setLayoutData((Object)new GridData(16384, -1, false, false));
        Text connectionText = this.connectionInput.text;
        connectionText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        connectionText.addFocusListener(ValidationUtilities.getControlFocusValidationListener(this.phase.getConnection()));
        connectionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Text) {
                    Text connection = (Text)e.widget;
                    if (CSDRuntimeOptions.this.phase != null) {
                        String connectionString;
                        if (CSDRuntimeOptions.this.phase.getConnection() == null) {
                            CSDRuntimeOptions.this.phase.setConnection(new Connection("", CSDRuntimeOptions.this.phase));
                        }
                        if ((connectionString = connection.getText()) != null && !connectionString.trim().isEmpty()) {
                            CSDRuntimeOptions.this.phase.getConnection().setLabel(connectionString);
                        } else {
                            CSDRuntimeOptions.this.phase.getConnection().setLabel("<Connection used by the CICS CM server>");
                        }
                    }
                }
            }
        });
        connectionText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CSDRuntimeOptions.this.phase.getConnection() == null || CSDRuntimeOptions.this.phase.getConnection().getLabel().trim().isEmpty() || CSDRuntimeOptions.this.phase.getConnection().getLabel().equals("<Connection used by the CICS CM server>")) {
                    CSDRuntimeOptions.this.phase.setConnection(null);
                }
            }
        });
        if (this.phase != null && this.phase.getConnection() != null && (connectionName = this.phase.getConnection().getLabel()) != null && !connectionName.isEmpty()) {
            if (!connectionName.contains("<") || !connectionName.contains(">")) {
                connectionText.setText(connectionName);
            } else {
                connectionText.setText("");
            }
        }
    }

    public CSDConnectionsForConfigurationTextInput getConnectionInput() {
        return this.connectionInput;
    }
}

