/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.composites;

import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.editors.AddGrpDialog;
import com.ibm.cics.cm.ui.da.editors.ValidationUtilities;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.Group;
import com.ibm.cics.cm.ui.da.model.GrpList;
import com.ibm.cics.cm.ui.da.model.Localsysid;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class CSDCandidateOptions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text localSysIDText;
    private Phase phase;
    private ImageHyperlink removeGroupy;
    private ImageHyperlink upGroupy;
    private ImageHyperlink downGroupy;
    private TableViewer groupiesViewer;

    public CSDCandidateOptions(Composite candidates, FormToolkit toolkit, Phase pPhase, HashMap<Control, String> controls) {
        String localSysID;
        this.phase = pPhase;
        Label localSysIDLabel = toolkit.createLabel(candidates, Messages.getString("ReportQueryEditor.field.LOCALSYSID"));
        controls.put((Control)localSysIDLabel, "csd");
        Utilities.addMandatoryField((Control)localSysIDLabel);
        TextInput localSysIDInput = new TextInput(candidates, localSysIDLabel);
        localSysIDInput.setLayoutData((Object)new GridData(16384, -1, false, false));
        localSysIDInput.setNumberOfCharacters(8);
        controls.put((Control)localSysIDInput, "csd");
        this.localSysIDText = localSysIDInput.text;
        this.localSysIDText.setTextLimit(8);
        this.localSysIDText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.localSysIDText.addFocusListener(ValidationUtilities.getControlFocusValidationListener(this.phase.getLocalSYSID()));
        this.localSysIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Text) {
                    Text localSysID = (Text)e.widget;
                    if (CSDCandidateOptions.this.phase != null) {
                        String localSysIDString;
                        if (CSDCandidateOptions.this.phase.getLocalSYSID() == null) {
                            CSDCandidateOptions.this.phase.setLocalSYSID(new Localsysid("", CSDCandidateOptions.this.phase));
                        }
                        if ((localSysIDString = localSysID.getText()) != null && !localSysIDString.trim().isEmpty()) {
                            CSDCandidateOptions.this.phase.getLocalSYSID().setLabel(localSysIDString);
                        } else {
                            CSDCandidateOptions.this.phase.getLocalSYSID().setLabel("<CICS sysid evaluated as local>");
                        }
                    }
                }
            }
        });
        this.localSysIDText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CSDCandidateOptions.this.phase.getLocalSYSID() == null || CSDCandidateOptions.this.phase.getLocalSYSID().getLabel().trim().isEmpty() || CSDCandidateOptions.this.phase.getLocalSYSID().getLabel().equals("<CICS sysid evaluated as local>")) {
                    CSDCandidateOptions.this.phase.setLocalSYSID(null);
                }
            }
        });
        Label grplistGroupLabel = toolkit.createLabel(candidates, Messages.getString("ReportQueryEditor.field.GRPLIST-GROUP"));
        controls.put((Control)grplistGroupLabel, "csd");
        grplistGroupLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        Utilities.addMandatoryField((Control)grplistGroupLabel);
        Table groupiesTable = new Table(candidates, 67586);
        this.groupiesViewer = new TableViewer(groupiesTable);
        controls.put((Control)groupiesTable, "csd");
        TableColumn groupiesColumn = new TableColumn(groupiesTable, 16384);
        groupiesColumn.setWidth(200);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = 120;
        gridData.widthHint = 200;
        groupiesTable.setLayoutData((Object)gridData);
        groupiesTable.setHeaderVisible(false);
        groupiesTable.setLinesVisible(true);
        this.groupiesViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                DALabel item = null;
                if (element instanceof GrpList) {
                    item = (GrpList)element;
                } else if (element instanceof Group) {
                    item = (Group)element;
                } else {
                    return null;
                }
                if (columnIndex == 0) {
                    return item.getLabel();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (element instanceof GrpList) {
                        return UIPlugin.getImage((ImageDescriptor)UIPlugin.IMGD_RESOURCE_DESCRIPTION_DEFINITION);
                    }
                    if (element instanceof Group) {
                        return UIPlugin.getImage((ImageDescriptor)UIPlugin.IMGD_RESOURCE_GROUP_DEFINITION);
                    }
                    return null;
                }
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.groupiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<DALabel> list = new ArrayList<DALabel>();
                if (inputElement instanceof Object[]) {
                    Object[] objArray;
                    Object[] objectArray = objArray = (Object[])inputElement;
                    int n = objArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof GrpList || obj instanceof Group) {
                            DALabel label = (DALabel)obj;
                            String text = label.getLabel();
                            if (!text.contains("<") || !text.contains(">")) {
                                list.add(label);
                            } else {
                                CSDCandidateOptions.this.phase.getGroupies().remove(label);
                            }
                        }
                        ++n2;
                    }
                }
                return list.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        Composite groupiesButtons = toolkit.createComposite(candidates, 0);
        controls.put((Control)groupiesButtons, "csd");
        groupiesButtons.setLayoutData((Object)new GridData(131072, 128, false, false, 2, 1));
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        groupiesButtons.setLayout((Layout)gl);
        ImageHyperlink addGroupy = toolkit.createImageHyperlink(groupiesButtons, 0);
        addGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ADD));
        addGroupy.setToolTipText(Messages.getString("ReportQueryEditor.link.add.groupy"));
        addGroupy.setLayoutData((Object)new GridData(131072, 128, false, false));
        addGroupy.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                List<DALabel> groupies;
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                AddGrpDialog dialog = new AddGrpDialog(parent, CSDCandidateOptions.this.phase.getConfiguration() != null ? CSDCandidateOptions.this.phase.getConfiguration().getLabel() : "", CSDCandidateOptions.this.phase);
                if (dialog.open() == 0 && (groupies = dialog.getNewGroupies()) != null && !groupies.isEmpty()) {
                    CSDCandidateOptions.this.phase.getGroupies().addAll(groupies);
                    CSDCandidateOptions.this.refreshGroupiesViewer();
                }
            }
        });
        this.removeGroupy = toolkit.createImageHyperlink(groupiesButtons, 0);
        this.removeGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_DELETE_DISABLED));
        this.removeGroupy.setToolTipText(Messages.getString("ReportQueryEditor.link.delete.groupy"));
        this.removeGroupy.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.removeGroupy.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                StructuredSelection structured;
                ISelection selection = CSDCandidateOptions.this.groupiesViewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    List<DALabel> list = CSDCandidateOptions.this.phase.getGroupies();
                    Object[] objectArray = structured.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof DALabel) {
                            list.remove(obj);
                        }
                        ++n2;
                    }
                    CSDCandidateOptions.this.refreshGroupiesViewer();
                }
                CSDCandidateOptions.this.checkButtons(selection, CSDCandidateOptions.this.groupiesViewer);
            }
        });
        this.upGroupy = toolkit.createImageHyperlink(groupiesButtons, 0);
        this.upGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ARROW_UP_DISABLED));
        this.upGroupy.setToolTipText(Messages.getString("ReportQueryEditor.link.move.groupy.up"));
        this.upGroupy.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.upGroupy.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                StructuredSelection structured;
                ISelection selection = CSDCandidateOptions.this.groupiesViewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    List<DALabel> list = CSDCandidateOptions.this.phase.getGroupies();
                    Object[] objectArray = structured.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int currentIndex;
                        Object obj = objectArray[n2];
                        if (obj instanceof DALabel && (currentIndex = list.indexOf(obj)) != 0) {
                            list.remove(obj);
                            list.add(currentIndex - 1, (DALabel)obj);
                        }
                        ++n2;
                    }
                    CSDCandidateOptions.this.refreshGroupiesViewer();
                }
                CSDCandidateOptions.this.checkButtons(selection, CSDCandidateOptions.this.groupiesViewer);
            }
        });
        this.downGroupy = toolkit.createImageHyperlink(groupiesButtons, 0);
        this.downGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ARROW_DOWN_DISABLED));
        this.downGroupy.setToolTipText(Messages.getString("ReportQueryEditor.link.move.groupy.down"));
        this.downGroupy.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.downGroupy.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                StructuredSelection structured;
                ISelection selection = CSDCandidateOptions.this.groupiesViewer.getSelection();
                if (selection instanceof StructuredSelection && !(structured = (StructuredSelection)selection).isEmpty()) {
                    List<DALabel> list = CSDCandidateOptions.this.phase.getGroupies();
                    Object[] objs = structured.toArray();
                    int i = objs.length - 1;
                    while (i > -1) {
                        int currentIndex;
                        Object obj = objs[i];
                        if (obj instanceof DALabel && (currentIndex = list.indexOf(obj)) != list.size() - 1) {
                            list.remove(obj);
                            list.add(currentIndex + 1, (DALabel)obj);
                        }
                        --i;
                    }
                    CSDCandidateOptions.this.refreshGroupiesViewer();
                }
                CSDCandidateOptions.this.checkButtons(selection, CSDCandidateOptions.this.groupiesViewer);
            }
        });
        this.groupiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof TableViewer) {
                    CSDCandidateOptions.this.checkButtons(event.getSelection(), (TableViewer)event.getSource());
                }
            }
        });
        if (this.phase != null && this.phase.getLocalSYSID() != null && (localSysID = this.phase.getLocalSYSID().getLabel()) != null && !localSysID.isEmpty()) {
            if (!localSysID.contains("<") || !localSysID.contains(">")) {
                this.localSysIDText.setText(localSysID);
            } else {
                this.localSysIDText.setText("");
            }
        }
        this.refreshGroupiesViewer();
    }

    public Text getLocalSysIDText() {
        return this.localSysIDText;
    }

    public TableViewer getGroupiesTableViewer() {
        return this.groupiesViewer;
    }

    public void refreshGroupiesViewer() {
        if (this.phase != null && this.phase.getGroupies() != null) {
            List<DALabel> groupies = this.phase.getGroupies();
            this.groupiesViewer.setInput((Object)groupies.toArray());
            ValidationUtilities.validateControl((Control)this.groupiesViewer.getTable(), this.phase.getGroupiesErrors());
        }
    }

    public void checkButtons(ISelection selection, TableViewer viewer) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structured = (StructuredSelection)selection;
            this.removeGroupy.setEnabled(false);
            this.removeGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_DELETE_DISABLED));
            this.upGroupy.setEnabled(false);
            this.upGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ARROW_UP_DISABLED));
            this.downGroupy.setEnabled(false);
            this.downGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ARROW_DOWN_DISABLED));
            if (!structured.isEmpty()) {
                this.removeGroupy.setEnabled(true);
                this.removeGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_DELETE));
                int count = viewer.getTable().getItemCount();
                int[] index = viewer.getTable().getSelectionIndices();
                if (count > 1 && index[0] > 0) {
                    this.upGroupy.setEnabled(true);
                    this.upGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ARROW_UP));
                }
                if (count > 1 && index[index.length - 1] < count - 1) {
                    this.downGroupy.setEnabled(true);
                    this.downGroupy.setImage(UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ARROW_DOWN));
                }
            }
            this.removeGroupy.redraw();
            this.removeGroupy.update();
            this.upGroupy.redraw();
            this.upGroupy.update();
            this.downGroupy.redraw();
            this.downGroupy.update();
        }
    }
}

