/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da.builder;

import com.ibm.cics.cm.model.DataSource;
import com.ibm.cics.cm.model.ReportItem;
import com.ibm.cics.cm.model.ReportSet;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.ui.da.model.Report;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DAReportFileManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String createDAReportXML(HashMap<Integer, DataSource> dataSources, HashMap<Integer, ReportSet> reportSets, HashMap<Integer, ReportItem> reportItems, String JCL) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<DAREPORT>");
        buffer.append("<JCL>");
        buffer.append(JCL);
        buffer.append("</JCL>");
        buffer.append("<DATASOURCES>");
        for (DataSource dataSource : dataSources.values()) {
            buffer.append("<" + DataSource.Tags.DATA_SOURCE_ELEMENT.toString() + ">");
            for (String key : dataSource.getAttributes().keySet()) {
                buffer.append("<" + key + ">" + (String)dataSource.getAttributes().get(key) + "</" + key + ">");
            }
            buffer.append("<" + DataSource.Tags.TARGET_REGION.toString() + ">");
            for (String key : dataSource.getTargetRegion().getAttributes().keySet()) {
                buffer.append("<" + key + ">" + (String)dataSource.getTargetRegion().getAttributes().get(key) + "</" + key + ">");
            }
            buffer.append("</" + DataSource.Tags.TARGET_REGION.toString() + ">");
            buffer.append("<" + DataSource.Tags.CCM_REGION.toString() + ">");
            for (String key : dataSource.getCCMRegion().getAttributes().keySet()) {
                buffer.append("<" + key + ">" + (String)dataSource.getCCMRegion().getAttributes().get(key) + "</" + key + ">");
            }
            buffer.append("</" + DataSource.Tags.CCM_REGION.toString() + ">");
            buffer.append("</" + DataSource.Tags.DATA_SOURCE_ELEMENT.toString() + ">");
        }
        buffer.append("</DATASOURCES>");
        buffer.append("<REPORTSETS>");
        for (ReportSet reportSet : reportSets.values()) {
            buffer.append("<" + ReportSet.Tags.REPORT_SET_ELEMENT.toString() + ">");
            for (String key : reportSet.getAttributes().keySet()) {
                buffer.append("<" + key + ">" + (String)reportSet.getAttributes().get(key) + "</" + key + ">");
            }
            buffer.append("</" + ReportSet.Tags.REPORT_SET_ELEMENT.toString() + ">");
        }
        buffer.append("</REPORTSETS>");
        buffer.append("<REPORTITEMS>");
        for (ReportItem reportItem : reportItems.values()) {
            buffer.append("<" + ReportItem.Tags.REPORT_LINE_ELEMENT + ">");
            for (String key : reportItem.getAttributes().keySet()) {
                buffer.append("<" + key + ">" + (String)reportItem.getAttributes().get(key) + "</" + key + ">");
            }
            buffer.append("<" + ReportItem.Tags.REPORTVERIFY + ">");
            for (String v : reportItem.getReportVerify().getAttributes().keySet()) {
                buffer.append("<" + v + ">" + (String)reportItem.getReportVerify().getAttributes().get(v) + "</" + v + ">");
            }
            buffer.append("</" + ReportItem.Tags.REPORTVERIFY + ">");
            buffer.append("<" + ReportItem.Tags.REPORTDIFFERENCES + ">");
            for (String v : reportItem.getReportDifferences().getAttributes().keySet()) {
                buffer.append("<" + v + ">" + (String)reportItem.getReportDifferences().getAttributes().get(v) + "</" + v + ">");
            }
            buffer.append("</" + ReportItem.Tags.REPORTDIFFERENCES + ">");
            buffer.append("</" + ReportItem.Tags.REPORT_LINE_ELEMENT + ">");
        }
        buffer.append("</REPORTITEMS>");
        buffer.append("</DAREPORT>");
        return buffer.toString();
    }

    public static Report createDAReportFromXML(InputStream in, String reportName) {
        SAXParser parser = null;
        try {
            DAFileHandler fh = new DAFileHandler();
            if (parser == null) {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parser = parserFactory.newSAXParser();
            }
            parser.parse(in, (DefaultHandler)((Object)fh));
            return new Report(fh.getDataSources(), fh.getReportSets(), fh.getReportItems(), fh.getJCL(), reportName);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        parser.reset();
        return null;
    }

    private static class DAFileHandler
    extends MessageResponse {
        protected static final String startObjectTag = "DAREPORT";
        private HashMap<Integer, DataSource> dataSources = new HashMap();
        private HashMap<Integer, ReportSet> reportSets = new HashMap();
        private HashMap<Integer, ReportItem> reportItems = new HashMap();
        private boolean inObject = false;
        private boolean inDataSourceElement = false;
        private boolean inReportSetElement = false;
        private boolean inReportLineElement = false;
        private boolean inTargetRegionElement = false;
        private boolean inCCMRegionElement = false;
        private boolean inReportVerifyElement = false;
        private boolean inReportDifferencesElement = false;
        private int reportItemCount = 1;
        private String jcl = "";
        private DataSource currentDataSource = null;
        private ReportSet currentReportSet = null;
        private ReportItem currentReportItem = null;

        private DAFileHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            this.status = 1;
            if (this.status == 1) {
                if (startObjectTag.equalsIgnoreCase(name)) {
                    this.inObject = true;
                } else if (DataSource.Tags.DATA_SOURCE_ELEMENT.toString().equals(name)) {
                    this.inDataSourceElement = true;
                    this.currentDataSource = new DataSource();
                } else if (ReportSet.Tags.REPORT_SET_ELEMENT.toString().equals(name)) {
                    this.inReportSetElement = true;
                    this.currentReportSet = new ReportSet();
                } else if (ReportItem.Tags.REPORT_LINE_ELEMENT.toString().equals(name)) {
                    this.inReportLineElement = true;
                    this.currentReportItem = new ReportItem();
                } else if (this.inDataSourceElement && DataSource.Tags.TARGET_REGION.toString().equals(name)) {
                    this.inTargetRegionElement = true;
                } else if (this.inDataSourceElement && DataSource.Tags.CCM_REGION.toString().equals(name)) {
                    this.inCCMRegionElement = true;
                } else if (this.inReportLineElement && ReportItem.Tags.REPORTVERIFY.toString().equals(name)) {
                    this.inReportVerifyElement = true;
                } else if (this.inReportLineElement && ReportItem.Tags.REPORTDIFFERENCES.toString().equals(name)) {
                    this.inReportDifferencesElement = true;
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            super.endElement(uri, localName, name);
            if (this.status == 1) {
                if (startObjectTag.equalsIgnoreCase(name)) {
                    this.inObject = false;
                } else if (this.inObject) {
                    if (name.equals("JCL")) {
                        this.jcl = this.getCurrentTagValue();
                    }
                    if (DataSource.Tags.DATA_SOURCE_ELEMENT.toString().equals(name)) {
                        this.inDataSourceElement = false;
                        if (this.currentDataSource != null && this.currentDataSource.getId() != -1) {
                            this.dataSources.put(this.currentDataSource.getId(), this.currentDataSource);
                        }
                        this.currentDataSource = null;
                    } else if (ReportSet.Tags.REPORT_SET_ELEMENT.toString().equals(name)) {
                        this.inReportSetElement = false;
                        if (this.currentReportSet != null && this.currentReportSet.getId() != -1) {
                            this.reportSets.put(this.currentReportSet.getId(), this.currentReportSet);
                        }
                        this.currentReportSet = null;
                    } else if (ReportItem.Tags.REPORT_LINE_ELEMENT.toString().equals(name)) {
                        this.inReportLineElement = false;
                        if (this.currentReportItem != null && this.currentReportItem.getId() != -1) {
                            this.reportItems.put(this.reportItemCount++, this.currentReportItem);
                        }
                        this.currentReportItem = null;
                    } else if (this.inDataSourceElement) {
                        if (DataSource.Tags.TARGET_REGION.toString().equals(name)) {
                            this.inTargetRegionElement = false;
                        } else if (DataSource.Tags.CCM_REGION.toString().equals(name)) {
                            this.inCCMRegionElement = false;
                        } else if (this.inTargetRegionElement) {
                            this.currentDataSource.getTargetRegion().addAttribute(name, this.getCurrentTagValue());
                        } else if (this.inCCMRegionElement) {
                            this.currentDataSource.getCCMRegion().addAttribute(name, this.getCurrentTagValue());
                        } else {
                            this.currentDataSource.addAttribute(name, this.getCurrentTagValue());
                        }
                    } else if (this.inReportSetElement) {
                        this.currentReportSet.addAttribute(name, this.getCurrentTagValue());
                    } else if (this.inReportLineElement) {
                        if (ReportItem.Tags.REPORTVERIFY.toString().equals(name)) {
                            this.inReportVerifyElement = false;
                        } else if (ReportItem.Tags.REPORTDIFFERENCES.toString().equals(name)) {
                            this.inReportDifferencesElement = false;
                        } else if (this.inReportVerifyElement) {
                            this.currentReportItem.getReportVerify().addAttribute(name, this.getCurrentTagValue());
                        } else if (this.inReportDifferencesElement) {
                            this.currentReportItem.getReportDifferences().addAttribute(name, this.getCurrentTagValue());
                        } else {
                            this.currentReportItem.addAttribute(name, this.getCurrentTagValue());
                        }
                    }
                }
            }
        }

        public String getJCL() {
            return this.jcl;
        }

        public HashMap<Integer, DataSource> getDataSources() {
            return this.dataSources;
        }

        public HashMap<Integer, ReportSet> getReportSets() {
            return this.reportSets;
        }

        public HashMap<Integer, ReportItem> getReportItems() {
            return this.reportItems;
        }
    }
}

