/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.da;

import com.ibm.cics.cm.ui.da.Messages;
import com.ibm.cics.cm.ui.da.ProjectManager;
import com.ibm.cics.cm.ui.da.builder.DAResourceProcessor;
import com.ibm.cics.cm.ui.da.editors.DACustomiserFactory;
import com.ibm.cics.cm.ui.da.model.Configuration;
import com.ibm.cics.cm.ui.da.model.Connect;
import com.ibm.cics.cm.ui.da.model.Connection;
import com.ibm.cics.cm.ui.da.model.DALabel;
import com.ibm.cics.cm.ui.da.model.DAParameterSet;
import com.ibm.cics.cm.ui.da.model.Deploy;
import com.ibm.cics.cm.ui.da.model.FilterDataSet;
import com.ibm.cics.cm.ui.da.model.Group;
import com.ibm.cics.cm.ui.da.model.GrpList;
import com.ibm.cics.cm.ui.da.model.Localsysid;
import com.ibm.cics.cm.ui.da.model.Phase;
import com.ibm.cics.cm.ui.da.model.PhaseReportType;
import com.ibm.cics.cm.ui.da.model.Ready;
import com.ibm.cics.cm.ui.da.model.ReportSetLabel;
import com.ibm.cics.cm.ui.da.model.Scope;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.builder.IResourceProcessor;
import com.ibm.cics.zos.ui.editor.jcl.CustomiserFactory;
import java.io.IOException;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DAUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DAUtilities.class);

    public static void initialise() {
        debug.enter("initialise");
        Job job = new Job(Messages.getString("EarlyStartup.LoadMessage")){

            protected IStatus run(IProgressMonitor monitor) {
                ZOSActivator.getDefault().addResourceProcessor((IResourceProcessor)new DAResourceProcessor());
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IProject project;
                        IEditorPart editor;
                        IWorkbenchPage page;
                        CustomiserFactory.setInstance((CustomiserFactory)new DACustomiserFactory());
                        IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (workbench != null && (page = workbench.getActivePage()) != null && (editor = page.getActiveEditor()) != null && editor.getSite().getId().equals("com.ibm.cics.jcl_editor")) {
                            IEditorInput input = editor.getEditorInput();
                            page.closeEditor(editor, false);
                            try {
                                page.openEditor(input, "com.ibm.cics.jcl_editor");
                            }
                            catch (PartInitException e) {
                                debug.error("earlyStartup", (Throwable)e);
                            }
                        }
                        if ((project = ZOSActivator.getDefault().getRootProject(Messages.getString("NewProject_project_name"))) != null) {
                            try {
                                ProjectManager.initialise(project);
                            }
                            catch (IOException e) {
                                debug.error("run", (Throwable)e);
                            }
                            catch (CoreException e) {
                                debug.error("run", (Throwable)e);
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        debug.exit("initialise");
    }

    public static void createDAObjects(int offset, int length, IDocument document, DAParameterSet parameters) {
        Connect connect = null;
        Deploy deploy = null;
        Ready ready = null;
        Phase currentPhase = null;
        Configuration currentConfiguration = null;
        debug.enter("createDAObjects");
        String allDA = null;
        try {
            allDA = document.get(offset, length);
        }
        catch (BadLocationException e) {
            debug.error("createDAObjects", (Throwable)e);
            return;
        }
        if (document.get().indexOf("CCVBMAIN") > -1) {
            String[] tokens = allDA.split("[ \\t\\n\\x0B\\f\\r,]+");
            int position = 0;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                DALabel g;
                StringTokenizer st;
                String token = stringArray[n2];
                position = allDA.indexOf(token, position);
                if (token.equals("CONNECT")) {
                    connect = new Connect();
                    connect.setDisplacement(position + offset);
                    parameters.setConnectObject(connect);
                } else if (token.equals("DEPLOY")) {
                    deploy = new Deploy();
                    deploy.setDisplacement(position + offset);
                    parameters.setDeployObject(deploy);
                } else if (token.equals("READY") || token.equals("UNREADY") || token.equals("MIGRATE") || token.equals("BACKOUT") || token.equals("INSTALL") || token.equals("APPROVE") || token.equals("DISAPPROVE")) {
                    ready = new Ready(token);
                    ready.setDisplacement(position + offset);
                    parameters.setReadyObject(ready);
                } else if (token.startsWith("IPADDRESS")) {
                    st = new StringTokenizer(token, "=");
                    if (st.countTokens() > 1) {
                        st.nextToken();
                        if (connect != null) {
                            connect.setIpAddress(DAUtilities.checkToken(st.nextToken(), allDA, position + "IPADDRESS".length() + 1));
                        }
                    }
                } else if (token.startsWith("PORT")) {
                    st = new StringTokenizer(token, "=");
                    if (st.countTokens() > 1) {
                        st.nextToken();
                        if (connect != null) {
                            connect.setPort(DAUtilities.checkToken(st.nextToken(), allDA, position + "PORT".length() + 1));
                        }
                    }
                } else if (token.startsWith("SSL")) {
                    st = new StringTokenizer(token, "=");
                    if (st.countTokens() > 1) {
                        st.nextToken();
                        if (connect != null) {
                            connect.setSSL(DAUtilities.checkToken(st.nextToken(), allDA, position + "SSL".length() + 1));
                        }
                    }
                } else if (token.startsWith("PHASE")) {
                    if (deploy != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        currentPhase = new Phase(DAUtilities.checkToken(st.nextToken(), allDA, position + "PHASE".length() + 1));
                        currentPhase.setDisplacement(position + offset);
                        deploy.addPhase(currentPhase);
                    }
                } else if (token.startsWith("REPORTSET")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        ReportSetLabel reportset = new ReportSetLabel();
                        reportset.setDisplacement(position + offset);
                        reportset.setType(DAUtilities.checkToken(st.nextToken(), allDA, position + "REPORTSET".length() + 1));
                        currentPhase.setReportset(reportset);
                    }
                } else if (token.startsWith("TYPE")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        PhaseReportType ty = new PhaseReportType(DAUtilities.checkToken(st.nextToken(), allDA, position + "TYPE".length() + 1));
                        ty.setDisplacement(position + offset);
                        currentPhase.setPhaseReportType(ty);
                    }
                } else if (token.startsWith("CONFIGURATION")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        currentConfiguration = new Configuration(DAUtilities.checkToken(st.nextToken(), allDA, position + "CONFIGURATION".length() + 1));
                        currentConfiguration.setDisplacement(position + offset);
                        currentPhase.setConfiguration(currentConfiguration);
                    }
                } else if (token.startsWith("GROUP")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        g = new Group(DAUtilities.checkToken(st.nextToken(), allDA, position + "GROUP".length() + 1), currentPhase);
                        g.setDisplacement(position + offset);
                        currentPhase.addGroup((Group)g);
                    }
                } else if (token.startsWith("GRPLIST")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        g = new GrpList(DAUtilities.checkToken(st.nextToken(), allDA, position + "GRPLIST".length() + 1), currentPhase);
                        g.setDisplacement(position + offset);
                        currentPhase.addGrpList((GrpList)g);
                    }
                } else if (token.startsWith("LOCALSYSID")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        Localsysid sysid = new Localsysid(DAUtilities.checkToken(st.nextToken(), allDA, position + "LOCALSYSID".length() + 1), currentPhase);
                        sysid.setDisplacement(position + offset);
                        currentPhase.setLocalSYSID(sysid);
                    }
                } else if (token.startsWith("SCOPE")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        Scope scope = new Scope(DAUtilities.checkToken(st.nextToken(), allDA, position + "SCOPE".length() + 1), currentPhase);
                        scope.setDisplacement(position + offset);
                        currentPhase.setScope(scope);
                    }
                } else if (token.startsWith("FILTERDATASET")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        FilterDataSet fds = new FilterDataSet(DAUtilities.checkToken(st.nextToken(), allDA, position + "FILTERDATASET".length() + 1));
                        fds.setDisplacement(position + offset);
                        currentPhase.setFilterDSN(fds);
                    }
                } else if (token.startsWith("CONNECTION")) {
                    if (currentPhase != null && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                        st.nextToken();
                        Connection connection = new Connection(DAUtilities.checkToken(st.nextToken(), allDA, position + "CONNECTION".length() + 1), currentPhase);
                        connection.setDisplacement(position + offset);
                        currentPhase.setConnection(connection);
                    }
                } else if (token.startsWith("CPID")) {
                    st = new StringTokenizer(token, "=");
                    if (st.countTokens() > 1) {
                        st.nextToken();
                        if (ready != null) {
                            ready.setCpid(DAUtilities.checkToken(st.nextToken(), allDA, position + "CPID".length() + 1));
                        }
                    }
                } else if (token.startsWith("SCHEME") && (st = new StringTokenizer(token, "=")).countTokens() > 1) {
                    st.nextToken();
                    if (ready != null) {
                        ready.setScheme(DAUtilities.checkToken(st.nextToken(), allDA, position + "SCHEME".length() + 1));
                    }
                }
                position += token.length();
                ++n2;
            }
        }
        debug.exit("createDAObjects");
    }

    private static String checkToken(String value, String allDA, int position) {
        int end;
        int start = value.indexOf(60);
        if (start > -1 && (end = value.indexOf(62, start)) == -1) {
            value = DAUtilities.finishComment(allDA, position);
        }
        return value;
    }

    private static String finishComment(String allDA, int position) {
        Pattern pattern = Pattern.compile("[>\\n\\x0B\\f\\r,]+");
        String smallAllDA = allDA.substring(position);
        Scanner scanner = new Scanner(smallAllDA);
        scanner.useDelimiter(pattern);
        String append = "";
        if (scanner.hasNext() && smallAllDA.substring((append = scanner.next()).length()).startsWith(">")) {
            append = String.valueOf(append) + ">";
        }
        return append;
    }
}

