/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.Node;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionElementList;
import java.util.ArrayList;
import java.util.List;

public class RestrictionCriteriaList
extends Node
implements Cloneable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<RestrictionElementList> restrictionElementLists;
    private RestrictionElementList firstElementList = new RestrictionElementList();

    public RestrictionCriteriaList() {
        this.restrictionElementLists = new ArrayList<RestrictionElementList>();
        this.restrictionElementLists.add(this.firstElementList);
    }

    @Override
    public String getName() {
        return "RESTRICTIONCRITERIA";
    }

    public RestrictionElementList getFirstElementList() {
        return this.firstElementList;
    }

    public List<RestrictionElementList> getRestrictionElementLists() {
        return this.restrictionElementLists;
    }

    public void add(RestrictionElementList restrictionElementList) {
        if (this.firstElementList.isEmpty()) {
            this.restrictionElementLists.remove(this.firstElementList);
            this.firstElementList = restrictionElementList;
        }
        this.restrictionElementLists.add(restrictionElementList);
    }

    @Override
    public Element createElement(Element parentElement) {
        if (this.restrictionElementLists.isEmpty()) {
            return null;
        }
        Element restrictionCriteriaElement = parentElement.createChild("RESTRICTIONCRITERIA");
        restrictionCriteriaElement.createChild("RESTRICTIONCOUNT", Integer.toString(this.restrictionElementLists.size()));
        for (RestrictionElementList restrictionElementList : this.restrictionElementLists) {
            restrictionElementList.createElement(restrictionCriteriaElement);
        }
        return restrictionCriteriaElement;
    }

    public void add(RestrictionCriteria restrictionCriteria) {
        this.firstElementList.addUnique(restrictionCriteria);
    }

    public RestrictionCriteriaList clone() throws CloneNotSupportedException {
        RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
        List<RestrictionElementList> restrictionElementListsToCopyFrom = this.getRestrictionElementLists();
        for (RestrictionElementList restrictionElementList : restrictionElementListsToCopyFrom) {
            RestrictionElementList copyOfRestrictionElementList = (RestrictionElementList)restrictionElementList.clone();
            restrictionCriteriaList.add(copyOfRestrictionElementList);
        }
        return restrictionCriteriaList;
    }

    public void removeCriteriaForFieldName(String name) {
        if (this.firstElementList != null) {
            this.firstElementList.removeCriteriaForFieldName(name);
        }
    }
}

