/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.ObjectData;
import java.util.ArrayList;
import java.util.List;

public class ResourceListObjectData
extends ObjectData {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<String> groups = new ArrayList<String>();

    public void addGroup(String groupName) {
        this.groups.add(groupName);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public Element createElement(Element parentElement) {
        Element element = super.createElement(parentElement);
        if (!this.groups.isEmpty()) {
            Element rGroup = element.createChild("RGroup");
            rGroup.createChild("LISTGROUPCOUNT", Integer.toString(this.groups.size()));
            for (String group : this.groups) {
                Element rElement = rGroup.createChild("RGroupElement");
                rElement.createChild("LISTGROUP", group);
            }
        }
        return element;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }
}

