/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.ListElement;
import com.ibm.cics.cm.model.runtime.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectCriteriaList
extends Node {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    HashMap<String, String> extraParms = null;
    protected List<ListElement> listElements = new ArrayList<ListElement>();

    @Override
    public String getName() {
        return "OBJECTCRITERIA";
    }

    public Map<String, String> getAttributesAtIndex(int index) {
        return this.listElements.get((int)index).attributes;
    }

    public static ObjectCriteriaList newObjectCriteriaList() {
        ObjectCriteriaList objectCriteriaList = new ObjectCriteriaList();
        return objectCriteriaList;
    }

    public ListElement addListElement(String group, String type, String name) {
        ListElement le = new ListElement(group, type, name);
        this.listElements.add(le);
        return le;
    }

    public void addListElement(ListElement le) {
        this.listElements.add(le);
    }

    public void addObjectParameter(String key, String value) {
        if (this.extraParms == null) {
            this.extraParms = new HashMap();
        }
        this.extraParms.put(key, value);
    }

    @Override
    public Element createElement(Element parentElement) {
        if (this.listElements.isEmpty()) {
            return null;
        }
        Element element = parentElement.createChild(this.getName());
        if (this.extraParms != null) {
            for (String key : this.extraParms.keySet()) {
                element.createChild(key, this.extraParms.get(key));
            }
        }
        element.createChild("LISTCOUNT", Integer.toString(this.listElements.size()));
        for (ListElement listElement : this.listElements) {
            listElement.createElement(element);
        }
        return element;
    }
}

