/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InquireMessageResponse
extends MessageResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String startObjectTag = "OBJECTDATA";
    protected String RGROUP = "RGROUP";
    protected String MROCount = "MROCOUNT";
    protected String LTVCount = "LTVCOUNT";
    protected String RGroupElement = "RGROUPELEMENT";
    private HashMap<String, String> currentObject;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, String> currentRGroupObject;
    private List<Map<String, String>> rGroupObjects;
    private boolean inObject;
    private boolean inRGroup;
    private int totalRGroupElements;
    private int elementCount;
    private boolean inRGRoupElement;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.status == 1) {
            if (this.startObjectTag.equalsIgnoreCase(name)) {
                this.inObject = true;
                this.currentObject = new HashMap();
                this.rGroupObjects = new ArrayList<Map<String, String>>();
            }
            if (this.RGROUP.equals(name)) {
                this.inRGroup = true;
            }
            if (this.inRGroup && this.RGroupElement.equals(name)) {
                this.inRGRoupElement = true;
                this.currentRGroupObject = new HashMap<String, String>();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.status == 1) {
            if (this.startObjectTag.equalsIgnoreCase(name)) {
                this.inObject = false;
            } else if (this.inObject) {
                if (this.RGROUP.equals(name)) {
                    this.inRGroup = false;
                    this.totalRGroupElements = 0;
                    this.elementCount = 0;
                } else if (this.inRGroup) {
                    if (this.MROCount.equals(name) || this.LTVCount.equals(name)) {
                        this.totalRGroupElements = Integer.parseInt(this.getCurrentTagValue());
                        this.elementCount = 0;
                        this.currentObject.put(name, this.getCurrentTagValue());
                    } else if (this.RGroupElement.equals(name)) {
                        this.inRGRoupElement = false;
                        ++this.elementCount;
                        this.rGroupObjects.add(this.currentRGroupObject);
                    } else {
                        this.currentObject.put(String.valueOf(name) + this.elementCount, this.getCurrentTagValue());
                        if (this.inRGRoupElement) {
                            this.currentRGroupObject.put(name, this.getCurrentTagValue());
                        }
                    }
                } else if (this.currentObject.containsKey("TYPE") && this.currentObject.get("TYPE").equalsIgnoreCase("APPLDEF")) {
                    if (name.equalsIgnoreCase("APPLNAME")) {
                        this.currentObject.put("NAME", this.getCurrentTagValue());
                    } else if (name.equalsIgnoreCase("NAME")) {
                        this.currentObject.put("ALIAS", this.getCurrentTagValue());
                    } else {
                        this.currentObject.put(name, this.getCurrentTagValue());
                    }
                } else {
                    this.currentObject.put(name, this.getCurrentTagValue());
                }
            }
        }
    }

    public Map<String, String> getObject() {
        return this.currentObject;
    }

    public List<Map<String, String>> getRGroupObjects() {
        return this.rGroupObjects;
    }
}

