/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HistoryMessageResponse
extends MessageResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, String> beforeObject;
    private Map<String, String> afterObject;
    private Map<String, String> journalObject;
    private Map<String, String> currentTags;
    protected String BEFOREIMAGE = "BEFOREIMAGE";
    protected String AFTERIMAGE = "AFTERIMAGE";
    private boolean type;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.status == 1) {
            if (this.BEFOREIMAGE.equals(name)) {
                if (this.journalObject == null) {
                    this.journalObject = this.currentTags;
                }
                this.initializeCurrentTags();
            } else if (this.AFTERIMAGE.equals(name)) {
                if (this.journalObject == null) {
                    this.journalObject = this.currentTags;
                }
                this.initializeCurrentTags();
            } else if ("OBJECTDATA".equals(name)) {
                this.initializeCurrentTags();
            }
        }
    }

    private void initializeCurrentTags() {
        this.currentTags = new HashMap<String, String>();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.status == 1) {
            if (this.BEFOREIMAGE.equalsIgnoreCase(name)) {
                this.beforeObject = this.currentTags;
                this.initializeCurrentTags();
            } else if (this.AFTERIMAGE.equals(name)) {
                this.afterObject = this.currentTags;
                this.initializeCurrentTags();
            } else if ("OBJECTDATA".equals(name)) {
                if (this.journalObject == null) {
                    this.journalObject = this.currentTags;
                } else if (this.currentTags != null && !this.currentTags.isEmpty()) {
                    this.journalObject.putAll(this.currentTags);
                }
                this.initializeCurrentTags();
            } else if (this.currentTags != null) {
                this.currentTags.put(name, this.getCurrentTagValue());
            }
        }
    }

    public Map<String, String> getBeforeObject() {
        return this.beforeObject;
    }

    public Map<String, String> getAfterObject() {
        return this.afterObject;
    }

    public Map<String, String> getJournalObject() {
        return this.journalObject;
    }
}

