/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import java.util.HashMap;
import java.util.Map;

public class ChangePackageRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ChangePackageRegistry instance = new ChangePackageRegistry();
    Map<String, ChangePackage> cachedPackages = new HashMap<String, ChangePackage>();

    public ChangePackageRegistry() {
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if (event.getConnectionCategoryId().equals(CMSMConnection.ID)) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        ChangePackageRegistry.this.clearCachedData();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        ChangePackageRegistry.this.clearCachedData();
                    }
                }
            }
        });
    }

    private void clearCachedData() {
        this.cachedPackages.clear();
    }

    public void addPackage(ChangePackage cPackage) {
        this.cachedPackages.put(cPackage.getName(), cPackage);
    }

    public ChangePackage getPackage(String name) {
        return this.cachedPackages.get(name);
    }

    public boolean isCached(String name) {
        return this.cachedPackages.containsKey(name);
    }

    public static ChangePackageRegistry getInstance() {
        return instance;
    }
}

