/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.definitions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.definitions.ApplicationDefinition;
import com.ibm.cics.cm.model.definitions.CICSRegionDefinition;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupDefinition;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupMember;
import com.ibm.cics.cm.model.definitions.PlatformDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.model.definitions.WorkloadSpecificationDefinition;
import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.CICSRegionDefinitionType;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.core.model.CSDListDefinitionType;
import com.ibm.cics.core.model.PlatformDefinitionType;
import com.ibm.cics.core.model.ResourceDescriptionDefinitionType;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.model.TransactionGroupType;
import com.ibm.cics.core.model.WorkloadDefinitionType;
import com.ibm.cics.core.model.WorkloadGroupType;
import com.ibm.cics.core.model.WorkloadSpecificationType;
import com.ibm.cics.model.ICICSType;
import java.util.Map;

public class ResourceDefinitionFactory
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static ICMObject getObject(Configuration configuration, Map<String, String> attributes) {
        return ResourceDefinitionFactory.getObject(configuration, attributes, true);
    }

    public static ICMObject getObject(Configuration configuration, Map<String, String> attributes, boolean skinny) {
        String type = attributes.get("TYPE");
        if ("APPLDEF".equals(type)) {
            return new ApplicationDefinition(configuration, attributes, skinny);
        }
        if ("PLATDEF".equals(type)) {
            return new PlatformDefinition(configuration, attributes, skinny);
        }
        if ("CSYSDEF".equals(type)) {
            return new CICSRegionDefinition(configuration, attributes, skinny);
        }
        if ("CSYSGRP".equals(type)) {
            return new CICSRegionGroupDefinition(configuration, attributes, skinny);
        }
        if ("CSGLCGCS".equals(type) || "CSGLCGCG".equals(type)) {
            return new CICSRegionGroupMember(configuration, attributes, skinny, type);
        }
        if ("WLMSPEC".equals(type)) {
            return new WorkloadSpecificationDefinition(configuration, attributes, skinny);
        }
        return new ResourceDefinition(configuration, attributes, skinny);
    }

    public static boolean isCMResourceType(String resourceType) {
        ICICSType cicsType = CICSTypes.findForResourceTableName((String)resourceType);
        return cicsType != null && (cicsType instanceof AbstractCICSDefinitionType || cicsType instanceof ResourceGroupDefinitionType || cicsType instanceof CSDListDefinitionType || cicsType instanceof ResourceDescriptionDefinitionType || cicsType instanceof ApplicationDefinitionType || cicsType instanceof PlatformDefinitionType || cicsType instanceof CICSRegionDefinitionType || cicsType instanceof CICSRegionGroupDefinitionType || cicsType instanceof WorkloadSpecificationType || cicsType instanceof WorkloadGroupType || cicsType instanceof WorkloadDefinitionType || cicsType instanceof TransactionGroupType);
    }

    public static boolean isCMCPSMResourceDefinitionType(String resourceType) {
        ICICSType cicsType = CICSTypes.findForResourceTableName((String)resourceType);
        return cicsType != null && (cicsType instanceof ApplicationDefinitionType || cicsType instanceof PlatformDefinitionType || cicsType instanceof CICSRegionDefinitionType || cicsType instanceof CICSRegionGroupDefinitionType || cicsType instanceof WorkloadSpecificationType || cicsType instanceof WorkloadGroupType || cicsType instanceof WorkloadDefinitionType || cicsType instanceof TransactionGroupType);
    }

    public static boolean isCMCPSMResourceAssociationType(String resourceType) {
        return resourceType != null && (resourceType.equals("CSGLCGCS") || resourceType.equals("CSGLCGCG") || resourceType.equals("LNKSWSCS") || resourceType.equals("LNKSWSCG") || resourceType.equals("WLMINSPC") || resourceType.equals("WLMINGRP") || resourceType.equals("DTRINGRP"));
    }
}

