/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.definitions;

import com.ibm.cics.cm.model.CMDefinition;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.model.ICICSDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

public class ResourceDefinition
extends CMDefinition
implements ICMDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public Configuration configuration;
    public ResourceDefinitionGroup resourceGroup;
    protected String type;
    public String integrityToken;
    private Map<String, String> fullAttributes;
    private String resourceGroupName;
    private boolean skinny;
    private String defver;
    private HistoryProviderDelegate historyProviderDelegate;
    private String checksum;

    protected ResourceDefinition(Configuration configuration, Map<String, String> attributes, boolean skinny) {
        super(attributes);
        this.configuration = configuration;
        this.type = attributes.get("TYPE");
        this.resourceGroupName = attributes.get("GROUP");
        this.defver = attributes.get("DEFVER");
        this.skinny = skinny;
        this.checksum = attributes.get("HASHINGVALUE");
    }

    @Override
    public IFilteredCollection<History> getHistory(boolean includeRuntimeEvents, List<IRestrictionCriteria> filters) {
        return this.getResourceGroup() != null ? this.getIHistoryProvider().getHistory(true, filters) : null;
    }

    @Override
    public IFilteredCollection<History> getHistory(List<IRestrictionCriteria> filters) {
        return this.getResourceGroup() != null ? this.getIHistoryProvider().getHistory(filters) : null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ResourceDefinitionGroup getResourceGroup() {
        if (this.resourceGroup == null) {
            this.resourceGroup = this.getConfiguration().getResourceGroup(this.getResourceGroupName());
        }
        return this.resourceGroup;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isSkinny() {
        return this.skinny;
    }

    @Override
    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    public ICICSDefinition asCICSDefinition() {
        Object adaptedObj = Platform.getAdapterManager().getAdapter((Object)this, ICICSDefinition.class);
        if (adaptedObj != null && adaptedObj instanceof ICICSDefinition) {
            return (ICICSDefinition)adaptedObj;
        }
        return null;
    }

    @Override
    protected void fillAttributes(Map<String, String> anAttributesMap) {
        this.skinny = false;
        super.fillAttributes(anAttributesMap);
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.isSkinny()) {
            ObjectCriteria anObjectCriteria = this.getResourceGroup() != null ? ObjectCriteria.newObjectCriteriaForGroup(this.getResourceGroup().getName(), this.getType(), this.getName()) : ObjectCriteria.newObjectCriteriaForOrphanedResource(this.getType(), this.getName(), this.defver);
            LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
            try {
                InquireMessageResponse messageResponse = ConfigurationManager.getCurrent().getConnection().inquire(locationCriteria, anObjectCriteria);
                Map<String, String> attributes = messageResponse.getObject();
                this.fillAttributes(attributes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getAttributes();
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof ResourceDefinition) {
            ResourceDefinition anotherDefinition = (ResourceDefinition)anObject;
            return this.getConfiguration().equals(anotherDefinition.getConfiguration()) && this.getResourceGroupName().equals(anotherDefinition.getResourceGroupName()) && this.getType().equals(anotherDefinition.getType()) && this.getName().equals(anotherDefinition.getName());
        }
        return false;
    }

    @Override
    public Date getHistoryFromDate() {
        return this.getIHistoryProvider().getHistoryFromDate();
    }

    @Override
    public Date getHistoryToDate() {
        return this.getIHistoryProvider().getHistoryToDate();
    }

    @Override
    public void setToDate(Date toDate) {
        this.getIHistoryProvider().setToDate(toDate);
    }

    @Override
    public void setFromDate(Date fromDate) {
        this.getIHistoryProvider().setFromDate(fromDate);
    }

    @Override
    public String getHistoryFromDateAsDisplay() {
        return this.getIHistoryProvider().getHistoryFromDateAsDisplay();
    }

    @Override
    public String getHistoryToDateAsDisplay() {
        return this.getIHistoryProvider().getHistoryToDateAsDisplay();
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        if (this.historyProviderDelegate == null) {
            this.historyProviderDelegate = new HistoryProviderDelegate(this){

                @Override
                protected List<RestrictionCriteria> getAdditionalCriteria() {
                    ArrayList<RestrictionCriteria> arrayList = new ArrayList<RestrictionCriteria>();
                    arrayList.add(new RestrictionCriteria("JNLOBJNAME", FilterExpression.Operator.EQ, this.getName()));
                    arrayList.add(new RestrictionCriteria("B_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    arrayList.add(new RestrictionCriteria("A_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    return arrayList;
                }

                @Override
                protected JournalCriteria getJournalCriteria() {
                    return JournalCriteria.newJournalCriteriaForDefinition(this.getConfiguration().getName(), ResourceDefinition.this.getResourceGroupName(), ResourceDefinition.this.type, this.getName());
                }

                @Override
                protected JournalCriteria getJournalEventCriteria() {
                    return JournalCriteria.newJournalEventCriteriaForDefinition(this.getConfiguration().getName(), ResourceDefinition.this.getResourceGroupName(), ResourceDefinition.this.type, this.getName());
                }

                @Override
                protected ICMObject getObject(Map<String, String> attributes) {
                    return new History(this, attributes);
                }
            };
        }
        return this.historyProviderDelegate;
    }

    public static ArrayList<String> getSupportedChecksums() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("NONE");
        results.add("PARTIAL");
        results.add("FULL");
        results.add("CRITICAL");
        results.add("NAME");
        return results;
    }
}

