/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.definitions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupMember;
import com.ibm.cics.cm.model.definitions.CPSMNoGroupDefinition;
import com.ibm.cics.cm.model.definitions.ICICSRegionGroupDefinition;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CICSRegionGroupDefinition
extends CPSMNoGroupDefinition
implements ICICSRegionGroupDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HistoryProviderDelegate historyProviderDelegate;
    private ArrayList<CICSRegionGroupMember> groupMembers;

    protected CICSRegionGroupDefinition(Configuration configuration, Map<String, String> attributes, boolean skinny) {
        super(configuration, attributes, skinny);
    }

    @Override
    public boolean equals(Object anObject) {
        if (anObject instanceof CICSRegionGroupDefinition) {
            CICSRegionGroupDefinition anotherDefinition = (CICSRegionGroupDefinition)anObject;
            return this.getConfiguration().equals(anotherDefinition.getConfiguration()) && this.getType().equals(anotherDefinition.getType()) && this.getAttributes().get("GROUP").equals(anotherDefinition.getAttributes().get("GROUP"));
        }
        return false;
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        if (this.historyProviderDelegate == null) {
            this.historyProviderDelegate = new HistoryProviderDelegate(this){

                @Override
                protected List<RestrictionCriteria> getAdditionalCriteria() {
                    ArrayList<RestrictionCriteria> arrayList = new ArrayList<RestrictionCriteria>();
                    arrayList.add(new RestrictionCriteria("JNLOBJNAME", FilterExpression.Operator.EQ, this.getName()));
                    arrayList.add(new RestrictionCriteria("B_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    arrayList.add(new RestrictionCriteria("A_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    return arrayList;
                }

                @Override
                protected JournalCriteria getJournalCriteria() {
                    return JournalCriteria.newJournalCriteriaForDefinition(this.getConfiguration().getName(), "", CICSRegionGroupDefinition.this.type, this.getName());
                }

                @Override
                protected JournalCriteria getJournalEventCriteria() {
                    return JournalCriteria.newJournalEventCriteriaForDefinition(this.getConfiguration().getName(), "", CICSRegionGroupDefinition.this.type, this.getName());
                }

                @Override
                protected ICMObject getObject(Map<String, String> attributes) {
                    return new History(this, attributes);
                }

                @Override
                public String getName() {
                    return CICSRegionGroupDefinition.this.getAttributes().get("GROUP");
                }
            };
        }
        return this.historyProviderDelegate;
    }

    @Override
    public ArrayList<CICSRegionGroupMember> getMembers(boolean forceRefresh) {
        if (this.groupMembers == null || forceRefresh) {
            this.groupMembers = ConfigurationManager.getCurrent().getSystemGroupMembers(this.getResourceGroupName(), this.configuration);
            if (this.groupMembers != null) {
                for (CICSRegionGroupMember member : this.groupMembers) {
                    member.getMembers(forceRefresh);
                }
            }
        }
        return this.groupMembers;
    }
}

